/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.capability;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.nbt.CompoundNBT;
import ovh.corail.tombstone.capability.IFriendlyAnimal;
import ovh.corail.tombstone.entity.ai.FollowOwnerGoal;
import ovh.corail.tombstone.entity.ai.OwnerHurtByTargetGoal;
import ovh.corail.tombstone.entity.ai.OwnerHurtTargetGoal;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.network.CMessageServant;
import ovh.corail.tombstone.network.PacketHandler;

public class FriendlyAnimalImpl
implements IFriendlyAnimal {
    @Nullable
    protected UUID ownerId = null;
    private static final String FRIENDLY_OWNER_ID = "friendly_owner_id";

    @Override
    public Optional<UUID> getOwnerId() {
        return Optional.ofNullable(this.ownerId);
    }

    @Override
    public void setOwnerId(@Nullable UUID ownerId) {
        this.ownerId = ownerId;
    }

    @Override
    public void setAI(CreatureEntity mob) {
        mob.func_110163_bv();
        mob.func_98053_h(true);
        EntityHelper.resetAttackAction((LivingEntity)mob);
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            mob.func_233663_d_(slot);
        }
        mob.field_70714_bg.func_75776_a(1, (Goal)new FollowOwnerGoal((MobEntity)mob, 1.2, 20.0f, 3.0f, false){

            @Override
            protected Optional<PlayerEntity> getOwner() {
                return EntityHelper.getFriendlyOwner((Entity)this.mob);
            }
        });
        mob.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((MobEntity)mob){

            @Override
            protected Optional<PlayerEntity> getOwner() {
                return EntityHelper.getFriendlyOwner((Entity)this.field_75299_d);
            }
        });
        mob.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((MobEntity)mob){

            @Override
            protected Optional<PlayerEntity> getOwner() {
                return EntityHelper.getFriendlyOwner((Entity)this.field_75299_d);
            }
        });
        CallbackHandler.addFastCallback(() -> this.getOwnerId().ifPresent(ownerId -> PacketHandler.sendToAllTrackingPlayers(new CMessageServant(mob.func_145782_y(), (UUID)ownerId, false), (LivingEntity)mob)));
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        if (this.ownerId != null) {
            nbt.func_186854_a(FRIENDLY_OWNER_ID, this.ownerId);
        }
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt.func_186855_b(FRIENDLY_OWNER_ID)) {
            this.ownerId = nbt.func_186857_a(FRIENDLY_OWNER_ID);
        }
    }
}

