/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.Style;
import net.minecraft.world.storage.FolderName;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.BackupService;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.registry.ModItems;

public class CommandTBReviveFamiliar
extends TombstoneCommand {
    private static final int MAX_SAVES = 20;
    private static final FolderName SAVE_FOLDER = new FolderName("tombstone/saved_familiars");

    public CommandTBReviveFamiliar(CommandDispatcher<CommandSource> commandDispatcher) {
        super(commandDispatcher);
    }

    @Override
    String getName() {
        return "tbrevivefamiliar";
    }

    @Override
    LiteralArgumentBuilder<CommandSource> getBuilder(LiteralArgumentBuilder<CommandSource> builder) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.executes(this::showUsage)).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(this::reviveFamiliar));
    }

    private int reviveFamiliar(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        Style style;
        LangKey langKey;
        ItemStack receptacle;
        ServerPlayerEntity player = EntityArgument.func_197089_d(ctx, (String)"player");
        CommandTBReviveFamiliar.checkAlive((Entity)player);
        CommandTBReviveFamiliar.checkNotSpectator((Entity)player);
        CompoundNBT petTag = CommandTBReviveFamiliar.getLastSave(((CommandSource)ctx.getSource()).func_197028_i(), (PlayerEntity)player);
        if (petTag != null) {
            receptacle = new ItemStack((IItemProvider)ModItems.familiar_receptacle);
            receptacle.func_196082_o().func_218657_a("dead_pet", (INBT)petTag);
        } else {
            receptacle = InventoryHelper.findFirstInInventory((PlayerEntity)player, ModItems.familiar_receptacle::containSoul);
        }
        if (receptacle.func_190926_b()) {
            throw LangKey.MESSAGE_NO_SAVE_TO_RESTORE.asCommandException(new Object[0]);
        }
        if (ModItems.familiar_receptacle.revive((PlayerEntity)player, player.func_233580_cy_(), receptacle, false)) {
            langKey = LangKey.MESSAGE_BRING_BACK_TO_LIFE;
            style = StyleType.MESSAGE_SPELL;
        } else {
            langKey = LangKey.MESSAGE_CANT_REVIVE_FAMILIAR;
            style = StyleType.COLOR_OFF;
        }
        langKey.sendMessage((PlayerEntity)player, style, new Object[]{LangKey.MESSAGE_YOUR_FAMILIAR.getText(new Object[0])});
        if (!player.equals((Object)((CommandSource)ctx.getSource()).func_197022_f())) {
            this.sendMessage((CommandSource)ctx.getSource(), langKey.getText(style, new Object[]{LangKey.MESSAGE_FAMILIAR_OF.getText(player.func_200200_C_())}), false);
        }
        receptacle.func_190918_g(1);
        player.field_71069_bz.func_75142_b();
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static CompoundNBT getLastSave(MinecraftServer server, PlayerEntity player) {
        File saveFolder = new File(server.func_240776_a_(SAVE_FOLDER).toFile(), player.func_146103_bH().getId().toString());
        if (!saveFolder.exists()) {
            return null;
        }
        File[] saveFiles = saveFolder.listFiles(p -> p.isFile() && p.getName().endsWith(".save"));
        if (saveFiles == null) return null;
        if (saveFiles.length == 0) {
            return null;
        }
        File file = Stream.of(saveFiles).max(File::compareTo).orElse(null);
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            CompoundNBT nbt = JsonToNBT.func_180713_a((String)reader.readLine());
            reader.close();
            if (nbt.func_150296_c().isEmpty()) return null;
            file.delete();
            CompoundNBT compoundNBT = nbt;
            return compoundNBT;
        }
        catch (CommandSyntaxException | IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void saveFamiliar(MinecraftServer server, UUID ownerId, CompoundNBT tag, String saveName) {
        File saveFolder = new File(server.func_240776_a_(SAVE_FOLDER).toFile(), ownerId.toString());
        if (!saveFolder.exists() && !saveFolder.mkdirs()) {
            ModTombstone.LOGGER.info("The backup folder for familiars cannot be created");
            return;
        }
        String dateString = new SimpleDateFormat("yyyyMMdd-HHmmss", Locale.US).format(new Date());
        File accessedFile = new File(saveFolder, dateString + "_" + saveName + ".save");
        BackupService.get().execute(() -> {
            block16: {
                try (FileWriter writer = new FileWriter(accessedFile);){
                    writer.write(tag.toString());
                    writer.close();
                    File[] matchingFiles = saveFolder.listFiles((file, name) -> name.endsWith(".save"));
                    if (matchingFiles == null || matchingFiles.length <= 20) break block16;
                    int diff = matchingFiles.length - 20;
                    Arrays.sort(matchingFiles, Comparator.comparingLong(File::lastModified));
                    int num = 0;
                    for (File file2 : matchingFiles) {
                        if (num >= diff) {
                            break;
                        }
                        file2.delete();
                        ++num;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

