/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetExperiencePacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.command.CommandTBTeleport;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.tileentity.TileEntityPlayerGrave;

public class DeathHandler {
    public static final DeathHandler INSTANCE = new DeathHandler();
    public final Set<Location> ALLOWED_REMOVALS = ConcurrentHashMap.newKeySet();
    private Predicate<Location> no_grave_locations = l -> false;
    private static final String IS_PLAYER_DEAD_NBT_BOOL = "tb_is_player_dead";
    private static final String PRESERVED_EFFECTS_NBT_LIST = "tb_preserved_effects";
    private static final String LAST_DEATH_LOCATION_NBT_TAG = "tb_last_death_location";
    public static final String GRAVE_LOCATIONS_NBT_LIST = "tb_grave_locations";
    private static final String SOULBOUND_STACKS_NBT_LIST = "tb_soulbound_stacks";
    private static final String KEY_STACKS_NBT_LIST = "tb_key_stacks";

    private DeathHandler() {
    }

    public Location getLastGrave(MinecraftServer server, ServerPlayerEntity player) {
        List<Location> graveLocations = this.getGraveList(player);
        for (Location lastGrave : graveLocations) {
            ServerWorld currentWorld;
            if (lastGrave.isOrigin() || (currentWorld = server.func_71218_a(lastGrave.dim)) == null) continue;
            if (currentWorld.func_175625_s(lastGrave.getPos()) instanceof TileEntityPlayerGrave) {
                return lastGrave;
            }
            this.removeGrave(player, lastGrave);
        }
        return Location.ORIGIN;
    }

    public void removeGrave(ServerPlayerEntity player, Location pos) {
        boolean removeAbsentWorld;
        ListNBT list = NBTStackHelper.getListOrCreate(EntityHelper.getPersistentTag((PlayerEntity)player), GRAVE_LOCATIONS_NBT_LIST);
        boolean bl = removeAbsentWorld = list.size() > 100;
        assert (player.func_184102_h() != null);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Location loc = NBTStackHelper.getLocation((CompoundNBT)it.next(), "location");
            if (!pos.equals(loc) && (!removeAbsentWorld || player.func_184102_h().func_71218_a(loc.dim) != null)) continue;
            it.remove();
        }
    }

    public List<Location> getGraveList(ServerPlayerEntity player) {
        LinkedList<Location> graveLocations = new LinkedList<Location>();
        ListNBT nbtList = NBTStackHelper.getListOrCreate(EntityHelper.getPersistentTag((PlayerEntity)player), GRAVE_LOCATIONS_NBT_LIST);
        for (int i = nbtList.size() - 1; i >= 0; --i) {
            graveLocations.add(NBTStackHelper.getLocation(nbtList.func_150305_b(i), "location"));
        }
        return graveLocations;
    }

    public boolean isNoGraveLocation(Location location) {
        return this.no_grave_locations.test(location);
    }

    public void setLastDeathLocation(PlayerEntity player, Location location) {
        NBTStackHelper.setLocation(EntityHelper.getPersistentTag(player), LAST_DEATH_LOCATION_NBT_TAG, location);
    }

    public Location getLastDeathLocation(PlayerEntity player) {
        return NBTStackHelper.getLocation(EntityHelper.getPersistentTag(player), LAST_DEATH_LOCATION_NBT_TAG);
    }

    public void addPlayerDead(ServerPlayerEntity player, DamageSource source) {
        int xpLoss;
        int toRemove;
        ServerPlayerEntity killer;
        int timeSinceDeath = player.func_147099_x().func_77444_a(Stats.field_199092_j.func_199076_b((Object)Stats.field_188098_h));
        if (timeSinceDeath < TimeHelper.tickFromMinute(1)) {
            if (player.func_147099_x().func_77444_a(Stats.field_199092_j.func_199076_b((Object)Stats.field_188069_A)) > 1) {
                ModTriggers.CHAIN_DEATH.trigger(player);
            }
        } else if (timeSinceDeath >= TimeHelper.tickFromHour(1)) {
            ModTriggers.STRONG_OR_CAREFUL.trigger(player);
            if (timeSinceDeath >= TimeHelper.tickFromHour(10)) {
                ModTriggers.ALMOST_UNKILLABLE.trigger(player);
            }
        }
        CompoundNBT persistentTag = EntityHelper.getPersistentTag((PlayerEntity)player);
        persistentTag.func_74757_a(IS_PLAYER_DEAD_NBT_BOOL, true);
        this.setLastDeathLocation((PlayerEntity)player, new Location((Entity)player));
        boolean hasPreservation = EffectHelper.isPotionActive((LivingEntity)player, ModEffects.preservation);
        if (hasPreservation || ((Boolean)ConfigTombstone.player_death.restoreEffectsOnDeath.get()).booleanValue()) {
            NBTStackHelper.setEffectlist(persistentTag, PRESERVED_EFFECTS_NBT_LIST, player.func_70651_bq().stream().filter(EffectHelper::isAllowedEffect));
        }
        int xpTotal = EntityHelper.getPlayerTotalXp((PlayerEntity)player);
        if (!hasPreservation && xpTotal > 0 && Optional.ofNullable(player.func_184102_h()).map(MinecraftServer::func_71219_W).orElse(false).booleanValue() && EntityHelper.isKilledByOtherPlayer((PlayerEntity)player, source) && (killer = (ServerPlayerEntity)source.func_76346_g()) != null && (toRemove = MathHelper.func_76128_c((double)((double)(xpTotal * (Integer)ConfigTombstone.player_death.pvpStolenXp.get()) / 100.0))) > 0) {
            xpTotal -= toRemove;
            killer.func_195068_e(toRemove);
            LangKey.MESSAGE_PVP_STEAL_EXPERIENCE.sendMessage((PlayerEntity)player, toRemove, player.func_200200_C_());
        }
        if ((xpLoss = ((Integer)SharedConfigTombstone.player_death.xpLoss.get()).intValue()) == -1) {
            xpTotal = 0;
        } else if (!hasPreservation && xpLoss > 0) {
            xpTotal = MathHelper.func_76128_c((double)((double)(xpTotal * MathHelper.func_76125_a((int)(100 + EntityHelper.getPerkLevelWithBonus((PlayerEntity)player, ModPerks.memento_mori) * 20 - (Integer)SharedConfigTombstone.player_death.xpLoss.get()), (int)0, (int)100)) / 100.0));
        }
        persistentTag.func_74768_a("tb_experience_total", xpTotal);
        Pair<Integer, Float> pair = EntityHelper.getPlayerXpPair(xpTotal);
        persistentTag.func_74768_a("tb_experience_level", ((Integer)pair.getLeft()).intValue());
        persistentTag.func_74776_a("tb_experience_bar", ((Float)pair.getRight()).floatValue());
        persistentTag.func_74757_a("tb_has_preservation", hasPreservation);
    }

    public void updateNoGraveLocations() {
        ArrayList<Predicate<Location>> list = new ArrayList<Predicate<Location>>();
        for (String s : (List)ConfigTombstone.player_death.noGraveLocation.get()) {
            int range;
            int z;
            int y;
            int x;
            if (s.isEmpty()) continue;
            String[] res = s.split(",");
            if (res.length == 1) {
                list.add(l -> l.isSameDimension(res[0].trim()));
                continue;
            }
            if (res.length != 5) continue;
            try {
                x = Integer.parseInt(res[0].trim());
                y = Integer.parseInt(res[1].trim());
                z = Integer.parseInt(res[2].trim());
                range = Integer.parseInt(res[4].trim());
            }
            catch (NumberFormatException e) {
                ModTombstone.LOGGER.warn("invalid number in noGraveLocations with provided string: " + s);
                continue;
            }
            list.add(l -> l.isSameDimension(res[3].trim()) && l.isInRange(x, y, z, range));
        }
        this.no_grave_locations = list.stream().reduce(Predicate::or).orElse(l -> false);
    }

    public void restoreSoulbounds(ServerPlayerEntity player) {
        if (((Boolean)ConfigTombstone.player_death.handlePlayerDeath.get()).booleanValue() && (Helper.isModLoad("erebus") || Helper.isModLoad("death_compass"))) {
            player.field_71071_by.field_70462_a.stream().filter(stack -> "death_compass".equals(Optional.ofNullable(stack.func_77973_b().getRegistryName()).map(ResourceLocation::func_110623_a).orElse(""))).forEach(stack -> stack.func_190918_g(stack.func_190916_E()));
        }
        CompoundNBT persistentTag = EntityHelper.getPersistentTag((PlayerEntity)player);
        ResourceLocation soulboundRL = ModEnchantments.soulbound.getRegistryName();
        boolean reduceSoulbound = ModEnchantments.soulbound.func_77325_b() > 1;
        NBTStackHelper.getListOrEmpty(persistentTag, SOULBOUND_STACKS_NBT_LIST).ifPresent(list -> list.stream().map(CompoundNBT.class::cast).map(ItemStack::func_199557_a).filter(stack -> !stack.func_190926_b()).forEach(stack -> {
            if (reduceSoulbound) {
                Iterator it = stack.func_196082_o().func_150295_c("Enchantments", 10).iterator();
                while (it.hasNext()) {
                    CompoundNBT tag = (CompoundNBT)it.next();
                    if (!Optional.ofNullable(ResourceLocation.func_208304_a((String)tag.func_74779_i("id"))).map(rl -> rl.equals((Object)soulboundRL)).orElse(false).booleanValue()) continue;
                    int lvl = MathHelper.func_76125_a((int)tag.func_74765_d("lvl"), (int)0, (int)255);
                    if (lvl == 1) {
                        it.remove();
                        break;
                    }
                    tag.func_74777_a("lvl", (short)(lvl - 1));
                    break;
                }
            }
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)stack);
        }));
        persistentTag.func_82580_o(SOULBOUND_STACKS_NBT_LIST);
        NBTStackHelper.getListOrEmpty(persistentTag, KEY_STACKS_NBT_LIST).ifPresent(list -> list.stream().map(CompoundNBT.class::cast).map(ItemStack::func_199557_a).filter(stack -> !stack.func_190926_b()).forEach(stack -> ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)stack)));
        persistentTag.func_82580_o(KEY_STACKS_NBT_LIST);
    }

    public boolean canRemovePlayerGrave(World level, BlockPos pos) {
        return this.ALLOWED_REMOVALS.contains(new Location(pos, level));
    }

    public void removeAndEmptyPlayerGrave(World level, BlockPos pos) {
        pos = pos.func_185334_h();
        Location locationId = new Location(pos, level);
        this.ALLOWED_REMOVALS.add(locationId);
        level.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        this.ALLOWED_REMOVALS.remove(locationId);
    }

    public void handleRespawn(ServerPlayerEntity player) {
        this.restoreSoulbounds(player);
        CompoundNBT persistentTag = EntityHelper.getPersistentTag((PlayerEntity)player);
        if (EntityHelper.getPersistentTag((PlayerEntity)player).func_74767_n(IS_PLAYER_DEAD_NBT_BOOL)) {
            this.restorePlayer(player, persistentTag);
        }
        player.field_71069_bz.func_75142_b();
    }

    public void restorePlayer(ServerPlayerEntity player, CompoundNBT persistentTag) {
        boolean hasPreservation;
        if (PlayerPreference.get((PlayerEntity)player).getAutoEquipRule().equipOnRespawn()) {
            InventoryHelper.autoequip(player, new ItemStackHandler(player.field_71071_by.field_70462_a));
        }
        EffectHelper.addGhostlyShape((PlayerEntity)player);
        persistentTag.func_82580_o(IS_PLAYER_DEAD_NBT_BOOL);
        List<EffectInstance> effectInstances = NBTStackHelper.getEffectList(persistentTag, PRESERVED_EFFECTS_NBT_LIST, EffectHelper::isAllowedEffect);
        if (!effectInstances.isEmpty()) {
            effectInstances.forEach(effectInstance -> EffectHelper.addEffect((LivingEntity)player, effectInstance));
            persistentTag.func_82580_o(PRESERVED_EFFECTS_NBT_LIST);
        }
        if ((hasPreservation = persistentTag.func_74767_n("tb_has_preservation")) || (Integer)SharedConfigTombstone.player_death.xpLoss.get() > -1) {
            player.field_71067_cb = persistentTag.func_74762_e("tb_experience_total");
            player.field_71068_ca = persistentTag.func_74762_e("tb_experience_level");
            player.field_71106_cc = persistentTag.func_74760_g("tb_experience_bar");
            persistentTag.func_82580_o("tb_has_preservation");
            player.field_71135_a.func_147359_a((IPacket)new SSetExperiencePacket(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
        }
    }

    public void handleSoulbound(ServerPlayerEntity player, Collection<ItemEntity> loots) {
        loots.addAll(player.field_70170_p.func_175647_a(ItemEntity.class, Helper.createBounds(player.func_233580_cy_(), ((Integer)ConfigTombstone.player_death.snifferRange.get()).intValue()), e -> e != null && (e.func_200215_l() == null || player.func_146103_bH().getId().equals(e.func_200215_l()))));
        this.storeSoulboundsOnBody(player, loots.iterator());
    }

    public void handleLoot(ServerPlayerEntity player, Collection<ItemEntity> loots, DamageSource source) {
        BlockState state;
        boolean hasGrave;
        TileEntityPlayerGrave grave;
        TileEntity tile2;
        boolean hasDrop;
        PlayerPreference playerPreference = PlayerPreference.get((PlayerEntity)player);
        if (!((Boolean)ConfigTombstone.player_death.handlePlayerDeath.get()).booleanValue() || playerPreference.denyGraveOnDeath()) {
            LangKey.MESSAGE_CHOOSE_NO_GRAVE.sendMessage((PlayerEntity)player, StyleType.MESSAGE_SPECIAL, new Object[0]);
            return;
        }
        if (this.isNoGraveLocation(new Location((Entity)player))) {
            LangKey.MESSAGE_NO_GRAVE_LOCATION.sendMessage((PlayerEntity)player, StyleType.MESSAGE_SPECIAL, new Object[0]);
            return;
        }
        int countDrop = loots.size();
        boolean bl = hasDrop = countDrop > 0;
        if (!hasDrop) {
            LangKey.MESSAGE_NO_LOOT_FOR_GRAVE.sendMessage((PlayerEntity)player, StyleType.MESSAGE_SPECIAL, new Object[0]);
            return;
        }
        MinecraftServer server = player.func_184102_h();
        assert (server != null);
        ServerWorld world = player.func_71121_q();
        BlockPos initPos = Helper.getCloserValidPos((World)world, player.func_233580_cy_());
        Location spawnPos = Location.ORIGIN;
        if (((Boolean)ConfigTombstone.player_death.allowToFillExistingGrave.get()).booleanValue()) {
            Location lastGrave;
            TileEntityPlayerGrave tileGrave = world.func_175726_f(initPos).func_177434_r().values().stream().filter(TileEntityPlayerGrave.class::isInstance).map(TileEntityPlayerGrave.class::cast).filter(tile -> tile.getOwnerName().equals(player.func_146103_bH().getName()) && InventoryHelper.hasEnoughSlots(tile.getInventory(), countDrop)).findFirst().orElse(null);
            if (tileGrave != null) {
                spawnPos = new Location(tileGrave.func_174877_v(), (World)world);
            }
            if (spawnPos.isOrigin() && !(lastGrave = this.getLastGrave(server, player)).isOrigin() && lastGrave.isSameDimension((World)world) && Helper.getDistanceSq((Vector3i)lastGrave.getPos(), (Vector3i)initPos) <= 400.0 && (tile2 = world.func_175625_s(lastGrave.getPos())) instanceof TileEntityPlayerGrave && InventoryHelper.hasEnoughSlots((grave = (TileEntityPlayerGrave)tile2).getInventory(), countDrop)) {
                spawnPos = lastGrave;
            }
        }
        boolean bl2 = hasGrave = !spawnPos.isOrigin();
        if (!hasGrave) {
            Pair<ServerWorld, BlockPos> respawnPoint;
            Pair<Location, SpawnHelper.SpawnResult> res = new SpawnHelper(world, initPos).withPlayerPreference(playerPreference).findGravePlaceWithResult();
            spawnPos = (Location)res.getLeft();
            if (world.func_230315_m_().func_242714_a(DimensionType.field_236006_j_) && (spawnPos.isOrigin() || !SpawnHelper.SpawnResult.NORMAL.hasPattern((SpawnHelper.SpawnResult)((Object)res.getRight()))) && !((Location)(res = new SpawnHelper(world, new BlockPos(0, 70, 0)).withPlayerPreference(playerPreference).findGravePlaceWithResult()).getLeft()).isOrigin() && SpawnHelper.SpawnResult.NORMAL.hasPattern((SpawnHelper.SpawnResult)((Object)res.getRight()))) {
                spawnPos = (Location)res.getLeft();
            }
            if (spawnPos.isOrigin() && (spawnPos = new SpawnHelper((ServerWorld)(respawnPoint = CommandTBTeleport.getRespawnPoint(server, player)).getLeft(), (BlockPos)respawnPoint.getRight()).withPlayerPreference(playerPreference).findGravePlace()).isOrigin()) {
                LangKey.MESSAGE_NO_PLACE_FOR_GRAVE.sendMessage((PlayerEntity)player, StyleType.MESSAGE_SPECIAL, new Object[0]);
                ModTombstone.LOGGER.debug("There was nowhere to place the grave!");
                return;
            }
        }
        if (!hasGrave) {
            NBTStackHelper.getListOrCreate(EntityHelper.getPersistentTag((PlayerEntity)player), GRAVE_LOCATIONS_NBT_LIST).add((Object)NBTStackHelper.setLocation(new CompoundNBT(), "location", spawnPos));
            ModTombstone.LOGGER.debug("A new grave of the player " + player.func_146103_bH().getName() + " was created at position [x:" + spawnPos.x + ", y:" + spawnPos.y + ", z:" + spawnPos.z + ", dim:" + spawnPos.getDimString() + "]");
            Direction facing = player.func_174811_aO().func_176734_d();
            Block graveBlock = ModBlocks.PLAYER_GRAVES.get((Object)playerPreference.getFavoriteGrave());
            state = (BlockState)((BlockState)((BlockState)graveBlock.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)facing)).func_206870_a((Property)BlockGraveBase.IS_ENGRAVED, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)BlockGraveBase.MODEL_TEXTURE, (Comparable)Integer.valueOf(playerPreference.getMarbleType().ordinal()));
            world.func_175656_a(spawnPos.getPos(), state);
        } else {
            state = world.func_180495_p(spawnPos.getPos());
        }
        tile2 = world.func_175625_s(spawnPos.getPos());
        if (!(tile2 instanceof TileEntityPlayerGrave)) {
            LangKey.MESSAGE_FAIL_TO_PLACE_GRAVE.sendMessage((PlayerEntity)player, StyleType.MESSAGE_SPECIAL, new Object[0]);
            ModTombstone.LOGGER.debug((Object)LangKey.MESSAGE_FAIL_TO_PLACE_GRAVE.getText(new Object[0]));
            return;
        }
        this.setLastDeathLocation((PlayerEntity)player, new Location(spawnPos.x, spawnPos.y + 1, spawnPos.z, spawnPos.dim));
        grave = (TileEntityPlayerGrave)tile2;
        if (hasGrave) {
            grave.resetDeathTime();
        }
        boolean needAccess = (Integer)SharedConfigTombstone.player_death.decayTime.get() != 0 && (!server.func_71219_W() || (Boolean)ConfigTombstone.player_death.pvpUnlockGrave.get() == false || !EntityHelper.isKilledByOtherPlayer((PlayerEntity)player, source));
        IFormattableTextComponent locked = new StringTextComponent("[").func_230529_a_((ITextComponent)(needAccess ? LangKey.MESSAGE_LOCKED.getText(new Object[0]).func_240702_b_((Integer)SharedConfigTombstone.player_death.decayTime.get() > 0 ? " " + SharedConfigTombstone.player_death.decayTime.get() + " min" : "") : LangKey.MESSAGE_UNLOCKED.getText(new Object[0]))).func_240702_b_("]").func_230530_a_(needAccess ? StyleType.COLOR_OFF : StyleType.COLOR_ON);
        player.func_145747_a((ITextComponent)(hasGrave ? LangKey.MESSAGE_EXISTING_GRAVE : LangKey.MESSAGE_NEW_GRAVE).getText(StyleType.MESSAGE_SPECIAL, new Object[0]).func_240702_b_(" ").func_230529_a_((ITextComponent)locked), Util.field_240973_b_);
        player.func_145747_a((ITextComponent)new StringTextComponent("[x: ").func_240702_b_(String.valueOf(spawnPos.x)).func_240702_b_(", y: ").func_240702_b_(String.valueOf(spawnPos.y)).func_240702_b_(", z: ").func_240702_b_(String.valueOf(spawnPos.z)).func_240702_b_("]").func_230529_a_((ITextComponent)new StringTextComponent(" in ").func_240702_b_(spawnPos.getDimString())), Util.field_240973_b_);
        Location finalSpawnPos = spawnPos;
        ListNBT keyList = NBTStackHelper.getListOrCreate(EntityHelper.getPersistentTag((PlayerEntity)player), KEY_STACKS_NBT_LIST);
        boolean found = false;
        for (int i = 0; i < keyList.size(); ++i) {
            ItemStack key = ItemStack.func_199557_a((CompoundNBT)keyList.func_150305_b(i));
            if (!ModItems.grave_key.getTombPos(key).equals(finalSpawnPos)) continue;
            ModItems.grave_key.reenchantOnDeath((PlayerEntity)player, key);
            keyList.set(i, (INBT)key.serializeNBT());
            found = true;
            break;
        }
        if (!found && ModItems.grave_key.isEnabled()) {
            ItemStack key = ModItems.grave_key.createWithInfo((PlayerEntity)player, finalSpawnPos);
            ModItems.grave_key.reenchantOnDeath((PlayerEntity)player, key);
            keyList.add((Object)key.serializeNBT());
        }
        grave.setOwner((PlayerEntity)player, TimeHelper.systemTime(), needAccess);
        IItemHandler itemHandler = grave.getInventory();
        loots.forEach(e -> e.func_92058_a(ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)e.func_92059_d().func_77946_l(), (boolean)false)));
        grave.func_70296_d();
        world.func_184138_a(spawnPos.getPos(), Blocks.field_150350_a.func_176223_P(), state, 2);
        ModTriggers.FIRST_GRAVE.trigger(player);
        if (loots.size() <= itemHandler.getSlots()) {
            try {
                loots.clear();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    private void storeSoulboundsOnBody(ServerPlayerEntity player, Iterator<ItemEntity> it) {
        CompoundNBT persistentTag = EntityHelper.getPersistentTag((PlayerEntity)player);
        ListNBT keyList = NBTStackHelper.getListOrCreate(persistentTag, KEY_STACKS_NBT_LIST);
        ListNBT stackList = NBTStackHelper.getListOrCreate(persistentTag, SOULBOUND_STACKS_NBT_LIST);
        while (it.hasNext()) {
            ItemStack stack;
            ItemEntity entityItem = it.next();
            if (entityItem == null || (stack = entityItem.func_92059_d()).func_190926_b()) {
                it.remove();
                continue;
            }
            if (!EntityHelper.hasSoulbound(stack)) continue;
            if (stack.func_77973_b() == ModItems.grave_key) {
                keyList.add((Object)stack.serializeNBT());
            } else {
                stackList.add((Object)stack.serializeNBT());
            }
            entityItem.func_92058_a(ItemStack.field_190927_a);
            it.remove();
        }
    }
}

