/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemScroll;
import ovh.corail.tombstone.loot.IDelayedNBTLoot;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemMagicScroll
extends ItemScroll
implements IDelayedNBTLoot {
    private static final String MAGIC_EFFECT_NBT_TAG = "magic_effect";

    public ItemMagicScroll() {
        super("magic_scroll", ItemMagicScroll.getBuilder().func_200917_a(64), () -> SharedConfigTombstone.allowed_magic_items.allowMagicScroll.get());
    }

    @Override
    public ITextComponent func_200295_i(ItemStack stack) {
        return this.getMagicEffectName(stack).map(effectName -> new TranslationTextComponent("tombstone.item." + (this.isAncient(stack) ? "ancient_" : "enchanted_") + "scroll_of", new Object[]{effectName}).func_230530_a_(StyleType.MESSAGE_SPECIAL)).orElse(super.func_200295_i(stack));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addTooltipInfo(ItemStack stack, World level, List<ITextComponent> tooltip) {
        this.getMagicEffect(stack).ifPresent(effectInstance -> {
            this.addEffectInfo(tooltip, effectInstance.func_188419_a());
            tooltip.add((ITextComponent)(this.isAncient(stack) ? LangKey.MESSAGE_AREA_BUFF : LangKey.MESSAGE_USEABLE_ON_ALLY).getText(new Object[0]).func_240703_c_(StyleType.EFFECT_DESCRIPTION));
            this.addItemUse(tooltip, LangKey.ITEM_SCROLL_BUFF_USE2, new Object[0]);
            if (!effectInstance.func_188419_a().func_76403_b()) {
                tooltip.add((ITextComponent)new StringTextComponent("(" + StringUtils.func_76337_a((int)MathHelper.func_76141_d((float)((float)((Integer)SharedConfigTombstone.magic_item.scrollDuration.get()).intValue() * (1.0f + (float)EntityHelper.getPerkLevelWithBonus(ModTombstone.PROXY.getClientPlayer(), ModPerks.alchemist) / 10.0f)))) + ")").func_230530_a_(StyleType.MESSAGE_SPELL));
            }
        });
        super.addTooltipInfo(stack, level, tooltip);
    }

    @Override
    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab) && this.isEnabled()) {
            items.add((Object)this.setMagicEffect(new ItemStack((IItemProvider)this)));
            items.add((Object)this.setMagicEffect(this.createAncient()));
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotId, boolean isSelected) {
        if (!world.func_201670_d() && stack.func_77973_b() == this && !this.getMagicEffectName(stack).isPresent() && TimeHelper.atInterval(entity, TimeHelper.tickFromMinute(1))) {
            this.setMagicEffect(stack);
        }
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return true;
    }

    @Override
    public boolean canEnchant(World world, BlockPos gravePos, PlayerEntity player, ItemStack stack) {
        return false;
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(World world, BlockPos gravePos, ServerPlayerEntity player, ItemStack stack, int soulStrength) {
        return ISoulConsumer.ConsumeResult.fail();
    }

    @Override
    protected boolean doEffects(ServerWorld world, ServerPlayerEntity player, ItemStack stack, @Nullable LivingEntity target) {
        EffectInstance effectInstance = this.getMagicEffect(stack).orElse(null);
        if (effectInstance == null) {
            return false;
        }
        IFormattableTextComponent effectName = effectInstance.func_188419_a().func_199286_c().func_230531_f_().func_230530_a_(StyleType.MESSAGE_SPECIAL);
        effectInstance.field_76460_b = MathHelper.func_76141_d((float)((float)effectInstance.field_76460_b * (1.0f + (float)EntityHelper.getPerkLevelWithBonus((PlayerEntity)player, ModPerks.alchemist) / 10.0f)));
        if (this.isAncient(stack)) {
            List<LivingEntity> allies = world.func_175674_a((Entity)player, player.func_174813_aQ().func_72314_b(3.0, 0.0, 3.0), e -> e != null && e.func_70089_S()).stream().filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast).filter(e -> this.isTargetForCasting((PlayerEntity)player, (LivingEntity)e)).collect(Collectors.toList());
            allies.forEach(arg_0 -> ItemMagicScroll.lambda$doEffects$4(effectInstance, (ITextComponent)effectName, arg_0));
            ModTriggers.CAST_ON_ALLY.trigger(player, allies.size());
            EffectHelper.addEffect((LivingEntity)player, new EffectInstance(effectInstance));
            LangKey.MESSAGE_SPELL_CAST_AROUND.sendMessage((PlayerEntity)player, StyleType.MESSAGE_SPELL, new Object[]{effectName});
        } else {
            if (target == null) {
                target = player;
            } else {
                ModTriggers.CAST_ON_ALLY.trigger(player);
            }
            EffectHelper.addEffect(target, new EffectInstance(effectInstance));
            if (EntityHelper.isValidServerPlayer((Entity)target)) {
                LangKey.MESSAGE_SPELL_CAST_ON_YOU.sendMessage((PlayerEntity)((ServerPlayerEntity)target), StyleType.MESSAGE_SPELL, new Object[]{effectName});
            }
            if (!target.equals((Object)player)) {
                LangKey.MESSAGE_SPELL_CAST_ON_TARGET.sendMessage((PlayerEntity)player, StyleType.MESSAGE_SPELL, new Object[]{effectName, target.func_200200_C_().func_230531_f_().func_230530_a_(StyleType.TOOLTIP_ITEM)});
            }
        }
        return true;
    }

    public Optional<ITextComponent> getMagicEffectName(ItemStack stack) {
        CompoundNBT tagEffect;
        Effect effect;
        if (stack.func_77978_p() != null && stack.func_77978_p().func_150297_b(MAGIC_EFFECT_NBT_TAG, 10) && (effect = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation((tagEffect = stack.func_77978_p().func_74775_l(MAGIC_EFFECT_NBT_TAG)).func_74779_i("id")))) != null) {
            int amplifier = tagEffect.func_74771_c("amplifier") & 0xFF;
            if (amplifier > 0) {
                return Optional.of(effect.func_199286_c().func_230532_e_().func_240702_b_(" " + EffectHelper.getPotency(amplifier + 1)));
            }
            return Optional.of(effect.func_199286_c());
        }
        return Optional.empty();
    }

    public Optional<EffectInstance> getMagicEffect(ItemStack stack) {
        CompoundNBT tagEffect;
        Effect effect;
        if (stack.func_77973_b() == this && stack.func_77978_p() != null && stack.func_77978_p().func_150297_b(MAGIC_EFFECT_NBT_TAG, 10) && (effect = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation((tagEffect = stack.func_77978_p().func_74775_l(MAGIC_EFFECT_NBT_TAG)).func_74779_i("id")))) != null) {
            Function<Effect, Integer> duration = e -> e.func_76403_b() ? Integer.valueOf(1) : (Integer)SharedConfigTombstone.magic_item.scrollDuration.get();
            return Optional.of(new EffectInstance(effect, duration.apply(effect).intValue(), tagEffect.func_74771_c("amplifier") & 0xFF));
        }
        return Optional.empty();
    }

    public ItemStack setMagicEffect(ItemStack stack) {
        Effect effect;
        if (stack.func_77973_b() == this && (effect = (Effect)Helper.getRandomInList(ForgeRegistries.POTIONS.getEntries().stream().filter(entry -> !((RegistryKey)entry.getKey()).func_240901_a_().func_110624_b().equals("tombstone")).map(Map.Entry::getValue).filter(EffectHelper::isAllowedEffect).collect(Collectors.toList())).orElse(null)) != null) {
            int amplifier = EffectHelper.RANDOM_EFFECT_LEVEL.apply(Helper.RANDOM);
            CompoundNBT tagEffect = new CompoundNBT();
            tagEffect.func_74778_a("id", ForgeRegistries.POTIONS.getKey((IForgeRegistryEntry)effect).toString());
            tagEffect.func_74774_a("amplifier", (byte)amplifier);
            stack.func_196082_o().func_218657_a(MAGIC_EFFECT_NBT_TAG, (INBT)tagEffect);
        }
        return stack;
    }

    public int getColor(ItemStack stack, int tint) {
        CompoundNBT tagEffect;
        Effect effect;
        if ((tint == 1 || tint == 2) && stack.func_77978_p() != null && stack.func_77978_p().func_150297_b(MAGIC_EFFECT_NBT_TAG, 10) && (effect = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation((tagEffect = stack.func_77978_p().func_74775_l(MAGIC_EFFECT_NBT_TAG)).func_74779_i("id")))) != null) {
            if (tint == 2) {
                return effect.func_76401_j();
            }
            float[] colors = Helper.getRGBColor3F(effect.func_76401_j());
            if (IntStream.range(0, colors.length).allMatch(i -> colors[i] > 0.8f)) {
                return 65536 * (int)((1.0f - colors[0]) * 255.0f) + 256 * (int)((1.0f - colors[1]) * 255.0f) + (int)((1.0f - colors[2]) * 255.0f);
            }
        }
        return -1;
    }

    @Override
    protected boolean canAffectTarget(ItemStack stack, LivingEntity target) {
        return !this.isAncient(stack) && this.getMagicEffect(stack).map(e -> (!EntityHelper.isUndead(target) || e.func_188419_a() != Effects.field_76432_h) && target.func_70687_e(e)).orElse(false) != false;
    }

    @Override
    public ItemStack onDelayedLoot(ItemStack stack, CompoundNBT tag, LootContext context) {
        return this.setMagicEffect(stack);
    }

    public ItemStack createAncient() {
        return NBTStackHelper.setBoolean(new ItemStack((IItemProvider)this), "ancient", true);
    }

    private static /* synthetic */ void lambda$doEffects$4(EffectInstance effectInstance, ITextComponent effectName, LivingEntity e) {
        EffectHelper.addEffect(e, new EffectInstance(effectInstance));
        if (EntityHelper.isValidServerPlayer((Entity)e)) {
            LangKey.MESSAGE_SPELL_CAST_ON_YOU.sendMessage((PlayerEntity)((ServerPlayerEntity)e), StyleType.MESSAGE_SPELL, new Object[]{effectName});
        }
    }
}

