/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.mixin;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.player.PlayerEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ovh.corail.tombstone.capability.SpellCasterProvider;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.registry.ModEffects;

@Mixin(value={MobEntity.class})
public class MobMixin {
    @Inject(method={"isSunBurnTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void methodIsSunBurnTick(CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        if (EntityHelper.isServant((Entity)((MobEntity)this))) {
            callbackInfoReturnable.setReturnValue((Object)false);
        }
    }

    @Inject(method={"checkDespawn"}, at={@At(value="HEAD")}, cancellable=true)
    private void methodCheckDespawn(CallbackInfo callbackInfo) {
        if (EntityHelper.isServant((Entity)((MobEntity)this))) {
            callbackInfo.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void methodTick(CallbackInfo callbackInfo) {
        MobEntity mob = (MobEntity)this;
        mob.getCapability(SpellCasterProvider.SPELLCASTER_CAPABILITY).ifPresent(cap -> cap.tick(mob));
    }

    @Inject(method={"canBeLeashed"}, at={@At(value="HEAD")}, cancellable=true)
    private void methodCanBeLeashed(PlayerEntity player, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        MobEntity mob = (MobEntity)this;
        if (!mob.func_110167_bD() && EntityHelper.getServantOwnerId((Entity)mob).map(ownerId -> ownerId.equals(player.func_146103_bH().getId())).orElse(false).booleanValue()) {
            callbackInfoReturnable.setReturnValue((Object)true);
        }
    }

    @Inject(method={"setTarget"}, at={@At(value="HEAD")}, cancellable=true)
    private void methodSetTarget(@Nullable LivingEntity target, CallbackInfo callbackInfo) {
        if (target != null) {
            MobEntity attacker = (MobEntity)this;
            if (EffectHelper.isPotionActive(target, ModEffects.ghostly_shape) || EffectHelper.isPotionActive(target, ModEffects.diversion)) {
                IAngerable neutralMob;
                if (target.equals((Object)attacker.func_70643_av())) {
                    attacker.func_70604_c(null);
                } else if (target.equals((Object)attacker.field_70717_bb)) {
                    attacker.func_230246_e_(null);
                }
                if (attacker instanceof IAngerable && Optional.ofNullable((neutralMob = (IAngerable)attacker).func_230257_G__()).map(uuid -> uuid.equals(target.func_110124_au())).orElse(false).booleanValue()) {
                    neutralMob.func_230259_a_(null);
                    neutralMob.func_230260_a__(0);
                }
                if (attacker.func_213375_cj().func_218191_a(MemoryModuleType.field_234103_o_)) {
                    attacker.func_213375_cj().func_218226_a(MemoryModuleType.field_234103_o_, Optional.empty());
                }
                callbackInfo.cancel();
            }
        }
    }
}

