/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.particle;

import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.particle.CustomParticle;
import ovh.corail.tombstone.registry.ModSounds;

@OnlyIn(value=Dist.CLIENT)
public final class ParticleGhost
extends CustomParticle {
    private static final ResourceLocation COMMON_TEXTURE = new ResourceLocation("tombstone", "textures/particle/ghost.png");
    private final double mX;
    private final double mZ;

    public ParticleGhost(ClientWorld level, double x, double y, double z, double mX, double mZ) {
        super(level, x, y + 1.0, z);
        this.mX = mX;
        this.mZ = mZ;
        this.func_187114_a(200);
        this.func_70541_f(6.0f);
        LightningBoltEntity bolt = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a((World)this.field_187122_b);
        if (bolt != null) {
            bolt.func_233576_c_(new Vector3d(x, y, z));
            bolt.func_233623_a_(true);
            this.field_187122_b.func_217376_c((Entity)bolt);
        }
        level.func_184134_a(x, y, z, Helper.RANDOM.nextInt(4) == 0 ? ModSounds.GHOST_LAUGH : ModSounds.GHOST_HOWL, SoundCategory.VOICE, 1.0f, 1.0f, true);
    }

    @Override
    public void update() {
        super.update();
        if (this.field_70546_d == 10) {
            this.field_187129_i = this.mX;
            this.field_187131_k = this.mZ;
        }
        float ratio = (float)this.field_70546_d / (float)this.field_70547_e;
        this.func_82338_g((1.0f - ratio) * 0.8f);
        ModTombstone.PROXY.produceGraveSmoke((World)this.field_187122_b, 3, this.field_187126_f, this.field_187127_g - 0.8, this.field_187128_h, 0xFFFFFF);
    }

    @Override
    protected ResourceLocation getTexture() {
        return COMMON_TEXTURE;
    }
}

