/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.tileentity;

import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.block.BlockDecorativeGrave;
import ovh.corail.tombstone.block.SoulType;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.entity.GraveGuardian;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEntities;
import ovh.corail.tombstone.tileentity.TileEntityWritableGrave;

public class TileEntityDecorativeGrave
extends TileEntityWritableGrave {
    private long lastCheckSoul = -1L;

    public TileEntityDecorativeGrave() {
        super(ModBlocks.tile_decorative_grave);
    }

    @Override
    public boolean canShowFog() {
        return super.canShowFog() && Optional.ofNullable(this.func_145831_w()).map(l -> ((ConfigTombstone.Client.FogPeriod)ConfigTombstone.client.fogPeriod.get()).test((World)l)).orElse(false) != false;
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b == null || !ModBlocks.isDecorativeGrave(this.func_195044_w().func_177230_c())) {
            return;
        }
        super.func_73660_a();
        if (this.field_145850_b.func_201670_d()) {
            SoulType soulType;
            if (TimeHelper.atInterval(this.countTicks, 25) && (soulType = (SoulType)((Object)this.func_195044_w().func_177229_b(BlockDecorativeGrave.SOUL_TYPE))).hasSoul()) {
                ModTombstone.PROXY.produceGraveSoul(this.field_145850_b, this.field_174879_c, soulType, (int)((long)this.countTicks % 100L) / 25);
            }
        } else {
            long worldTicks = TimeHelper.worldTicks(this.field_145850_b);
            if (this.lastCheckSoul <= 0L || this.lastCheckSoul > worldTicks) {
                this.lastCheckSoul = worldTicks;
                return;
            }
            long elapsedMinutes = TimeHelper.minuteElapsed(worldTicks, this.lastCheckSoul);
            if (elapsedMinutes >= (long)((Integer)ConfigTombstone.decorative_grave.timeSoul.get()).intValue()) {
                if (((SoulType)((Object)this.func_195044_w().func_177229_b(BlockDecorativeGrave.SOUL_TYPE))).hasSoul()) {
                    this.resetCheckSoul();
                    return;
                }
                long count = elapsedMinutes / (long)((Integer)ConfigTombstone.decorative_grave.timeSoul.get()).intValue();
                this.lastCheckSoul += count * (long)TimeHelper.tickFromMinute((Integer)ConfigTombstone.decorative_grave.timeSoul.get());
                double chance = 1.0 - Math.pow(1.0 - (double)((Integer)ConfigTombstone.decorative_grave.chanceSoul.get()).intValue() / 1000.0, count);
                if (chance >= 1.0 || Helper.RANDOM.nextDouble() <= chance) {
                    SoulType soulType;
                    LightningBoltEntity bolt;
                    if (elapsedMinutes == (long)((Integer)ConfigTombstone.decorative_grave.timeSoul.get()).intValue() && (bolt = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(this.field_145850_b)) != null) {
                        bolt.func_233576_c_(Vector3d.func_237492_c_((Vector3i)this.field_174879_c));
                        bolt.func_233623_a_(true);
                        this.field_145850_b.func_217376_c((Entity)bolt);
                    }
                    if ((soulType = SoulType.generateSoulType()) == SoulType.STRONG && ((Boolean)ConfigTombstone.decorative_grave.allowGraveGardian.get()).booleanValue() && Helper.RANDOM.nextBoolean() && this.field_145850_b.func_175647_a(GraveGuardian.class, new AxisAlignedBB(this.field_174879_c).func_72314_b((double)((Integer)ConfigTombstone.decorative_grave.distanceBetweenGraveGuardian.get()).intValue(), 20.0, (double)((Integer)ConfigTombstone.decorative_grave.distanceBetweenGraveGuardian.get()).intValue()), entity -> true).isEmpty()) {
                        GraveGuardian graveGuardian = (GraveGuardian)ModEntities.grave_guardian.func_200721_a(this.field_145850_b);
                        if (graveGuardian != null) {
                            graveGuardian.func_70107_b(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
                            graveGuardian.func_213386_a((IServerWorld)this.field_145850_b, this.field_145850_b.func_175649_E(this.field_174879_c), SpawnReason.TRIGGERED, null, null);
                            this.field_145850_b.func_217376_c((Entity)graveGuardian);
                        }
                    } else {
                        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a(BlockDecorativeGrave.SOUL_TYPE, (Comparable)((Object)soulType)));
                    }
                }
            }
        }
    }

    public void resetCheckSoul() {
        this.lastCheckSoul = -1L;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (this.lastCheckSoul > 0L) {
            compound.func_74772_a("lastCheckSoul", this.lastCheckSoul);
        }
        return compound;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_150297_b("lastCheckSoul", 4)) {
            this.lastCheckSoul = compound.func_74763_f("lastCheckSoul");
        }
    }
}

