/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import growthcraft.cellar.GrowthcraftCellar;
import growthcraft.cellar.common.recipe.FermentBarrelRecipe;
import growthcraft.lib.util.CraftingUtils;
import growthcraft.lib.util.EffectUtils;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class FermentBarrelRecipeSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<FermentBarrelRecipe> {
    public FermentBarrelRecipe read(ResourceLocation recipeId, JsonObject json) {
        int processingTime = JSONUtils.func_151203_m((JsonObject)json, (String)"processing_time");
        Color color = new Color(Integer.decode(JSONUtils.func_151200_h((JsonObject)json, (String)"color")));
        FluidStack inputFluid = CraftingUtils.getFluidStack(JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient_fluid"));
        ItemStack inputItem = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient_item"), (boolean)false);
        FluidStack outputFluid = CraftingUtils.getFluidStack(JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
        ItemStack bottleItemStack = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"bottle"), (boolean)false);
        JsonArray recipeEffects = JSONUtils.func_151214_t((JsonObject)json, (String)"effects");
        for (int i = 0; i < recipeEffects.size(); ++i) {
            String effectRegistryName = JSONUtils.func_151200_h((JsonObject)recipeEffects.get(i).getAsJsonObject(), (String)"effect");
            int effectDuration = JSONUtils.func_151208_a((JsonObject)recipeEffects.get(i).getAsJsonObject(), (String)"duration", (int)200);
            int effectAmplifier = JSONUtils.func_151208_a((JsonObject)recipeEffects.get(i).getAsJsonObject(), (String)"amplifier", (int)0);
            Effect effect = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(effectRegistryName));
            EffectUtils.addEffect(bottleItemStack, effect, effectDuration, effectAmplifier);
        }
        return new FermentBarrelRecipe(recipeId, inputFluid, inputItem, outputFluid, processingTime, bottleItemStack, color);
    }

    public void write(PacketBuffer buffer, FermentBarrelRecipe recipe) {
        try {
            buffer.func_150788_a(recipe.getIngredientItemStack());
            buffer.writeFluidStack(recipe.getIngredientFluidStack());
            buffer.writeFluidStack(recipe.getResultingFluid());
            buffer.func_150788_a(recipe.getBottleItemStack());
            buffer.func_150787_b(recipe.getProcessingTime());
            buffer.func_150787_b(recipe.getColor().hashCode());
        }
        catch (Exception ex) {
            GrowthcraftCellar.LOGGER.error("Unable to write recipe from network buffer!");
            throw ex;
        }
    }

    @Nullable
    public FermentBarrelRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
        try {
            ItemStack inputItem = buffer.func_150791_c();
            FluidStack inputFluid = buffer.readFluidStack();
            FluidStack outputFluid = buffer.readFluidStack();
            ItemStack outputBottleItem = buffer.func_150791_c();
            int processingTime = buffer.func_150792_a();
            Color color = new Color(buffer.func_150792_a());
            return new FermentBarrelRecipe(recipeId, inputFluid, inputItem, outputFluid, processingTime, outputBottleItem, color);
        }
        catch (Exception ex) {
            GrowthcraftCellar.LOGGER.error("Unable to read recipe from network buffer!");
            throw ex;
        }
    }
}

