/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.compat.jei.category;

import com.mojang.blaze3d.matrix.MatrixStack;
import growthcraft.cellar.GrowthcraftCellar;
import growthcraft.cellar.common.recipe.CultureJarRecipe;
import growthcraft.cellar.init.GrowthcraftCellarBlocks;
import growthcraft.lib.util.TextureHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class CultureJarRecipeCategory
implements IRecipeCategory<CultureJarRecipe> {
    public static final ResourceLocation ID = new ResourceLocation("growthcraft_cellar", "culture_jar");
    private static final ResourceLocation TEXTURE = TextureHelper.getTextureGui("growthcraft_cellar", "culture_jar");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableStatic overlayHeated;
    private final IDrawableStatic overlayTank;
    private final String title;

    public CultureJarRecipeCategory(IGuiHelper guiHelper) {
        Block processingBlock = (Block)GrowthcraftCellarBlocks.culture_jar.get();
        this.background = guiHelper.drawableBuilder(TEXTURE, 10, 10, 160, 70).build();
        this.overlayHeated = guiHelper.createDrawable(TEXTURE, 176, 28, 12, 13);
        this.overlayTank = guiHelper.createDrawable(TEXTURE, 176, 64, 12, 13);
        this.title = I18n.func_135052_a((String)processingBlock.func_149739_a(), (Object[])new Object[0]);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)processingBlock));
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends CultureJarRecipe> getRecipeClass() {
        return CultureJarRecipe.class;
    }

    public String getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(CultureJarRecipe recipe, IIngredients ingredients) {
        ArrayList<ItemStack> itemStackIngredients = new ArrayList<ItemStack>();
        for (Ingredient ingredient : recipe.func_192400_c()) {
            itemStackIngredients.addAll(Arrays.asList(ingredient.func_193365_a()));
        }
        ingredients.setInputs(VanillaTypes.ITEM, itemStackIngredients);
        ArrayList<FluidStack> fluidStackIngredients = new ArrayList<FluidStack>();
        fluidStackIngredients.add(recipe.getInputFluidStack());
        ingredients.setInputs(VanillaTypes.FLUID, fluidStackIngredients);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(IRecipeLayout layout, CultureJarRecipe recipe, IIngredients ingredients) {
        layout.getItemStacks().init(0, true, 83, 24);
        layout.getItemStacks().set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        IGuiFluidStackGroup guiFluidStacks = layout.getFluidStacks();
        guiFluidStacks.init(0, true, 55, 8, 16, 52, 1000, false, (IDrawable)this.overlayTank);
        guiFluidStacks.set(0, (List)ingredients.getInputs(VanillaTypes.FLUID).get(0));
    }

    public void draw(CultureJarRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        try {
            this.overlayHeated.draw(matrixStack, 86, 47);
        }
        catch (Exception ex) {
            GrowthcraftCellar.LOGGER.error("Failure to draw heat texture for Culture Jar recipe.");
        }
    }
}

