/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.common.block;

import growthcraft.cellar.common.tileentity.handler.GrowthcraftItemHandler;
import growthcraft.core.common.tileentity.RopeTileEntity;
import growthcraft.core.init.GrowthcraftTileEntities;
import growthcraft.lib.util.BlockStateUtils;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class RopeBlock
extends Block
implements IWaterLoggable {
    public static final BooleanProperty NORTH = BooleanProperty.func_177716_a((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.func_177716_a((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.func_177716_a((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.func_177716_a((String)"west");
    public static final BooleanProperty UP = BooleanProperty.func_177716_a((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.func_177716_a((String)"down");
    public static final BooleanProperty KNOT = BooleanProperty.func_177716_a((String)"knot");
    public static final VoxelShape KNOT_BOUNDING_BOX = RopeBlock.func_208617_a((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0);
    public static final VoxelShape NORTH_BOUNDING_BOX = RopeBlock.func_208617_a((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)7.0);
    public static final VoxelShape EAST_BOUNDING_BOX = RopeBlock.func_208617_a((double)9.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0);
    public static final VoxelShape SOUTH_BOUNDING_BOX = RopeBlock.func_208617_a((double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0, (double)16.0);
    public static final VoxelShape WEST_BOUNDING_BOX = RopeBlock.func_208617_a((double)0.0, (double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0);
    public static final VoxelShape UP_BOUNDING_BOX = RopeBlock.func_208617_a((double)7.0, (double)9.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    public static final VoxelShape DOWN_BOUNDING_BOX = RopeBlock.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)7.0, (double)9.0);
    public static final VoxelShape KNOT_FENCE_BOUNDING_BOX = RopeBlock.func_208617_a((double)5.0, (double)6.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0);
    public static final VoxelShape FENCE_POST_BOUNDING_BOX = RopeBlock.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public RopeBlock() {
        this(RopeBlock.getInitProperties(Material.field_151580_n));
    }

    public RopeBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)KNOT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    private static AbstractBlock.Properties getInitProperties(Material material) {
        AbstractBlock.Properties properties = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196556_aL);
        return properties;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)GrowthcraftTileEntities.rope_tileentity.get()).func_200968_a();
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof RopeTileEntity && state.func_177230_c() != newState.func_177230_c()) {
            RopeTileEntity ropeTileEntity = (RopeTileEntity)tileEntity;
            ((GrowthcraftItemHandler)ropeTileEntity.getInventory()).toNonNullList().forEach(item -> {
                ItemEntity itemEntity = new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), item);
                worldIn.func_217376_c((Entity)itemEntity);
            });
        }
        if (state.hasTileEntity() && state.func_177230_c() != newState.func_177230_c()) {
            worldIn.func_175713_t(pos);
        }
    }

    public void onNeighborChange(BlockState state, IWorldReader worldReader, BlockPos pos, BlockPos neighbor) {
        if (!worldReader.func_201670_d()) {
            World worldIn = (World)worldReader;
            worldIn.func_180501_a(pos, this.getActualBlockState(worldIn, pos), 3);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        ArrayList<VoxelShape> voxelShapeArrayList = new ArrayList<VoxelShape>();
        Map<String, Block> blockMap = BlockStateUtils.getSurroundingBlocks(worldIn, pos);
        if (BlockStateUtils.isRopeBlock(blockMap.get("north"))) {
            voxelShapeArrayList.add(NORTH_BOUNDING_BOX);
        }
        if (BlockStateUtils.isRopeBlock(blockMap.get("east"))) {
            voxelShapeArrayList.add(EAST_BOUNDING_BOX);
        }
        if (BlockStateUtils.isRopeBlock(blockMap.get("south"))) {
            voxelShapeArrayList.add(SOUTH_BOUNDING_BOX);
        }
        if (BlockStateUtils.isRopeBlock(blockMap.get("west"))) {
            voxelShapeArrayList.add(WEST_BOUNDING_BOX);
        }
        if (BlockStateUtils.isRopeBlock(blockMap.get("up"))) {
            voxelShapeArrayList.add(UP_BOUNDING_BOX);
        }
        if (BlockStateUtils.isRopeBlock(blockMap.get("down"))) {
            voxelShapeArrayList.add(DOWN_BOUNDING_BOX);
        }
        if (Boolean.TRUE.equals(state.func_177229_b((Property)KNOT))) {
            voxelShapeArrayList.add(KNOT_FENCE_BOUNDING_BOX);
            voxelShapeArrayList.add(FENCE_POST_BOUNDING_BOX);
        }
        VoxelShape[] voxelShapes = new VoxelShape[voxelShapeArrayList.size()];
        voxelShapes = voxelShapeArrayList.toArray(voxelShapes);
        return VoxelShapes.func_216384_a((VoxelShape)KNOT_BOUNDING_BOX, (VoxelShape[])voxelShapes);
    }

    public BlockState getActualBlockState(World world, BlockPos blockPos) {
        Map<String, Block> blockMap = BlockStateUtils.getSurroundingBlocks(world, blockPos);
        FluidState ifluidstate = world.func_204610_c(blockPos);
        RopeTileEntity tile = (RopeTileEntity)world.func_175625_s(blockPos);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(BlockStateUtils.isRopeBlock(blockMap.get("north"))))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(BlockStateUtils.isRopeBlock(blockMap.get("east"))))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(BlockStateUtils.isRopeBlock(blockMap.get("south"))))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(BlockStateUtils.isRopeBlock(blockMap.get("west"))))).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(BlockStateUtils.isRopeBlock(blockMap.get("up"))))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(BlockStateUtils.isRopeBlock(blockMap.get("down"))))).func_206870_a((Property)KNOT, (Comparable)Boolean.valueOf(tile != null && tile.hasFenceItemStack()))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return this.getActualBlockState((World)worldIn, currentPos);
    }

    public boolean canBeConnectedTo(BlockState state, IBlockReader world, BlockPos pos, Direction facing) {
        return BlockStateUtils.isRopeBlock(state.func_177230_c());
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN, KNOT, WATERLOGGED});
    }
}

