/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.block;

import growthcraft.cellar.common.tileentity.BrewKettleTileEntity;
import growthcraft.milk.GrowthcraftMilk;
import growthcraft.milk.common.tileentity.CheesePressTileEntity;
import growthcraft.milk.init.GrowthcraftMilkTileEntities;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class CheesePressBlock
extends Block {
    public static final IntegerProperty ROTATION = IntegerProperty.func_177719_a((String)"rotation", (int)0, (int)7);
    public static final ResourceLocation CONTENTS = new ResourceLocation("contents");
    public static final VoxelShape BOUNDING_BOX = Block.func_208617_a((double)0.01f, (double)0.0, (double)0.01f, (double)15.98f, (double)15.98f, (double)15.98);

    public CheesePressBlock() {
        this(CheesePressBlock.getInitProperties());
    }

    public CheesePressBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    private static AbstractBlock.Properties getInitProperties() {
        AbstractBlock.Properties properties = AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150486_ae);
        properties.func_226896_b_();
        return properties;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{ROTATION});
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)GrowthcraftMilkTileEntities.CHEESE_PRESS_TILE_ENTITY.get()).func_200968_a();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity tile;
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (stack.func_82837_s() && (tile = worldIn.func_175625_s(pos)) instanceof BrewKettleTileEntity) {
            ((BrewKettleTileEntity)tile).setCustomName(stack.func_200301_q());
        }
    }

    @Nonnull
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K) {
            CheesePressTileEntity tileEntity = (CheesePressTileEntity)worldIn.func_175625_s(pos);
            if (hand.name().equals("MAIN_HAND") && player.func_184586_b(hand).func_190926_b()) {
                if (!player.func_225608_bj_()) {
                    worldIn.func_184133_a(player, pos, SoundEvents.field_232695_bC_, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)ROTATION, (Comparable)Integer.valueOf(tileEntity.doRotation(true))), 2);
                } else if (tileEntity.getRotation() > 0) {
                    worldIn.func_184133_a(player, pos, SoundEvents.field_232697_bz_, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)ROTATION, (Comparable)Integer.valueOf(tileEntity.doRotation(false))), 2);
                    ItemStack itemStack = tileEntity.getInventory().extractItem(0, tileEntity.getInventory().getStackInSlot(0).func_190916_E(), false);
                    if (!itemStack.func_190926_b() && !player.field_71071_by.func_70441_a(itemStack)) {
                        player.func_71019_a(itemStack, false);
                        tileEntity.func_70296_d();
                    } else {
                        GrowthcraftMilk.LOGGER.log(Level.DEBUG, "ItemStack is empty or we were unable to add it to the player inventory.");
                    }
                }
                return ActionResultType.SUCCESS;
            }
            if (hand.name().equals("MAIN_HAND") && tileEntity.isOpen()) {
                if (tileEntity.getInventory().getStackInSlot(0).func_190926_b()) {
                    ItemStack itemStackToInsert = player.func_184586_b(hand).getStack().func_77946_l();
                    itemStackToInsert.func_190920_e(1);
                    tileEntity.getInventory().insertItem(0, itemStackToInsert, false);
                    player.func_184586_b(hand).func_190918_g(1);
                    tileEntity.func_70296_d();
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return BOUNDING_BOX;
    }

    @Nonnull
    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity tileentity = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (tileentity instanceof CheesePressTileEntity) {
            CheesePressTileEntity cheesePressTileEntity = (CheesePressTileEntity)tileentity;
            builder = builder.func_216017_a(CONTENTS, (context, stackConsumer) -> {
                for (int i = 0; i < cheesePressTileEntity.func_70302_i_(); ++i) {
                    stackConsumer.accept(cheesePressTileEntity.func_70301_a(i));
                }
            });
        }
        return super.func_220076_a(state, builder);
    }
}

