/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.crafting.item;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.StackList;
import net.minecraftforge.registries.ForgeRegistries;

public class IngredientEnchantmentType
extends Ingredient {
    private final Serializer serializer;
    private final EnchantmentType type;

    public static Serializer create(EnchantmentType type) {
        return new Serializer(type);
    }

    private IngredientEnchantmentType(EnchantmentType type, Serializer serializer, Stream<? extends Ingredient.IItemList> itemLists) {
        super(itemLists);
        this.serializer = serializer;
        this.type = type;
    }

    public boolean test(ItemStack stack) {
        return this.type.func_77557_a(stack.func_77973_b());
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<IngredientEnchantmentType> getSerializer() {
        return this.serializer;
    }

    static class Serializer
    implements IIngredientSerializer<IngredientEnchantmentType> {
        private final EnchantmentType type;
        private IngredientEnchantmentType ingredient;

        private Serializer(EnchantmentType type) {
            this.type = type;
        }

        public IngredientEnchantmentType parse(PacketBuffer buffer) {
            return new IngredientEnchantmentType(this.type, this, Stream.generate(() -> new Ingredient.SingleItemList(buffer.func_150791_c())).limit(buffer.func_150792_a()));
        }

        public IngredientEnchantmentType parse(JsonObject json) {
            if (this.ingredient == null) {
                this.ingredient = new IngredientEnchantmentType(this.type, this, Stream.of(new StackList(this.getMatchingItems())));
            }
            return this.ingredient;
        }

        public void write(PacketBuffer buffer, IngredientEnchantmentType ingredient) {
            ItemStack[] items = ingredient.func_193365_a();
            buffer.func_150787_b(items.length);
            for (ItemStack stack : items) {
                buffer.func_150788_a(stack);
            }
        }

        private List<ItemStack> getMatchingItems() {
            NonNullList matchingItems = NonNullList.func_191196_a();
            for (Item item : ForgeRegistries.ITEMS.getValues()) {
                if (!this.type.func_77557_a(item)) continue;
                matchingItems.add(new ItemStack((IItemProvider)item));
            }
            return matchingItems;
        }
    }
}

