/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.block;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.silentchaos512.mechanisms.api.RedstoneMode;
import net.silentchaos512.mechanisms.api.crafting.recipe.fluid.FluidIngredient;
import net.silentchaos512.mechanisms.api.crafting.recipe.fluid.IFluidInventory;
import net.silentchaos512.mechanisms.api.crafting.recipe.fluid.IFluidRecipe;
import net.silentchaos512.mechanisms.block.AbstractMachineTileEntity;
import net.silentchaos512.mechanisms.util.MachineTier;
import net.silentchaos512.utils.EnumUtils;

public abstract class AbstractFluidMachineTileEntity<R extends IFluidRecipe<?>>
extends AbstractMachineTileEntity<R>
implements IFluidInventory {
    protected final FluidTank[] tanks;
    private final LazyOptional<IFluidHandler> fluidHandlerCap;
    protected final IIntArray fields = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return AbstractFluidMachineTileEntity.this.getEnergyStored() & 0xFFFF;
                }
                case 1: {
                    return AbstractFluidMachineTileEntity.this.getEnergyStored() >> 16 & 0xFFFF;
                }
                case 2: {
                    return AbstractFluidMachineTileEntity.this.getMaxEnergyStored() & 0xFFFF;
                }
                case 3: {
                    return AbstractFluidMachineTileEntity.this.getMaxEnergyStored() >> 16 & 0xFFFF;
                }
                case 4: {
                    return AbstractFluidMachineTileEntity.this.redstoneMode.ordinal();
                }
                case 5: {
                    return (int)AbstractFluidMachineTileEntity.this.progress;
                }
                case 6: {
                    return AbstractFluidMachineTileEntity.this.processTime;
                }
            }
            int tankIndex = (index - 7) / 2;
            if (tankIndex >= AbstractFluidMachineTileEntity.this.tanks.length) {
                return 0;
            }
            if (index % 2 == 1) {
                return Registry.field_212619_h.func_148757_b((Object)AbstractFluidMachineTileEntity.this.tanks[tankIndex].getFluid().getFluid());
            }
            return AbstractFluidMachineTileEntity.this.tanks[tankIndex].getFluidAmount();
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 4: {
                    AbstractFluidMachineTileEntity.this.redstoneMode = (RedstoneMode)EnumUtils.byOrdinal((int)value, (Enum)RedstoneMode.IGNORED);
                    break;
                }
                case 5: {
                    AbstractFluidMachineTileEntity.this.progress = value;
                    break;
                }
                case 6: {
                    AbstractFluidMachineTileEntity.this.processTime = value;
                }
            }
        }

        public int func_221478_a() {
            return 7 + 2 * AbstractFluidMachineTileEntity.this.tanks.length;
        }
    };

    protected AbstractFluidMachineTileEntity(TileEntityType<?> typeIn, int inventorySize, int tankCount, int tankCapacity, MachineTier tier) {
        super(typeIn, inventorySize, tier);
        this.tanks = (FluidTank[])IntStream.range(0, tankCount).mapToObj(k -> new FluidTank(tankCapacity)).toArray(FluidTank[]::new);
        this.fluidHandlerCap = LazyOptional.of(() -> this);
    }

    protected abstract int getInputTanks();

    protected abstract int getOutputTanks();

    protected abstract Collection<FluidStack> getFluidResults(R var1);

    protected Collection<FluidStack> getPossibleFluidResults(R recipe) {
        return this.getFluidResults(recipe);
    }

    @Override
    protected Collection<ItemStack> getProcessResults(R recipe) {
        return Collections.emptyList();
    }

    @Override
    protected int[] getOutputSlots() {
        return new int[0];
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        IFluidRecipe recipe = (IFluidRecipe)this.getRecipe();
        if (recipe != null && this.canMachineRun(recipe)) {
            this.processTime = this.getProcessTime(recipe);
            this.progress += this.getProcessSpeed();
            this.energy.consumeEnergy((int)((float)this.getEnergyUsedPerTick() * this.getUpgradesEnergyMultiplier()));
            if (this.progress >= (float)this.processTime) {
                this.getFluidResults(recipe).forEach(this::storeResultFluid);
                this.getProcessResults((R)recipe).forEach(this::storeResultItem);
                this.consumeFeedstock(recipe);
                this.consumeIngredients((R)recipe);
                this.progress = 0.0f;
                if (this.getRecipe() == null) {
                    this.setInactiveState();
                }
            } else {
                this.sendUpdate(this.getActiveState(this.field_145850_b.func_180495_p(this.field_174879_c)));
            }
        } else {
            if (recipe == null) {
                this.progress = 0.0f;
            }
            this.setInactiveState();
        }
    }

    private boolean canMachineRun(R recipe) {
        return this.field_145850_b != null && this.getEnergyStored() >= this.getEnergyUsedPerTick() && this.hasRoomInOutputTank(this.getPossibleFluidResults(recipe)) && this.hasRoomInOutput(this.getPossibleProcessResult(recipe)) && this.redstoneMode.shouldRun(this.field_145850_b.func_175687_A(this.field_174879_c) > 0);
    }

    private boolean hasRoomInOutputTank(Iterable<FluidStack> results) {
        for (FluidStack stack : results) {
            if (this.hasRoomForOutputFluid(stack)) continue;
            return false;
        }
        return true;
    }

    private boolean hasRoomForOutputFluid(FluidStack stack) {
        int inputs = this.getInputTanks();
        int outputs = this.getOutputTanks();
        for (int i = inputs; i < inputs + outputs; ++i) {
            if (this.tanks[i].fill(stack, IFluidHandler.FluidAction.SIMULATE) != stack.getAmount()) continue;
            return true;
        }
        return false;
    }

    private void storeResultFluid(FluidStack stack) {
        int inputs = this.getInputTanks();
        int outputs = this.getOutputTanks();
        for (int i = inputs; i < inputs + outputs; ++i) {
            if (this.tanks[i].fill(stack, IFluidHandler.FluidAction.SIMULATE) != stack.getAmount()) continue;
            this.tanks[i].fill(stack, IFluidHandler.FluidAction.EXECUTE);
            break;
        }
    }

    private void consumeFeedstock(R recipe) {
        block0: for (FluidIngredient ingredient : recipe.getFluidIngredients()) {
            for (int i = 0; i < this.getInputTanks(); ++i) {
                if (!ingredient.test(this.getFluidInTank(i))) continue;
                this.tanks[i].drain(ingredient.getAmount(), IFluidHandler.FluidAction.EXECUTE);
                continue block0;
            }
        }
    }

    @Override
    protected abstract void consumeIngredients(R var1);

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.fluidHandlerCap.invalidate();
    }

    @Override
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.field_145846_f && cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.orEmpty(cap, this.fluidHandlerCap.cast());
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tags) {
        ListNBT list = tags.func_150295_c("Tanks", 10);
        for (int i = 0; i < this.tanks.length && i < list.size(); ++i) {
            INBT nbt = list.get(i);
            this.tanks[i].setFluid(FluidStack.loadFluidStackFromNBT((CompoundNBT)((CompoundNBT)nbt)));
        }
        super.func_230337_a_(state, tags);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tags) {
        ListNBT list = new ListNBT();
        for (FluidTank tank : this.tanks) {
            list.add((Object)tank.writeToNBT(new CompoundNBT()));
        }
        tags.func_218657_a("Tanks", (INBT)list);
        return super.func_189515_b(tags);
    }

    public int getTanks() {
        return this.tanks.length;
    }

    public FluidStack getFluidInTank(int tank) {
        if (tank < 0 || tank >= this.tanks.length) {
            return FluidStack.EMPTY;
        }
        return this.tanks[tank].getFluid();
    }

    public int getTankCapacity(int tank) {
        if (tank < 0 || tank >= this.tanks.length) {
            return 0;
        }
        return this.tanks[tank].getCapacity();
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        if (tank < 0 || tank >= this.tanks.length) {
            return false;
        }
        return this.tanks[tank].isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        for (int i = 0; i < this.getInputTanks(); ++i) {
            FluidStack fluidInTank = this.tanks[i].getFluid();
            if (!this.isFluidValid(i, resource) || !fluidInTank.isEmpty() && !resource.isFluidEqual(fluidInTank)) continue;
            return this.tanks[i].fill(resource, action);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return FluidStack.EMPTY;
        }
        for (int i = this.getInputTanks(); i < this.getInputTanks() + this.getOutputTanks(); ++i) {
            if (!resource.isFluidEqual(this.tanks[i].getFluid())) continue;
            return this.tanks[i].drain(resource, action);
        }
        return FluidStack.EMPTY;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        for (int i = this.getInputTanks(); i < this.getInputTanks() + this.getOutputTanks(); ++i) {
            if (this.tanks[i].getFluidAmount() <= 0) continue;
            return this.tanks[i].drain(maxDrain, action);
        }
        return FluidStack.EMPTY;
    }
}

