/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.crafting.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.silentchaos512.mechanisms.api.crafting.recipe.fluid.FluidIngredient;
import net.silentchaos512.mechanisms.api.crafting.recipe.fluid.IFluidInventory;
import net.silentchaos512.mechanisms.api.crafting.recipe.fluid.IFluidRecipe;
import net.silentchaos512.mechanisms.init.ModRecipes;

public class InfusingRecipe
implements IFluidRecipe<IFluidInventory> {
    private final ResourceLocation recipeId;
    private final int processTime;
    private final Ingredient ingredient;
    private final FluidIngredient fluid;
    private final ItemStack result;

    public InfusingRecipe(ResourceLocation recipeId, int processTime, Ingredient ingredient, FluidIngredient fluid, ItemStack result) {
        this.recipeId = recipeId;
        this.processTime = processTime;
        this.ingredient = ingredient;
        this.fluid = fluid;
        this.result = result;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public FluidIngredient getFluidIngredient() {
        return this.fluid;
    }

    @Override
    public List<FluidStack> getFluidResults(IFluidInventory inv) {
        return Collections.emptyList();
    }

    @Override
    public List<FluidStack> getFluidOutputs() {
        return Collections.emptyList();
    }

    @Override
    public List<FluidIngredient> getFluidIngredients() {
        return Collections.singletonList(this.fluid);
    }

    public boolean matches(IFluidInventory inv, World worldIn) {
        FluidStack fluidInTank = inv.getFluidInTank(0);
        ItemStack input = inv.func_70301_a(2);
        return this.fluid.test(fluidInTank) && this.ingredient.test(input);
    }

    @Override
    public ItemStack func_77571_b() {
        return this.result.func_77946_l();
    }

    public ResourceLocation func_199560_c() {
        return this.recipeId;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipes.INFUSING.get();
    }

    public IRecipeType<?> func_222127_g() {
        return ModRecipes.Types.INFUSING;
    }

    public boolean func_192399_d() {
        return true;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<InfusingRecipe> {
        public InfusingRecipe read(ResourceLocation recipeId, JsonObject json) {
            int processTime = JSONUtils.func_151203_m((JsonObject)json, (String)"process_time");
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)json.get("ingredient"));
            FluidIngredient fluid = FluidIngredient.deserialize(json.getAsJsonObject("fluid"));
            ItemStack result = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            return new InfusingRecipe(recipeId, processTime, ingredient, fluid, result);
        }

        @Nullable
        public InfusingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            int processTime = buffer.func_150792_a();
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            FluidIngredient fluid = FluidIngredient.read(buffer);
            ItemStack result = buffer.func_150791_c();
            return new InfusingRecipe(recipeId, processTime, ingredient, fluid, result);
        }

        public void write(PacketBuffer buffer, InfusingRecipe recipe) {
            buffer.func_150787_b(recipe.processTime);
            recipe.ingredient.func_199564_a(buffer);
            recipe.fluid.write(buffer);
            buffer.func_150788_a(recipe.result);
        }
    }
}

