/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.trapper.init.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.io.File;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.loading.FMLPaths;

public class GrowthcraftTrapperConfig {
    public static final String SERVER_CONFIG = String.format("growthcraft-%s-server.toml", "trapper");
    public static final String CLIENT_CONFIG = String.format("growthcraft-%s-client.toml", "trapper");
    public static final ForgeConfigSpec.Builder SERVER_BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.Builder CLIENT_BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SERVER = SERVER_BUILDER.build();
    public static final ForgeConfigSpec CLIENT = CLIENT_BUILDER.build();

    private GrowthcraftTrapperConfig() {
    }

    public static void loadConfig() {
        GrowthcraftTrapperConfig.loadConfig(SERVER, FMLPaths.CONFIGDIR.get().resolve(SERVER_CONFIG).toString());
        GrowthcraftTrapperConfig.loadConfig(CLIENT, FMLPaths.CONFIGDIR.get().resolve(CLIENT_CONFIG).toString());
    }

    public static void loadConfig(ForgeConfigSpec configSpec, String path) {
        CommentedFileConfig fileConfig = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(path)).sync().autosave().writingMode(WritingMode.REPLACE).build();
        fileConfig.load();
        configSpec.setConfig((CommentedConfig)fileConfig);
    }
}

