/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.tracking;

import com.cazsius.solcarrot.SOLCarrot;
import com.cazsius.solcarrot.SOLCarrotConfig;
import com.cazsius.solcarrot.api.FoodCapability;
import com.cazsius.solcarrot.communication.FoodListMessage;
import com.cazsius.solcarrot.tracking.FoodList;
import com.cazsius.solcarrot.tracking.MaxHealthHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.network.NetworkDirection;

@Mod.EventBusSubscriber(modid="solcarrot")
public final class CapabilityHandler {
    private static final ResourceLocation FOOD = SOLCarrot.resourceLocation("food");

    @SubscribeEvent
    public static void attachPlayerCapability(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof PlayerEntity)) {
            return;
        }
        event.addCapability(FOOD, (ICapabilityProvider)new FoodList());
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        CapabilityHandler.syncFoodList(event.getPlayer());
    }

    @SubscribeEvent
    public static void onPlayerDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        CapabilityHandler.syncFoodList(event.getPlayer());
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        if (event.isWasDeath() && SOLCarrotConfig.shouldResetOnDeath()) {
            return;
        }
        PlayerEntity originalPlayer = event.getOriginal();
        originalPlayer.revive();
        FoodList original = FoodList.get(originalPlayer);
        FoodList newInstance = FoodList.get(event.getPlayer());
        newInstance.deserializeNBT(original.serializeNBT());
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        CapabilityHandler.syncFoodList(event.getPlayer());
    }

    public static void syncFoodList(PlayerEntity player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        ServerPlayerEntity target = (ServerPlayerEntity)player;
        SOLCarrot.channel.sendTo((Object)new FoodListMessage(FoodList.get(player)), target.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
        MaxHealthHandler.updateFoodHPModifier(player);
    }

    @Mod.EventBusSubscriber(modid="solcarrot", bus=Mod.EventBusSubscriber.Bus.MOD)
    private static final class Setup {
        private Setup() {
        }

        @SubscribeEvent
        public static void setUp(FMLCommonSetupEvent event) {
            CapabilityManager.INSTANCE.register(FoodCapability.class, (Capability.IStorage)new FoodList.Storage(), FoodList::new);
        }
    }
}

