/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.item;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.silentchaos512.gear.api.item.GearType;

public class GearTypeMatcher
implements Predicate<GearType> {
    public static final GearTypeMatcher ALL = new GearTypeMatcher(true, GearType.ALL);
    private final List<GearType> types = new ArrayList<GearType>();
    private final boolean matchParents;

    public GearTypeMatcher(boolean matchParents, GearType ... typesIn) {
        this.matchParents = matchParents;
        this.types.addAll(Arrays.asList(typesIn));
    }

    @Override
    public boolean test(GearType gearType) {
        for (GearType type : this.types) {
            if (!(this.matchParents ? gearType.matches(type) : gearType == type)) continue;
            return true;
        }
        return false;
    }

    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        JsonArray typesArray = new JsonArray();
        this.types.forEach(t -> typesArray.add(t.getName()));
        json.add("types", (JsonElement)typesArray);
        json.addProperty("match_parents", Boolean.valueOf(this.matchParents));
        return json;
    }

    public static GearTypeMatcher deserialize(JsonObject json) {
        boolean matchParents = JSONUtils.func_151212_i((JsonObject)json, (String)"match_parents");
        GearTypeMatcher result = new GearTypeMatcher(matchParents, new GearType[0]);
        JsonArray array = json.getAsJsonArray("types");
        for (JsonElement e : array) {
            GearType type = GearType.get(e.getAsString());
            if (type == GearType.NONE) continue;
            result.types.add(type);
        }
        return result;
    }

    public static GearTypeMatcher read(PacketBuffer buffer) {
        boolean matchParents = buffer.readBoolean();
        GearTypeMatcher result = new GearTypeMatcher(matchParents, new GearType[0]);
        int count = buffer.readByte();
        for (int i = 0; i < count; ++i) {
            result.types.add(GearType.get(buffer.func_218666_n()));
        }
        return result;
    }

    public void write(PacketBuffer buffer) {
        buffer.writeBoolean(this.matchParents);
        buffer.writeByte(this.types.size());
        this.types.forEach(t -> buffer.func_180714_a(t.getName()));
    }
}

