/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.salvager;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Random;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.block.salvager.SalvagerContainer;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.crafting.recipe.salvage.SalvagingRecipe;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.init.ModRecipes;
import net.silentchaos512.gear.init.ModTileEntities;
import net.silentchaos512.lib.tile.LockableSidedInventoryTileEntity;
import net.silentchaos512.lib.tile.SyncVariable;
import net.silentchaos512.lib.util.TimeUtils;
import net.silentchaos512.utils.MathUtils;

public class SalvagerTileEntity
extends LockableSidedInventoryTileEntity
implements ITickableTileEntity {
    static final int BASE_WORK_TIME = TimeUtils.ticksFromSeconds((float)(SilentGear.isDevBuild() ? 2.0f : 10.0f));
    private static final int INPUT_SLOT = 0;
    private static final int[] SLOTS_INPUT = new int[]{0};
    private static final int[] SLOTS_OUTPUT = IntStream.rangeClosed(1, 18).toArray();
    private static final int[] SLOTS_ALL = IntStream.rangeClosed(0, 18).toArray();
    public static final int INVENTORY_SIZE = SLOTS_INPUT.length + SLOTS_OUTPUT.length;
    @SyncVariable(name="progress")
    int progress = 0;
    private final IIntArray fields = new IIntArray(){

        public int func_221476_a(int index) {
            return SalvagerTileEntity.this.progress;
        }

        public void func_221477_a(int index, int value) {
            SalvagerTileEntity.this.progress = value;
        }

        public int func_221478_a() {
            return 1;
        }
    };

    public SalvagerTileEntity() {
        super((TileEntityType)ModTileEntities.SALVAGER.get(), INVENTORY_SIZE);
    }

    @Nullable
    private SalvagingRecipe getRecipe() {
        if (this.field_145850_b == null) {
            return null;
        }
        return this.field_145850_b.func_199532_z().func_215371_a(ModRecipes.SALVAGING_TYPE, (IInventory)this, this.field_145850_b).orElse(null);
    }

    public int func_70302_i_() {
        return INVENTORY_SIZE;
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack input = this.func_70301_a(0);
        SalvagingRecipe recipe = this.getRecipe();
        if (recipe != null) {
            if (this.progress < BASE_WORK_TIME) {
                ++this.progress;
            }
            if (this.progress >= BASE_WORK_TIME && this.areAllOutputSlotsFree()) {
                for (ItemStack stack : this.getSalvagedPartsWithChance(recipe, input)) {
                    int slot = this.getFreeOutputSlot();
                    if (slot > 0) {
                        this.func_70299_a(slot, stack);
                        continue;
                    }
                    SilentGear.LOGGER.warn("Item lost in salvager: {}", (Object)stack);
                }
                this.progress = 0;
                input.func_190918_g(1);
                if (input.func_190926_b()) {
                    this.func_70299_a(0, ItemStack.field_190927_a);
                }
            }
        } else {
            this.progress = 0;
        }
    }

    private Collection<ItemStack> getSalvagedPartsWithChance(SalvagingRecipe recipe, ItemStack stack) {
        double lossRate = SalvagerTileEntity.getLossRate(stack);
        SilentGear.LOGGER.debug("Loss rate for '{}': {}", (Object)stack, (Object)lossRate);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ItemStack part : recipe.getPossibleResults((IInventory)this)) {
            ItemStack copy = part.func_77946_l();
            int count = copy.func_190916_E();
            PartData partData = PartData.from(part);
            double partLossRate = partData != null ? partData.get().getSalvageLossRate(partData, stack, lossRate) : lossRate;
            for (int i = 0; i < count; ++i) {
                if (!MathUtils.tryPercentage((Random)SilentGear.RANDOM, (double)partLossRate)) continue;
                copy.func_190918_g(1);
            }
            if (copy.func_190926_b()) continue;
            builder.add((Object)copy);
        }
        return builder.build();
    }

    private static double getLossRate(ItemStack stack) {
        int maxDamage = stack.func_77958_k();
        double min = (Double)Config.Common.salvagerMinLossRate.get();
        if (maxDamage == 0) {
            return min;
        }
        double ratio = (double)stack.func_77952_i() / (double)maxDamage;
        return min + ratio * ((Double)Config.Common.salvagerMaxLossRate.get() - min);
    }

    private int getFreeOutputSlot() {
        for (int slot : SLOTS_OUTPUT) {
            if (!this.func_70301_a(slot).func_190926_b()) continue;
            return slot;
        }
        return -1;
    }

    private boolean areAllOutputSlotsFree() {
        for (int slot : SLOTS_OUTPUT) {
            if (this.func_70301_a(slot).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tags = super.func_189517_E_();
        SyncVariable.Helper.writeSyncVars((Object)((Object)this), (CompoundNBT)tags, (SyncVariable.Type)SyncVariable.Type.PACKET);
        return tags;
    }

    public int[] func_180463_a(Direction side) {
        switch (side) {
            case DOWN: {
                return SLOTS_OUTPUT;
            }
            case UP: {
                return SLOTS_INPUT;
            }
        }
        return SLOTS_ALL;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (stack.func_190926_b() || SalvagerTileEntity.isOutputSlot(index)) {
            return false;
        }
        ItemStack current = this.func_70301_a(index);
        if (!current.func_190926_b() && !current.func_77969_a(stack)) {
            return false;
        }
        return SalvagerTileEntity.isInputSlot(index) || super.func_94041_b(index, stack);
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return SalvagerTileEntity.isOutputSlot(index);
    }

    private static boolean isInputSlot(int index) {
        for (int k : SLOTS_INPUT) {
            if (index != k) continue;
            return true;
        }
        return false;
    }

    private static boolean isOutputSlot(int index) {
        for (int k : SLOTS_OUTPUT) {
            if (index != k) continue;
            return true;
        }
        return false;
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.silentgear.salvager");
    }

    protected Container func_213906_a(int id, PlayerInventory playerInventory) {
        return new SalvagerContainer(id, playerInventory, (IInventory)this, this.fields);
    }
}

