/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.model.part;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.geometry.IModelGeometryPart;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialDisplay;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.MaterialLayer;
import net.silentchaos512.gear.api.material.StaticLayer;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.client.material.MaterialDisplayManager;
import net.silentchaos512.gear.client.model.BakedPerspectiveModel;
import net.silentchaos512.gear.client.model.BakedWrapper;
import net.silentchaos512.gear.client.model.LayeredModel;
import net.silentchaos512.gear.client.model.PartTextures;
import net.silentchaos512.gear.client.model.part.CompoundPartModelOverrideList;
import net.silentchaos512.gear.gear.material.LazyMaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.ModResourceLocation;
import net.silentchaos512.utils.Color;

public class CompoundPartModel
extends LayeredModel<CompoundPartModel> {
    private static final ModResourceLocation PART_MARKER_TEXTURE = SilentGear.getId("part_marker");
    private final ItemCameraTransforms cameraTransforms;
    final GearType gearType;
    final PartType partType;
    final String texturePath;
    private final List<ResourceLocation> extraLayers;
    private CompoundPartModelOverrideList overrideList;

    CompoundPartModel(ItemCameraTransforms cameraTransforms, GearType gearType, PartType partType, String texturePath, List<ResourceLocation> extraLayers) {
        this.cameraTransforms = cameraTransforms;
        this.gearType = gearType;
        this.partType = partType;
        this.texturePath = texturePath;
        this.extraLayers = Collections.unmodifiableList(extraLayers);
    }

    public void clearCache() {
        if (this.overrideList != null) {
            this.overrideList.clearCache();
        }
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        this.overrideList = new CompoundPartModelOverrideList(this, owner, bakery, spriteGetter, modelTransform, modelLocation);
        return new BakedWrapper(this, owner, bakery, spriteGetter, modelTransform, modelLocation, this.overrideList);
    }

    public IBakedModel bake(List<MaterialLayer> layers, String transformVariant, IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrideList, ResourceLocation modelLocation) {
        int i;
        ImmutableList.Builder builder = ImmutableList.builder();
        TransformationMatrix rotation = modelTransform.func_225615_b_();
        ImmutableMap transforms = PerspectiveMapWrapper.getTransforms((IModelTransform)modelTransform);
        for (i = 0; i < layers.size(); ++i) {
            MaterialLayer layer = layers.get(i);
            TextureAtlasSprite texture = spriteGetter.apply(new RenderMaterial(PlayerContainer.field_226615_c_, layer.getTexture(this.texturePath, 0)));
            builder.addAll(CompoundPartModel.getQuadsForSprite(i, texture, rotation, layer.getColor()));
        }
        if (layers.isEmpty()) {
            if (Const.Materials.EXAMPLE.isPresent()) {
                this.buildFakeModel(spriteGetter, (ImmutableList.Builder<BakedQuad>)builder, rotation, Const.Materials.EXAMPLE.get());
            } else {
                SilentGear.LOGGER.error("Example material is missing?");
                TextureAtlasSprite texture = spriteGetter.apply(new RenderMaterial(PlayerContainer.field_226615_c_, (ResourceLocation)SilentGear.getId("item/error")));
                builder.addAll(CompoundPartModel.getQuadsForSprite(0, texture, rotation, 0xFFFFFF));
            }
        }
        for (i = 0; i < this.extraLayers.size(); ++i) {
            ResourceLocation texture = this.extraLayers.get(i);
            builder.addAll(CompoundPartModel.getQuadsForSprite(layers.size() + i, spriteGetter.apply(new RenderMaterial(PlayerContainer.field_226615_c_, new StaticLayer(texture).getTexture())), rotation, 0xFFFFFF));
        }
        builder.addAll(CompoundPartModel.getQuadsForSprite(layers.size(), spriteGetter.apply(new RenderMaterial(PlayerContainer.field_226615_c_, new StaticLayer(PART_MARKER_TEXTURE).getTexture())), rotation, Color.LIGHTSKYBLUE.getColor()));
        TextureAtlasSprite particle = spriteGetter.apply(owner.resolveTexture("particle"));
        return new BakedPerspectiveModel((ImmutableList<BakedQuad>)builder.build(), particle, (ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix>)transforms, overrideList, rotation.isIdentity(), owner.isSideLit(), this.getCameraTransforms(transformVariant));
    }

    private void buildFakeModel(Function<RenderMaterial, TextureAtlasSprite> spriteGetter, ImmutableList.Builder<BakedQuad> builder, TransformationMatrix rotation, IMaterial material) {
        MaterialInstance mat = MaterialInstance.of(material);
        IMaterialDisplay model = MaterialDisplayManager.get(mat);
        MaterialLayer exampleMain = model.getLayerList(this.gearType, this.partType, (IMaterialInstance)mat).getFirstLayer();
        if (exampleMain != null) {
            builder.addAll(CompoundPartModel.getQuadsForSprite(0, spriteGetter.apply(new RenderMaterial(PlayerContainer.field_226615_c_, exampleMain.getTexture(this.texturePath, 0))), rotation, exampleMain.getColor()));
        }
        builder.addAll(CompoundPartModel.getQuadsForSprite(0, spriteGetter.apply(new RenderMaterial(PlayerContainer.field_226615_c_, new StaticLayer(PART_MARKER_TEXTURE).getTexture(this.gearType, 0))), rotation, 0xFFFFFF));
    }

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet<RenderMaterial> ret = new HashSet<RenderMaterial>();
        if (this.gearType == GearType.SHIELD) {
            return ret;
        }
        for (PartTextures tex : PartTextures.getTextures(this.gearType)) {
            ret.add(this.getTexture(tex.getTexture()));
        }
        for (IMaterialDisplay materialDisplay : MaterialDisplayManager.getMaterials()) {
            for (MaterialLayer layer : materialDisplay.getLayerList(this.gearType, this.partType, (IMaterialInstance)LazyMaterialInstance.of(materialDisplay.getMaterialId()))) {
                ret.add(this.getTexture(layer));
            }
        }
        for (ResourceLocation texture : this.extraLayers) {
            ret.add(this.getTexture(new StaticLayer(texture)));
        }
        ret.add(this.getTexture(new StaticLayer(PART_MARKER_TEXTURE)));
        ret.add(new RenderMaterial(PlayerContainer.field_226615_c_, (ResourceLocation)SilentGear.getId("item/error")));
        if (CompoundPartModelOverrideList.isDebugLoggingEnabled()) {
            SilentGear.LOGGER.info("Textures for compound part model '{}'", (Object)PartGearKey.of(this.gearType, this.partType));
            for (RenderMaterial mat : ret) {
                SilentGear.LOGGER.info("- {}", (Object)mat.func_229313_b_());
            }
        }
        return ret;
    }

    private RenderMaterial getTexture(MaterialLayer layer) {
        return CompoundPartModel.getMaterial(layer.getTexture(this.texturePath, 0));
    }

    private RenderMaterial getTexture(ResourceLocation tex) {
        String path = "item/" + this.texturePath + "/" + tex.func_110623_a();
        ResourceLocation location = new ResourceLocation(tex.func_110624_b(), path);
        return CompoundPartModel.getMaterial(location);
    }

    private static RenderMaterial getMaterial(ResourceLocation tex) {
        return new RenderMaterial(PlayerContainer.field_226615_c_, tex);
    }

    public Collection<? extends IModelGeometryPart> getParts() {
        return Collections.emptyList();
    }

    public Optional<? extends IModelGeometryPart> getPart(String name) {
        return Optional.empty();
    }

    private ItemCameraTransforms getCameraTransforms(String transformVariant) {
        return this.cameraTransforms;
    }
}

