/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.gear.trait.SimpleTrait;

public final class BonusDropsTrait
extends SimpleTrait {
    public static final ITraitSerializer<BonusDropsTrait> SERIALIZER = new SimpleTrait.Serializer<BonusDropsTrait>(SilentGear.getId("bonus_drops"), BonusDropsTrait::new, (trait, json) -> {
        trait.baseChance = JSONUtils.func_151221_a((JsonObject)json, (String)"base_chance", (float)0.0f);
        trait.bonusMultiplier = JSONUtils.func_151221_a((JsonObject)json, (String)"bonus_multiplier", (float)1.0f);
        trait.readIngredient(json.get("ingredient"));
    }, (trait, buffer) -> {
        trait.baseChance = buffer.readFloat();
        trait.bonusMultiplier = buffer.readFloat();
        trait.ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
        trait.matchedItemsText = buffer.func_218666_n();
    }, (trait, buffer) -> {
        buffer.writeFloat(trait.baseChance);
        buffer.writeFloat(trait.bonusMultiplier);
        trait.ingredient.func_199564_a(buffer);
        buffer.func_180714_a(trait.matchedItemsText);
    });
    private float baseChance;
    private float bonusMultiplier;
    private Ingredient ingredient = Ingredient.field_193370_a;
    private String matchedItemsText = "some items";

    private BonusDropsTrait(ResourceLocation id) {
        super(id, SERIALIZER);
    }

    private void readIngredient(JsonElement json) {
        this.ingredient = Ingredient.func_199802_a((JsonElement)json);
        if (json.isJsonObject()) {
            JsonObject obj = json.getAsJsonObject();
            if (obj.has("tag")) {
                this.matchedItemsText = "`" + obj.get("tag").getAsString() + "` (tag)";
            } else if (obj.has("item")) {
                this.matchedItemsText = "`" + obj.get("item").getAsString() + "`";
            }
        }
    }

    @Override
    public ItemStack addLootDrops(TraitActionContext context, ItemStack stack) {
        if (this.ingredient.test(stack) && SilentGear.RANDOM.nextFloat() < this.baseChance * (float)context.getTraitLevel()) {
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(Math.round((float)stack.func_190916_E() * this.bonusMultiplier));
            return copy;
        }
        return super.addLootDrops(context, stack);
    }

    @Override
    public Collection<String> getExtraWikiLines() {
        Collection<String> ret = super.getExtraWikiLines();
        ret.add(String.format("  - %d%% chance per level of dropping %d%% more of %s", (int)(100.0f * this.baseChance), (int)(100.0f * this.bonusMultiplier), this.matchedItemsText));
        return ret;
    }
}

