/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.gear.trait.SimpleTrait;
import net.silentchaos512.lib.util.NameUtils;

public class CancelEffectsTrait
extends SimpleTrait {
    public static final ITraitSerializer<CancelEffectsTrait> SERIALIZER = new SimpleTrait.Serializer<CancelEffectsTrait>(SilentGear.getId("cancel_effects"), CancelEffectsTrait::new, CancelEffectsTrait::deserialize, CancelEffectsTrait::decode, CancelEffectsTrait::encode);
    private final Collection<Effect> effects = new ArrayList<Effect>();

    public CancelEffectsTrait(ResourceLocation id) {
        super(id, SERIALIZER);
    }

    private static void deserialize(CancelEffectsTrait trait, JsonObject json) {
        JsonArray array = json.getAsJsonArray("effects");
        for (JsonElement element : array) {
            Effect effect = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(element.getAsString()));
            if (effect == null) continue;
            trait.effects.add(effect);
        }
    }

    private static void decode(CancelEffectsTrait trait, PacketBuffer buffer) {
        int count = buffer.readByte();
        for (int i = 0; i < count; ++i) {
            Effect effect = (Effect)ForgeRegistries.POTIONS.getValue(buffer.func_192575_l());
            if (effect == null) continue;
            trait.effects.add(effect);
        }
    }

    private static void encode(CancelEffectsTrait trait, PacketBuffer buffer) {
        buffer.writeByte(trait.effects.size());
        trait.effects.forEach(effect -> buffer.func_192572_a(NameUtils.from((IForgeRegistryEntry)effect)));
    }

    @Override
    public void onUpdate(TraitActionContext context, boolean isEquipped) {
        PlayerEntity player;
        if (isEquipped && (player = context.getPlayer()) != null) {
            for (Effect effect : this.effects) {
                player.func_195063_d(effect);
            }
        }
    }

    @Override
    public Collection<String> getExtraWikiLines() {
        Collection<String> ret = super.getExtraWikiLines();
        ret.add("  - Cancels these effects: " + this.effects.stream().map(e -> "`" + NameUtils.from((IForgeRegistryEntry)e) + "`").collect(Collectors.joining(", ")));
        return ret;
    }
}

