/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.init;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.OreBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TorchBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WallTorchBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockNamedItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.WallOrFloorItem;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.block.FluffyBlock;
import net.silentchaos512.gear.block.GearSmithingTableBlock;
import net.silentchaos512.gear.block.ModCropBlock;
import net.silentchaos512.gear.block.ModOreBlock;
import net.silentchaos512.gear.block.NetherwoodSapling;
import net.silentchaos512.gear.block.PhantomLight;
import net.silentchaos512.gear.block.WoodBlock;
import net.silentchaos512.gear.block.charger.ChargerTileEntity;
import net.silentchaos512.gear.block.charger.StarlightChargerBlock;
import net.silentchaos512.gear.block.compounder.CompounderBlock;
import net.silentchaos512.gear.block.grader.GraderBlock;
import net.silentchaos512.gear.block.press.MetalPressBlock;
import net.silentchaos512.gear.block.salvager.SalvagerBlock;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.init.Registration;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.lib.registry.BlockRegistryObject;

@Mod.EventBusSubscriber(modid="silentgear", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ModBlocks {
    private static final Map<Block, Block> STRIPPED_WOOD = new HashMap<Block, Block>();
    public static final BlockRegistryObject<OreBlock> BORT_ORE = ModBlocks.register("bort_ore", () -> ModBlocks.getOre(2, SoundType.field_185851_d));
    public static final BlockRegistryObject<OreBlock> DEEPSLATE_BORT_ORE = ModBlocks.register("deepslate_bort_ore", () -> ModBlocks.getOre(2, SoundType.field_185851_d));
    public static final BlockRegistryObject<OreBlock> CRIMSON_IRON_ORE = ModBlocks.register("crimson_iron_ore", () -> ModBlocks.getOre(2, SoundType.field_235598_T_));
    public static final BlockRegistryObject<OreBlock> AZURE_SILVER_ORE = ModBlocks.register("azure_silver_ore", () -> ModBlocks.getOre(4, SoundType.field_185851_d));
    public static final BlockRegistryObject<Block> RAW_CRIMSON_IRON_BLOCK = ModBlocks.register("raw_crimson_iron_block", () -> ModBlocks.getRawOreBlock(1, SoundType.field_235598_T_));
    public static final BlockRegistryObject<Block> RAW_AZURE_SILVER_BLOCK = ModBlocks.register("raw_azure_silver_block", () -> ModBlocks.getRawOreBlock(1, SoundType.field_185851_d));
    public static final BlockRegistryObject<Block> BORT_BLOCK = ModBlocks.register("bort_block", ModBlocks::getStorageBlock);
    public static final BlockRegistryObject<Block> CRIMSON_IRON_BLOCK = ModBlocks.register("crimson_iron_block", ModBlocks::getStorageBlock);
    public static final BlockRegistryObject<Block> CRIMSON_STEEL_BLOCK = ModBlocks.register("crimson_steel_block", ModBlocks::getStorageBlock);
    public static final BlockRegistryObject<Block> BLAZE_GOLD_BLOCK = ModBlocks.register("blaze_gold_block", ModBlocks::getStorageBlock);
    public static final BlockRegistryObject<Block> AZURE_SILVER_BLOCK = ModBlocks.register("azure_silver_block", ModBlocks::getStorageBlock);
    public static final BlockRegistryObject<Block> AZURE_ELECTRUM_BLOCK = ModBlocks.register("azure_electrum_block", ModBlocks::getStorageBlock);
    public static final BlockRegistryObject<Block> TYRIAN_STEEL_BLOCK = ModBlocks.register("tyrian_steel_block", ModBlocks::getStorageBlock);
    public static final BlockRegistryObject<Block> GEAR_SMITHING_TABLE = ModBlocks.register("gear_smithing_table", () -> new GearSmithingTableBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(2.5f).func_200947_a(SoundType.field_185848_a)));
    public static final BlockRegistryObject<GraderBlock> MATERIAL_GRADER = ModBlocks.register("material_grader", () -> new GraderBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(5.0f, 30.0f)));
    public static final BlockRegistryObject<SalvagerBlock> SALVAGER = ModBlocks.register("salvager", () -> new SalvagerBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(5.0f, 30.0f)));
    public static final BlockRegistryObject<StarlightChargerBlock> STARLIGHT_CHARGER = ModBlocks.register("starlight_charger", () -> new StarlightChargerBlock((BiFunction<BlockState, IBlockReader, ? extends ChargerTileEntity>)((BiFunction<BlockState, IBlockReader, ChargerTileEntity>)(state, world) -> ChargerTileEntity.createStarlightCharger()), AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(5.0f, 30.0f)));
    public static final BlockRegistryObject<CompounderBlock> METAL_ALLOYER = ModBlocks.register("metal_alloyer", () -> new CompounderBlock(Const.METAL_COMPOUNDER_INFO, AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(4.0f, 20.0f).func_200947_a(SoundType.field_185852_e)));
    public static final BlockRegistryObject<CompounderBlock> RECRYSTALLIZER = ModBlocks.register("recrystallizer", () -> new CompounderBlock(Const.GEM_COMPOUNDER_INFO, AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(4.0f, 20.0f).func_200947_a(SoundType.field_185852_e)));
    public static final BlockRegistryObject<CompounderBlock> REFABRICATOR = ModBlocks.register("refabricator", () -> new CompounderBlock(Const.FABRIC_COMPOUNDER_INFO, AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(4.0f, 20.0f).func_200947_a(SoundType.field_185852_e)));
    public static final BlockRegistryObject<MetalPressBlock> METAL_PRESS = ModBlocks.register("metal_press", () -> new MetalPressBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(4.0f, 20.0f).func_200947_a(SoundType.field_185852_e)));
    public static final BlockRegistryObject<ModCropBlock> FLAX_PLANT = ModBlocks.registerNoItem("flax_plant", () -> new ModCropBlock(() -> (BlockNamedItem)ModItems.FLAX_SEEDS.get(), AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200943_b(0.0f).func_200942_a().func_200944_c().func_200947_a(SoundType.field_222472_s)));
    public static final BlockRegistryObject<BushBlock> WILD_FLAX_PLANT = ModBlocks.registerNoItem("wild_flax_plant", () -> new BushBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200943_b(0.0f).func_200942_a().func_200947_a(SoundType.field_222472_s)));
    public static final BlockRegistryObject<ModCropBlock> FLUFFY_PLANT = ModBlocks.registerNoItem("fluffy_plant", () -> new ModCropBlock(() -> (BlockNamedItem)ModItems.FLUFFY_SEEDS.get(), AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200943_b(0.0f).func_200942_a().func_200944_c().func_200947_a(SoundType.field_222472_s)));
    public static final BlockRegistryObject<BushBlock> WILD_FLUFFY_PLANT = ModBlocks.registerNoItem("wild_fluffy_plant", () -> new BushBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200943_b(0.0f).func_200942_a().func_200947_a(SoundType.field_222472_s)));
    public static final BlockRegistryObject<FluffyBlock> WHITE_FLUFFY_BLOCK = ModBlocks.registerFluffyBlock(DyeColor.WHITE);
    public static final BlockRegistryObject<FluffyBlock> ORANGE_FLUFFY_BLOCK = ModBlocks.registerFluffyBlock(DyeColor.ORANGE);
    public static final BlockRegistryObject<FluffyBlock> MAGENTA_FLUFFY_BLOCK = ModBlocks.registerFluffyBlock(DyeColor.MAGENTA);
    public static final BlockRegistryObject<FluffyBlock> LIGHT_BLUE_FLUFFY_BLOCK = ModBlocks.registerFluffyBlock(DyeColor.LIGHT_BLUE);
    public static final BlockRegistryObject<FluffyBlock> YELLOW_FLUFFY_BLOCK = ModBlocks.registerFluffyBlock(DyeColor.YELLOW);
    public static final BlockRegistryObject<FluffyBlock> LIME_FLUFFY_BLOCK = ModBlocks.registerFluffyBlock(DyeColor.LIME);
    public static final BlockRegistryObject<FluffyBlock> PINK_FLUFFY_BLOCK = ModBlocks.registerFluffyBlock(DyeColor.PINK);
    public static final BlockRegistryObject<FluffyBlock> GRAY_FLUFFY_BLOCK = ModBlocks.registerFluffyBlock(DyeColor.GRAY);
    public static final BlockRegistryObject<FluffyBlock> LIGHT_GRAY_FLUFFY_BLOCK = ModBlocks.registerFluffyBlock(DyeColor.LIGHT_GRAY);
    public static final BlockRegistryObject<FluffyBlock> CYAN_FLUFFY_BLOCK = ModBlocks.registerFluffyBlock(DyeColor.CYAN);
    public static final BlockRegistryObject<FluffyBlock> PURPLE_FLUFFY_BLOCK = ModBlocks.registerFluffyBlock(DyeColor.PURPLE);
    public static final BlockRegistryObject<FluffyBlock> BLUE_FLUFFY_BLOCK = ModBlocks.registerFluffyBlock(DyeColor.BLUE);
    public static final BlockRegistryObject<FluffyBlock> BROWN_FLUFFY_BLOCK = ModBlocks.registerFluffyBlock(DyeColor.BROWN);
    public static final BlockRegistryObject<FluffyBlock> GREEN_FLUFFY_BLOCK = ModBlocks.registerFluffyBlock(DyeColor.GREEN);
    public static final BlockRegistryObject<FluffyBlock> RED_FLUFFY_BLOCK = ModBlocks.registerFluffyBlock(DyeColor.RED);
    public static final BlockRegistryObject<FluffyBlock> BLACK_FLUFFY_BLOCK = ModBlocks.registerFluffyBlock(DyeColor.BLACK);
    public static final BlockRegistryObject<TorchBlock> STONE_TORCH = ModBlocks.register("stone_torch", () -> new TorchBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200942_a().func_200943_b(0.0f).func_235838_a_(state -> 14).func_200947_a(SoundType.field_185851_d), (IParticleData)ParticleTypes.field_197631_x), bro -> ModBlocks.getStoneTorchItem());
    public static final BlockRegistryObject<WallTorchBlock> WALL_STONE_TORCH = ModBlocks.registerNoItem("wall_stone_torch", () -> new WallTorchBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200942_a().func_200943_b(0.0f).func_235838_a_(state -> 14).func_200947_a(SoundType.field_185851_d).func_222379_b((Block)STONE_TORCH.get()), (IParticleData)ParticleTypes.field_197631_x));
    public static final BlockRegistryObject<Block> NETHERWOOD_CHARCOAL_BLOCK = ModBlocks.register("netherwood_charcoal_block", () -> new Block(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_235861_h_().func_200948_a(5.0f, 6.0f)), bro -> () -> new BlockItem((Block)bro.get(), new Item.Properties().func_200916_a(SilentGear.ITEM_GROUP)){

        public int getBurnTime(ItemStack itemStack) {
            return 10 * (Integer)Config.Common.netherwoodCharcoalBurnTime.get();
        }
    });
    public static final BlockRegistryObject<WoodBlock> NETHERWOOD_LOG = ModBlocks.register("netherwood_log", () -> new WoodBlock(STRIPPED_WOOD::get, ModBlocks.netherWoodProps(2.0f, 2.0f)));
    public static final BlockRegistryObject<RotatedPillarBlock> STRIPPED_NETHERWOOD_LOG = ModBlocks.register("stripped_netherwood_log", () -> new RotatedPillarBlock(ModBlocks.netherWoodProps(2.0f, 2.0f)));
    public static final BlockRegistryObject<WoodBlock> NETHERWOOD_WOOD = ModBlocks.register("netherwood_wood", () -> new WoodBlock(STRIPPED_WOOD::get, ModBlocks.netherWoodProps(2.0f, 2.0f)));
    public static final BlockRegistryObject<RotatedPillarBlock> STRIPPED_NETHERWOOD_WOOD = ModBlocks.register("stripped_netherwood_wood", () -> new RotatedPillarBlock(ModBlocks.netherWoodProps(2.0f, 2.0f)));
    public static final BlockRegistryObject<Block> NETHERWOOD_PLANKS = ModBlocks.register("netherwood_planks", () -> new Block(ModBlocks.netherWoodProps(2.0f, 3.0f)));
    public static final BlockRegistryObject<SlabBlock> NETHERWOOD_SLAB = ModBlocks.register("netherwood_slab", () -> new SlabBlock(ModBlocks.netherWoodProps(2.0f, 3.0f)));
    public static final BlockRegistryObject<StairsBlock> NETHERWOOD_STAIRS = ModBlocks.register("netherwood_stairs", () -> new StairsBlock(() -> NETHERWOOD_PLANKS.asBlockState(), ModBlocks.netherWoodProps(2.0f, 3.0f)));
    public static final BlockRegistryObject<FenceBlock> NETHERWOOD_FENCE = ModBlocks.register("netherwood_fence", () -> new FenceBlock(ModBlocks.netherWoodProps(2.0f, 3.0f)));
    public static final BlockRegistryObject<FenceGateBlock> NETHERWOOD_FENCE_GATE = ModBlocks.register("netherwood_fence_gate", () -> new FenceGateBlock(ModBlocks.netherWoodProps(2.0f, 3.0f)));
    public static final BlockRegistryObject<DoorBlock> NETHERWOOD_DOOR = ModBlocks.register("netherwood_door", () -> new DoorBlock(ModBlocks.netherWoodProps(3.0f, 3.0f).func_226896_b_()));
    public static final BlockRegistryObject<TrapDoorBlock> NETHERWOOD_TRAPDOOR = ModBlocks.register("netherwood_trapdoor", () -> new TrapDoorBlock(ModBlocks.netherWoodProps(3.0f, 3.0f).func_226896_b_()));
    public static final BlockRegistryObject<LeavesBlock> NETHERWOOD_LEAVES = ModBlocks.register("netherwood_leaves", () -> new LeavesBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151584_j).func_200943_b(0.2f).func_200944_c().func_226896_b_().func_200947_a(SoundType.field_185850_c)));
    public static final BlockRegistryObject<NetherwoodSapling> NETHERWOOD_SAPLING = ModBlocks.register("netherwood_sapling", () -> new NetherwoodSapling(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200943_b(0.0f).func_200942_a().func_200944_c().func_200947_a(SoundType.field_185850_c)));
    public static final BlockRegistryObject<FlowerPotBlock> POTTED_NETHERWOOD_SAPLING = ModBlocks.registerNoItem("potted_netherwood_sapling", () -> ModBlocks.makePottedPlant(NETHERWOOD_SAPLING));
    public static final BlockRegistryObject<PhantomLight> PHANTOM_LIGHT = ModBlocks.register("phantom_light", PhantomLight::new);

    private ModBlocks() {
    }

    static void register() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerRenderTypes(FMLClientSetupEvent event) {
        RenderTypeLookup.setRenderLayer((Block)((Block)FLAX_PLANT.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)FLUFFY_PLANT.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)MATERIAL_GRADER.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)METAL_ALLOYER.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)METAL_PRESS.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)NETHERWOOD_DOOR.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)NETHERWOOD_SAPLING.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)NETHERWOOD_TRAPDOOR.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)POTTED_NETHERWOOD_SAPLING.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)RECRYSTALLIZER.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)SALVAGER.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)STARLIGHT_CHARGER.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)STONE_TORCH.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)WALL_STONE_TORCH.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)WILD_FLAX_PLANT.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)WILD_FLUFFY_PLANT.get()), (RenderType)RenderType.func_228643_e_());
    }

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        STRIPPED_WOOD.put((Block)NETHERWOOD_LOG.get(), (Block)STRIPPED_NETHERWOOD_LOG.get());
        STRIPPED_WOOD.put((Block)NETHERWOOD_WOOD.get(), (Block)STRIPPED_NETHERWOOD_WOOD.get());
    }

    private static OreBlock getOre(int harvestLevel, SoundType soundType) {
        return new ModOreBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(4.0f, 10.0f).func_235861_h_().harvestLevel(harvestLevel).harvestTool(ToolType.PICKAXE).func_200947_a(soundType));
    }

    private static Block getRawOreBlock(int harvestLevel, SoundType soundType) {
        return new ModOreBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(4.0f, 20.0f).func_235861_h_().harvestLevel(harvestLevel).harvestTool(ToolType.PICKAXE).func_200947_a(soundType));
    }

    private static Block getStorageBlock() {
        return new Block(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(3.0f, 6.0f).func_200947_a(SoundType.field_185852_e));
    }

    private static <T extends Block> BlockRegistryObject<T> registerNoItem(String name, Supplier<T> block) {
        return new BlockRegistryObject(Registration.BLOCKS.register(name, block));
    }

    private static <T extends Block> BlockRegistryObject<T> register(String name, Supplier<T> block) {
        return ModBlocks.register(name, block, ModBlocks::defaultItem);
    }

    private static <T extends Block> BlockRegistryObject<T> register(String name, Supplier<T> block, Function<BlockRegistryObject<T>, Supplier<? extends BlockItem>> item) {
        BlockRegistryObject<T> ret = ModBlocks.registerNoItem(name, block);
        Registration.ITEMS.register(name, item.apply(ret));
        return ret;
    }

    private static BlockRegistryObject<FluffyBlock> registerFluffyBlock(DyeColor color) {
        return ModBlocks.register(color.func_176762_d() + "_fluffy_block", () -> new FluffyBlock(color));
    }

    private static <T extends Block> Supplier<BlockItem> defaultItem(BlockRegistryObject<T> block) {
        return () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(SilentGear.ITEM_GROUP));
    }

    private static Supplier<BlockItem> getStoneTorchItem() {
        return () -> new WallOrFloorItem((Block)STONE_TORCH.get(), (Block)WALL_STONE_TORCH.get(), new Item.Properties().func_200916_a(SilentGear.ITEM_GROUP));
    }

    private static FlowerPotBlock makePottedPlant(Supplier<? extends Block> flower) {
        FlowerPotBlock potted = new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.field_150457_bL.delegate.get(), flower, AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200943_b(0.0f));
        ResourceLocation flowerId = Objects.requireNonNull(flower.get().getRegistryName());
        ((FlowerPotBlock)Blocks.field_150457_bL).addPlant(flowerId, () -> potted);
        return potted;
    }

    private static AbstractBlock.Properties netherWoodProps(float hardnessIn, float resistanceIn) {
        return AbstractBlock.Properties.func_200945_a((Material)Material.field_237214_y_).harvestTool(ToolType.AXE).func_200948_a(hardnessIn, resistanceIn).func_200947_a(SoundType.field_185848_a);
    }
}

