/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.loot.condition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.init.ModLootStuff;
import net.silentchaos512.gear.loot.condition.GearLootCondition;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TraitHelper;

public class HasTraitCondition
extends GearLootCondition {
    public static final Serializer SERIALIZER = new Serializer();
    private final ResourceLocation traitId;
    private final int minLevel;
    private final int maxLevel;

    public HasTraitCondition(ResourceLocation traitId, int minLevel, int maxLevel) {
        this.traitId = traitId;
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
    }

    public boolean test(LootContext context) {
        ItemStack tool = HasTraitCondition.getItemUsed(context);
        if (!GearHelper.isGear(tool)) {
            return false;
        }
        int level = TraitHelper.getTraitLevel(tool, this.traitId);
        return level >= this.minLevel && level <= this.maxLevel;
    }

    public static ILootCondition.IBuilder builder(ResourceLocation traitId) {
        return HasTraitCondition.builder(traitId, 1, Integer.MAX_VALUE);
    }

    public static ILootCondition.IBuilder builder(ResourceLocation traitId, int minLevel) {
        return HasTraitCondition.builder(traitId, minLevel, Integer.MAX_VALUE);
    }

    public static ILootCondition.IBuilder builder(ResourceLocation traitId, int minLevel, int maxLevel) {
        return () -> new HasTraitCondition(traitId, minLevel, maxLevel);
    }

    public LootConditionType func_230419_b_() {
        return ModLootStuff.HAS_TRAIT;
    }

    public static class Serializer
    implements ILootSerializer<HasTraitCondition> {
        public void serialize(JsonObject json, HasTraitCondition value, JsonSerializationContext context) {
            json.addProperty("trait", value.traitId.toString());
        }

        public HasTraitCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            ResourceLocation traitId = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"trait"));
            int minLevel = 1;
            int maxLevel = Integer.MAX_VALUE;
            if (json.has("level")) {
                JsonElement levelJson = json.get("level");
                if (levelJson.isJsonPrimitive()) {
                    minLevel = levelJson.getAsInt();
                } else {
                    minLevel = JSONUtils.func_151208_a((JsonObject)levelJson.getAsJsonObject(), (String)"min", (int)minLevel);
                    maxLevel = JSONUtils.func_151208_a((JsonObject)levelJson.getAsJsonObject(), (String)"max", (int)maxLevel);
                }
            }
            return new HasTraitCondition(traitId, minLevel, maxLevel);
        }
    }
}

