/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.advancements.complete_build_request;

import com.google.gson.JsonObject;
import com.ldtteam.structurize.management.StructureName;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.loot.ConditionArraySerializer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class CompleteBuildRequestCriterionInstance
extends CriterionInstance {
    private String hutName;
    private StructureName structureName;
    private int level = -1;

    public CompleteBuildRequestCriterionInstance() {
        super(new ResourceLocation("minecolonies", "complete_build_request"), EntityPredicate.AndPredicate.field_234582_a_);
    }

    public CompleteBuildRequestCriterionInstance(StructureName structureName) {
        this();
        this.structureName = structureName;
    }

    public CompleteBuildRequestCriterionInstance(String hutName) {
        this();
        this.hutName = hutName;
    }

    public CompleteBuildRequestCriterionInstance(StructureName structureName, int level) {
        this();
        this.structureName = structureName;
        this.level = level;
    }

    public CompleteBuildRequestCriterionInstance(String hutName, int level) {
        this();
        this.hutName = hutName;
        this.level = level;
    }

    public boolean test(StructureName structureName, int level) {
        if (this.hutName != null && this.level != -1) {
            return this.hutName.equalsIgnoreCase(structureName.getHutName()) && this.level <= level;
        }
        if (this.hutName != null) {
            return this.hutName.equalsIgnoreCase(structureName.getHutName());
        }
        if (this.structureName != null && this.level != -1) {
            return this.structureName.equals(structureName) && this.level <= level;
        }
        if (this.structureName != null) {
            return this.structureName.equals(structureName);
        }
        return true;
    }

    @NotNull
    public static CompleteBuildRequestCriterionInstance deserializeFromJson(@NotNull JsonObject jsonObject, @NotNull ConditionArrayParser conditions) {
        if (jsonObject.has("hut_name")) {
            String hutName = JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"hut_name");
            if (jsonObject.has("level")) {
                int level = JSONUtils.func_151203_m((JsonObject)jsonObject, (String)"level");
                return new CompleteBuildRequestCriterionInstance(hutName, level);
            }
            return new CompleteBuildRequestCriterionInstance(hutName);
        }
        if (jsonObject.has("structure_name")) {
            StructureName structureName = new StructureName(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"structure_name"));
            if (jsonObject.has("structure_name")) {
                int level = JSONUtils.func_151203_m((JsonObject)jsonObject, (String)"level");
                return new CompleteBuildRequestCriterionInstance(structureName, level);
            }
            return new CompleteBuildRequestCriterionInstance(structureName);
        }
        return new CompleteBuildRequestCriterionInstance();
    }

    @NotNull
    public JsonObject func_230240_a_(@NotNull ConditionArraySerializer serializer) {
        JsonObject json = super.func_230240_a_(serializer);
        if (this.hutName != null) {
            json.addProperty("hut_name", this.hutName);
        } else if (this.structureName != null) {
            json.addProperty("structure_name", this.structureName.toString());
        }
        if (this.level >= 0) {
            json.addProperty("level", (Number)this.level);
        }
        return json;
    }
}

