/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.requestable;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;

public class Food
implements IDeliverable {
    private static final Set<TypeToken<?>> TYPE_TOKENS = ReflectionUtils.getSuperClasses(TypeToken.of(Food.class)).stream().filter(type -> !type.equals(TypeConstants.OBJECT)).collect(Collectors.toSet());
    private static final String NBT_COUNT = "Count";
    private static final String NBT_RESULT = "Result";
    private static final String NBT_EXCLUSION = "Exclusion";
    private static final String NBT_MIN_NUTRITION = "MinNutrition";
    private final int count;
    private final int minNutrition;
    private final List<ItemStorage> exclusionList = new ArrayList<ItemStorage>();
    @NotNull
    private ItemStack result = ItemStackUtils.EMPTY;

    public Food(int count, int minNutrition) {
        this.count = count;
        this.minNutrition = minNutrition;
    }

    public Food(int count, @NotNull ItemStack result, int minNutrition) {
        this.count = count;
        this.result = result;
        this.minNutrition = minNutrition;
    }

    public Food(int count, @NotNull ItemStack result, List<ItemStorage> exclusionList, int minNutrition) {
        this.count = count;
        this.result = result;
        this.exclusionList.addAll(exclusionList);
        this.minNutrition = minNutrition;
    }

    public Food(int count, List<ItemStorage> exclusionList, int minNutrition) {
        this(count, ItemStackUtils.EMPTY, exclusionList, minNutrition);
    }

    public static CompoundNBT serialize(IFactoryController controller, Food food) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74768_a(NBT_COUNT, food.count);
        if (!ItemStackUtils.isEmpty(food.result).booleanValue()) {
            compound.func_218657_a(NBT_RESULT, (INBT)food.result.serializeNBT());
        }
        if (!food.exclusionList.isEmpty()) {
            @NotNull ListNBT items = new ListNBT();
            for (ItemStorage item : food.exclusionList) {
                @NotNull CompoundNBT itemCompound = new CompoundNBT();
                item.getItemStack().func_77955_b(itemCompound);
                items.add((Object)itemCompound);
            }
            compound.func_218657_a(NBT_EXCLUSION, (INBT)items);
        }
        compound.func_74768_a(NBT_MIN_NUTRITION, food.minNutrition);
        return compound;
    }

    public static Food deserialize(IFactoryController controller, CompoundNBT compound) {
        int count = compound.func_74762_e(NBT_COUNT);
        ItemStack result = compound.func_150296_c().contains(NBT_RESULT) ? ItemStackUtils.deserializeFromNBT(compound.func_74775_l(NBT_RESULT)) : ItemStackUtils.EMPTY;
        ArrayList<ItemStorage> items = new ArrayList<ItemStorage>();
        if (compound.func_74764_b(NBT_EXCLUSION)) {
            ListNBT filterableItems = compound.func_150295_c(NBT_EXCLUSION, 10);
            for (int i = 0; i < filterableItems.size(); ++i) {
                items.add(new ItemStorage(ItemStack.func_199557_a((CompoundNBT)filterableItems.func_150305_b(i))));
            }
        }
        int minNutrition = compound.func_74762_e(NBT_MIN_NUTRITION);
        return new Food(count, result, items, minNutrition);
    }

    public static void serialize(IFactoryController controller, PacketBuffer buffer, Food input) {
        buffer.writeInt(input.count);
        buffer.writeBoolean(ItemStackUtils.isEmpty(input.result) == false);
        if (!ItemStackUtils.isEmpty(input.result).booleanValue()) {
            buffer.func_150788_a(input.result);
        }
        buffer.writeInt(input.exclusionList.size());
        for (ItemStorage item : input.exclusionList) {
            buffer.func_150788_a(item.getItemStack());
        }
        buffer.writeInt(input.minNutrition);
    }

    public static Food deserialize(IFactoryController controller, PacketBuffer buffer) {
        int count = buffer.readInt();
        ItemStack result = buffer.readBoolean() ? buffer.func_150791_c() : ItemStack.field_190927_a;
        ArrayList<ItemStorage> items = new ArrayList<ItemStorage>();
        int itemsCount = buffer.readInt();
        for (int i = 0; i < itemsCount; ++i) {
            items.add(new ItemStorage(buffer.func_150791_c()));
        }
        int minNutrition = buffer.readInt();
        if (!items.isEmpty()) {
            return new Food(count, result, items, minNutrition);
        }
        return new Food(count, result, minNutrition);
    }

    @Override
    public boolean matches(@NotNull ItemStack stack) {
        return !(!ItemStackUtils.ISFOOD.test(stack) || this.exclusionList.contains(new ItemStorage(stack)) || ItemStackUtils.ISCOOKABLE.test(stack) && this.exclusionList.contains(new ItemStorage(MinecoloniesAPIProxy.getInstance().getFurnaceRecipes().getSmeltingResult(stack))) || !ItemStackUtils.ISCOOKABLE.test(stack) && stack.func_77973_b().func_219967_s().func_221466_a() < this.minNutrition);
    }

    @Override
    public void setResult(@NotNull ItemStack result) {
        this.result = result;
    }

    @Override
    public IDeliverable copyWithCount(int newCount) {
        return new Food(newCount, this.exclusionList, this.minNutrition);
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public int getMinimumCount() {
        return 1;
    }

    @Override
    @NotNull
    public ItemStack getResult() {
        return this.result;
    }

    public List<ItemStorage> getExclusionList() {
        return this.exclusionList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Food)) {
            return false;
        }
        Food food = (Food)o;
        if (this.getCount() != food.getCount()) {
            return false;
        }
        return ItemStackUtils.compareItemStacksIgnoreStackSize(this.getResult(), food.getResult());
    }

    public int hashCode() {
        int result1 = this.getCount();
        result1 = 31 * result1 + this.getResult().hashCode();
        return result1;
    }

    @Override
    public Set<TypeToken<?>> getSuperClasses() {
        return TYPE_TOKENS;
    }
}

