/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.tileentities;

import com.ldtteam.structurize.blocks.interfaces.IBlueprintDataProvider;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.tileentities.TileEntityRack;
import com.minecolonies.api.util.InventoryFunctions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTileEntityColonyBuilding
extends TileEntityRack
implements IBlueprintDataProvider {
    private static final String TAG_VERSION = "version";
    private static final int VERSION = 2;
    private BlockPos corner1 = BlockPos.field_177992_a;
    private BlockPos corner2 = BlockPos.field_177992_a;
    private String schematicName = "";
    private Map<BlockPos, List<String>> tagPosMap = new HashMap<BlockPos, List<String>>();
    private int version = 0;

    public AbstractTileEntityColonyBuilding(TileEntityType<? extends AbstractTileEntityColonyBuilding> type) {
        super((TileEntityType<? extends TileEntityRack>)type);
    }

    public static boolean isInTileEntity(ICapabilityProvider entity, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        return InventoryFunctions.matchFirstInProvider(entity, itemStackSelectionPredicate);
    }

    public abstract int getColonyId();

    public abstract IColony getColony();

    public abstract void setColony(IColony var1);

    public abstract BlockPos getPosition();

    @Nullable
    public abstract BlockPos getPositionOfChestWithItemStack(@NotNull Predicate<ItemStack> var1);

    public abstract IBuilding getBuilding();

    public abstract void setBuilding(IBuilding var1);

    public abstract IBuildingView getBuildingView();

    public abstract boolean hasAccessPermission(PlayerEntity var1);

    public abstract void setMirror(boolean var1);

    public abstract boolean isMirrored();

    public abstract String getStyle();

    public abstract void setStyle(String var1);

    public abstract ResourceLocation getBuildingName();

    public String getSchematicName() {
        return this.schematicName;
    }

    public void setSchematicName(String name) {
        this.schematicName = name;
    }

    public Map<BlockPos, List<String>> getPositionedTags() {
        return this.tagPosMap;
    }

    public void setPositionedTags(Map<BlockPos, List<String>> positionedTags) {
        this.tagPosMap = positionedTags;
    }

    public Tuple<BlockPos, BlockPos> getSchematicCorners() {
        return new Tuple((Object)this.corner1, (Object)this.corner2);
    }

    public void setSchematicCorners(BlockPos pos1, BlockPos pos2) {
        this.corner1 = pos1;
        this.corner2 = pos2;
    }

    @Override
    public void func_230337_a_(BlockState state, @NotNull CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.readSchematicDataFromNBT(compound);
        this.version = compound.func_74762_e(TAG_VERSION);
    }

    public void readSchematicDataFromNBT(CompoundNBT originalCompound) {
        String old = this.getSchematicName();
        super.readSchematicDataFromNBT(originalCompound);
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K || this.getColony() == null || this.getColony().getBuildingManager() == null) {
            return;
        }
        IBuilding building = this.getColony().getBuildingManager().getBuilding(this.field_174879_c);
        if (building != null) {
            building.onUpgradeSchematicTo(old, this.getSchematicName(), this);
        }
        this.version = 2;
    }

    @Override
    @NotNull
    public CompoundNBT func_189515_b(@NotNull CompoundNBT compound) {
        super.func_189515_b(compound);
        this.writeSchematicDataToNBT(compound);
        compound.func_74768_a(TAG_VERSION, this.version);
        return compound;
    }

    public BlockPos getTilePos() {
        return this.field_174879_c;
    }

    public boolean isOutdated() {
        return this.version < 2;
    }
}

