/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.views;

import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.server.colony.building.worker.BuildingHiringModeMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public abstract class LivingBuildingView
extends AbstractBuildingView {
    @NotNull
    private final List<Integer> residents = new ArrayList<Integer>();
    private int max;
    private HiringMode hiringMode;

    public LivingBuildingView(IColonyView c, BlockPos l) {
        super(c, l);
    }

    @NotNull
    public List<Integer> getResidents() {
        return Collections.unmodifiableList(this.residents);
    }

    public void removeResident(int index) {
        this.residents.removeIf(v -> v == index);
    }

    public void addResident(int id) {
        this.residents.add(id);
    }

    public void setMax(int max) {
        this.max = max;
    }

    public int getMax() {
        return this.max;
    }

    public HiringMode getHiringMode() {
        return this.hiringMode;
    }

    public void setHiringMode(HiringMode value) {
        this.hiringMode = value;
        Network.getNetwork().sendToServer(new BuildingHiringModeMessage(this, this.hiringMode, null));
    }

    @Override
    public void deserialize(@NotNull PacketBuffer buf) {
        super.deserialize(buf);
        this.residents.clear();
        int numResidents = buf.readInt();
        for (int i = 0; i < numResidents; ++i) {
            this.residents.add(buf.readInt());
        }
        this.hiringMode = HiringMode.values()[buf.readInt()];
        this.max = buf.readInt();
    }
}

