/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.basic;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PublicCrafting;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.RecipeStorage;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.entity.pathfinding.AbstractAdvancedPathNavigate;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.CraftingWorkerBuildingModule;
import com.minecolonies.coremod.colony.jobs.AbstractJobCrafter;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityAICrafting<J extends AbstractJobCrafter<?, J>, B extends AbstractBuilding>
extends AbstractEntityAIInteract<J, B> {
    protected static final int HIT_DELAY = 10;
    public static final int PROGRESS_MULTIPLIER = 10;
    protected static final int MAX_LEVEL = 50;
    private static final int HITTING_TIME = 3;
    public IRequest<? extends PublicCrafting> currentRequest;
    protected IRecipeStorage currentRecipeStorage;
    private DamageSource playerDamageSource;

    protected int getActionRewardForCraftingSuccess() {
        return 1;
    }

    public AbstractEntityAICrafting(@NotNull J job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, () -> AIWorkerState.START_WORKING, 1), new AITarget((IAIState)AIWorkerState.START_WORKING, this::decide, 5), new AITarget((IAIState)AIWorkerState.QUERY_ITEMS, this::queryItems, 5), new AITarget((IAIState)AIWorkerState.GET_RECIPE, this::getRecipe, 5), new AITarget((IAIState)AIWorkerState.CRAFT, this::craft, 10));
        this.worker.func_98053_h(true);
    }

    protected IAIState decide() {
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
        if (((AbstractJobCrafter)this.job).getTaskQueue().isEmpty()) {
            if (this.worker.getNavigation().func_75500_f()) {
                if (this.building.isInBuilding(this.worker.func_233580_cy_())) {
                    this.worker.getNavigation().moveToRandomPos(10, 0.6, this.building.getCorners(), AbstractAdvancedPathNavigate.RestrictionType.XYZ);
                } else {
                    this.walkToBuilding();
                }
            }
            return AIWorkerState.IDLE;
        }
        if (((AbstractJobCrafter)this.job).getCurrentTask() == null) {
            return AIWorkerState.IDLE;
        }
        if (this.walkToBuilding()) {
            return AIWorkerState.START_WORKING;
        }
        if (((AbstractJobCrafter)this.job).getActionsDone() >= this.getActionsDoneUntilDumping()) {
            return this.getState();
        }
        return this.getNextCraftingState();
    }

    protected IAIState getNextCraftingState() {
        if (((AbstractJobCrafter)this.job).getCurrentTask() == null) {
            return this.getState();
        }
        if (this.currentRequest != null && this.currentRecipeStorage != null) {
            return AIWorkerState.QUERY_ITEMS;
        }
        return AIWorkerState.GET_RECIPE;
    }

    protected IAIState getRecipe() {
        IRequest currentTask = ((AbstractJobCrafter)this.job).getCurrentTask();
        if (currentTask == null) {
            return AIWorkerState.START_WORKING;
        }
        ICraftingBuildingModule module = this.building.getCraftingModuleForRecipe(((PublicCrafting)currentTask.getRequest()).getRecipeID());
        if (module == null) {
            ((AbstractJobCrafter)this.job).finishRequest(false);
            this.incrementActionsDone(this.getActionRewardForCraftingSuccess());
            return AIWorkerState.START_WORKING;
        }
        this.currentRecipeStorage = module.getFirstFulfillableRecipe(stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, ((PublicCrafting)currentTask.getRequest()).getStack()), 1, false);
        if (this.currentRecipeStorage == null) {
            ((AbstractJobCrafter)this.job).finishRequest(false);
            this.incrementActionsDone(this.getActionRewardForCraftingSuccess());
            return AIWorkerState.START_WORKING;
        }
        this.currentRequest = currentTask;
        ((AbstractJobCrafter)this.job).setMaxCraftingCount(this.currentRequest.getRequest().getCount());
        int currentCount = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, this.currentRecipeStorage.getPrimaryOutput()));
        int inProgressCount = this.getExtendedCount(this.currentRecipeStorage.getPrimaryOutput());
        int countPerIteration = this.currentRecipeStorage.getPrimaryOutput().func_190916_E();
        int doneOpsCount = currentCount / countPerIteration;
        int progressOpsCount = inProgressCount / countPerIteration;
        int remainingOpsCount = this.currentRequest.getRequest().getCount() - doneOpsCount - progressOpsCount;
        List<ItemStorage> input = this.currentRecipeStorage.getCleanedInput();
        for (ItemStorage inputStorage : input) {
            ItemStack container = inputStorage.getItem().getContainerItem(inputStorage.getItemStack());
            int remaining = !this.currentRecipeStorage.getCraftingToolsAndSecondaryOutputs().isEmpty() && ItemStackUtils.compareItemStackListIgnoreStackSize(this.currentRecipeStorage.getCraftingToolsAndSecondaryOutputs(), inputStorage.getItemStack(), false, true) ? inputStorage.getAmount() : (ItemStackUtils.isEmpty(container) == false && ItemStackUtils.compareItemStacksIgnoreStackSize(inputStorage.getItemStack(), container, false, true) ? inputStorage.getAmount() : inputStorage.getAmount() * remainingOpsCount);
            if (InventoryUtils.getCountFromBuilding((IBuilding)this.building, itemStack -> ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, inputStorage.getItemStack(), false, true)) + InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), itemStack -> ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, inputStorage.getItemStack(), false, true)) + this.getExtendedCount(inputStorage.getItemStack()) >= remaining) continue;
            ((AbstractJobCrafter)this.job).finishRequest(false);
            this.incrementActionsDone(this.getActionRewardForCraftingSuccess());
            return AIWorkerState.START_WORKING;
        }
        ((AbstractJobCrafter)this.job).setCraftCounter(doneOpsCount);
        return AIWorkerState.QUERY_ITEMS;
    }

    protected int getExtendedCount(ItemStack stack) {
        return 0;
    }

    @Override
    public IAIState getStateAfterPickUp() {
        return AIWorkerState.GET_RECIPE;
    }

    private IAIState queryItems() {
        if (this.currentRecipeStorage == null) {
            return AIWorkerState.START_WORKING;
        }
        return this.checkForItems(this.currentRecipeStorage);
    }

    protected IAIState checkForItems(@NotNull IRecipeStorage storage) {
        int inProgressCount = this.getExtendedCount(this.currentRecipeStorage.getPrimaryOutput());
        int countPerIteration = this.currentRecipeStorage.getPrimaryOutput().func_190916_E();
        int progressOpsCount = inProgressCount / Math.max(countPerIteration, 1);
        List<ItemStorage> input = storage.getCleanedInput();
        for (ItemStorage inputStorage : input) {
            Predicate<ItemStack> predicate = stack -> ItemStackUtils.isEmpty(stack) == false && new Stack((ItemStack)stack, false).matches(inputStorage.getItemStack());
            int invCount = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), predicate);
            ItemStack container = inputStorage.getItem().getContainerItem(inputStorage.getItemStack());
            int remaining = !this.currentRecipeStorage.getCraftingToolsAndSecondaryOutputs().isEmpty() && ItemStackUtils.compareItemStackListIgnoreStackSize(this.currentRecipeStorage.getCraftingToolsAndSecondaryOutputs(), inputStorage.getItemStack(), false, true) ? inputStorage.getAmount() : (ItemStackUtils.isEmpty(container) == false && ItemStackUtils.compareItemStacksIgnoreStackSize(inputStorage.getItemStack(), container, false, true) ? inputStorage.getAmount() : inputStorage.getAmount() * Math.max(((AbstractJobCrafter)this.job).getMaxCraftingCount(), 1));
            if (invCount > 0 && invCount + (((AbstractJobCrafter)this.job).getCraftCounter() + progressOpsCount) * inputStorage.getAmount() >= remaining) continue;
            if (InventoryUtils.hasItemInProvider((ICapabilityProvider)this.building, predicate)) {
                this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(predicate, remaining);
                return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
            }
            this.currentRecipeStorage = null;
            this.currentRequest = null;
            return AIWorkerState.GET_RECIPE;
        }
        return AIWorkerState.CRAFT;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected IAIState craft() {
        if (this.currentRecipeStorage == null) return AIWorkerState.START_WORKING;
        if (((AbstractJobCrafter)this.job).getCurrentTask() == null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.currentRequest == null && ((AbstractJobCrafter)this.job).getCurrentTask() != null) {
            return AIWorkerState.GET_RECIPE;
        }
        if (this.walkToBuilding()) {
            return this.getState();
        }
        ((AbstractJobCrafter)this.job).setProgress(((AbstractJobCrafter)this.job).getProgress() + 1);
        this.worker.func_184611_a(Hand.MAIN_HAND, this.currentRecipeStorage.getCleanedInput().get(this.worker.func_70681_au().nextInt(this.currentRecipeStorage.getCleanedInput().size())).getItemStack().func_77946_l());
        this.worker.func_184611_a(Hand.OFF_HAND, this.currentRecipeStorage.getPrimaryOutput().func_77946_l());
        this.worker.getCitizenItemHandler().hitBlockWithToolInHand(this.building.getPosition());
        this.currentRequest = ((AbstractJobCrafter)this.job).getCurrentTask();
        if (this.currentRequest != null && (this.currentRequest.getState() == RequestState.CANCELLED || this.currentRequest.getState() == RequestState.FAILED)) {
            this.currentRequest = null;
            this.incrementActionsDone(this.getActionRewardForCraftingSuccess());
            this.currentRecipeStorage = null;
            return AIWorkerState.START_WORKING;
        }
        if (((AbstractJobCrafter)this.job).getProgress() < this.getRequiredProgressForMakingRawMaterial()) return this.getState();
        IAIState check = this.checkForItems(this.currentRecipeStorage);
        if (check != AIWorkerState.CRAFT) {
            this.currentRequest = null;
            ((AbstractJobCrafter)this.job).finishRequest(false);
            this.incrementActionsDoneAndDecSaturation();
            this.resetValues();
            return AIWorkerState.START_WORKING;
        }
        if (!this.currentRecipeStorage.fullfillRecipe(this.getLootContext(), (List<IItemHandler>)ImmutableList.of((Object)this.worker.getItemHandlerCitizen()))) {
            this.currentRequest = null;
            this.incrementActionsDone(this.getActionRewardForCraftingSuccess());
            ((AbstractJobCrafter)this.job).finishRequest(false);
            this.resetValues();
            return AIWorkerState.START_WORKING;
        }
        this.currentRequest.addDelivery(this.currentRecipeStorage.getPrimaryOutput());
        ((AbstractJobCrafter)this.job).setCraftCounter(((AbstractJobCrafter)this.job).getCraftCounter() + 1);
        if (((AbstractJobCrafter)this.job).getCraftCounter() < ((AbstractJobCrafter)this.job).getMaxCraftingCount()) {
            ((AbstractJobCrafter)this.job).setProgress(0);
            return AIWorkerState.GET_RECIPE;
        }
        this.incrementActionsDone(this.getActionRewardForCraftingSuccess());
        ICraftingBuildingModule module = this.building.getCraftingModuleForRecipe(this.currentRecipeStorage.getToken());
        if (module != null) {
            module.improveRecipe(this.currentRecipeStorage, ((AbstractJobCrafter)this.job).getCraftCounter(), this.worker.getCitizenData());
        }
        this.currentRecipeStorage = null;
        this.resetValues();
        if (!this.inventoryNeedsDump()) return AIWorkerState.START_WORKING;
        if (((AbstractJobCrafter)this.job).getMaxCraftingCount() != 0) return AIWorkerState.START_WORKING;
        if (((AbstractJobCrafter)this.job).getProgress() != 0) return AIWorkerState.START_WORKING;
        if (((AbstractJobCrafter)this.job).getCraftCounter() != 0) return AIWorkerState.START_WORKING;
        if (this.currentRequest == null) return AIWorkerState.START_WORKING;
        this.worker.getCitizenExperienceHandler().addExperience((double)this.currentRequest.getRequest().getCount() / 2.0);
        return AIWorkerState.START_WORKING;
    }

    public void resetValues() {
        ((AbstractJobCrafter)this.job).setMaxCraftingCount(0);
        ((AbstractJobCrafter)this.job).setProgress(0);
        ((AbstractJobCrafter)this.job).setCraftCounter(0);
        this.worker.func_184611_a(Hand.MAIN_HAND, ItemStackUtils.EMPTY);
        this.worker.func_184611_a(Hand.OFF_HAND, ItemStackUtils.EMPTY);
    }

    @Override
    public IAIState afterDump() {
        if (((AbstractJobCrafter)this.job).getMaxCraftingCount() == 0 && ((AbstractJobCrafter)this.job).getProgress() == 0 && ((AbstractJobCrafter)this.job).getCraftCounter() == 0 && this.currentRequest != null) {
            if (this.currentRequest.getState() == RequestState.IN_PROGRESS) {
                ((AbstractJobCrafter)this.job).finishRequest(true);
                this.worker.getCitizenExperienceHandler().addExperience((double)this.currentRequest.getRequest().getCount() / 2.0);
            }
            this.currentRequest = null;
        }
        this.resetValues();
        return super.afterDump();
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 1;
    }

    private int getRequiredProgressForMakingRawMaterial() {
        int jobModifier = this.worker.getCitizenData().getCitizenSkillHandler().getLevel(((CraftingWorkerBuildingModule)this.getModuleForJob()).getCraftSpeedSkill()) / 2;
        return 10 / Math.min(jobModifier + 1, 50) * 3;
    }

    @Override
    public boolean isAfterDumpPickupAllowed() {
        return this.currentRequest == null;
    }

    protected LootContext getLootContext() {
        return this.getLootContext(false);
    }

    protected LootContext getLootContext(boolean includeKiller) {
        if (this.playerDamageSource == null) {
            FakePlayer fp = FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)this.world));
            this.playerDamageSource = DamageSource.func_76365_a((PlayerEntity)fp);
        }
        LootContext.Builder builder = new LootContext.Builder((ServerWorld)this.world).func_216015_a(LootParameters.field_237457_g_, (Object)this.worker.func_213303_ch()).func_216015_a(LootParameters.field_216281_a, (Object)this.worker).func_216015_a(LootParameters.field_216289_i, (Object)this.worker.func_184614_ca()).func_216023_a(this.worker.func_70681_au()).func_186469_a((float)this.getEffectiveSkillLevel(this.getPrimarySkillLevel()));
        if (includeKiller) {
            builder = builder.func_216015_a(LootParameters.field_216283_c, (Object)this.playerDamageSource).func_216015_a(LootParameters.field_216284_d, (Object)this.playerDamageSource.func_76346_g()).func_216015_a(LootParameters.field_216285_e, (Object)this.playerDamageSource.func_76364_f());
        }
        return builder.func_216022_a(RecipeStorage.recipeLootParameters);
    }
}

