/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizen.citizenhandlers;

import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenItemHandler;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.network.messages.client.BlockParticleEffectMessage;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CitizenItemHandler
implements ICitizenItemHandler {
    private final AbstractEntityCitizen citizen;

    public CitizenItemHandler(AbstractEntityCitizen citizen) {
        this.citizen = citizen;
    }

    @Override
    public void tryPickupItemEntity(@NotNull ItemEntity itemEntity) {
        if (!CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)this.citizen).field_72995_K) {
            if (itemEntity.func_174874_s()) {
                return;
            }
            ItemStack itemStack = itemEntity.func_92059_d();
            ItemStack compareStack = itemStack.func_77946_l();
            if (this.citizen.getCitizenJobHandler().getColonyJob() == null || this.citizen.getCitizenJobHandler().getColonyJob().pickupSuccess(compareStack)) {
                int resultingStackSize;
                ItemStack resultStack = InventoryUtils.addItemStackToItemHandlerWithResult((IItemHandler)this.citizen.getInventoryCitizen(), itemStack);
                int n = resultingStackSize = ItemStackUtils.isEmpty(resultStack) != false ? 0 : ItemStackUtils.getSize(resultStack);
                if (ItemStackUtils.isEmpty(resultStack).booleanValue() || ItemStackUtils.getSize(resultStack) != ItemStackUtils.getSize(compareStack)) {
                    CompatibilityUtils.getWorldFromCitizen(this.citizen).func_184133_a(null, this.citizen.func_233580_cy_(), SoundEvents.field_187638_cR, SoundCategory.AMBIENT, 0.2f, (float)((this.citizen.func_70681_au().nextGaussian() * 0.7 + 1.0) * 2.0));
                    this.citizen.func_71001_a((Entity)itemEntity, ItemStackUtils.getSize(itemStack) - resultingStackSize);
                    ItemStack overrulingStack = itemStack.func_77946_l();
                    overrulingStack.func_190920_e(ItemStackUtils.getSize(itemStack) - resultingStackSize);
                    if (this.citizen.getCitizenJobHandler().getColonyJob() != null) {
                        this.citizen.getCitizenJobHandler().getColonyJob().onStackPickUp(overrulingStack);
                    }
                    if (ItemStackUtils.isEmpty(resultStack).booleanValue()) {
                        itemEntity.func_70106_y();
                    }
                }
            } else {
                itemEntity.func_70106_y();
            }
        }
    }

    @Override
    public void removeHeldItem() {
        this.citizen.func_184201_a(EquipmentSlotType.MAINHAND, ItemStackUtils.EMPTY);
    }

    @Override
    public void setHeldItem(Hand hand, int slot) {
        this.citizen.getCitizenData().getInventory().setHeldItem(hand, slot);
        if (hand.equals((Object)Hand.MAIN_HAND)) {
            this.citizen.func_184201_a(EquipmentSlotType.MAINHAND, this.citizen.getCitizenData().getInventory().getStackInSlot(slot));
        } else if (hand.equals((Object)Hand.OFF_HAND)) {
            this.citizen.func_184201_a(EquipmentSlotType.OFFHAND, this.citizen.getCitizenData().getInventory().getStackInSlot(slot));
        }
    }

    @Override
    public void setMainHeldItem(int slot) {
        this.citizen.getCitizenData().getInventory().setHeldItem(Hand.MAIN_HAND, slot);
        this.citizen.func_184201_a(EquipmentSlotType.MAINHAND, this.citizen.getCitizenData().getInventory().getStackInSlot(slot));
    }

    @Override
    public void hitBlockWithToolInHand(@Nullable BlockPos blockPos) {
        if (blockPos == null) {
            return;
        }
        this.hitBlockWithToolInHand(blockPos, false);
    }

    @Override
    public void hitBlockWithToolInHand(@Nullable BlockPos blockPos, boolean breakBlock) {
        if (blockPos == null) {
            return;
        }
        this.citizen.func_70671_ap().func_75650_a((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), 10.0f, (float)this.citizen.func_70646_bf());
        this.citizen.func_184609_a(this.citizen.func_184600_cs());
        BlockState blockState = CompatibilityUtils.getWorldFromCitizen(this.citizen).func_180495_p(blockPos);
        Block block = blockState.func_177230_c();
        if (breakBlock) {
            if (!CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)this.citizen).field_72995_K) {
                Network.getNetwork().sendToPosition(new BlockParticleEffectMessage(blockPos, CompatibilityUtils.getWorldFromCitizen(this.citizen).func_180495_p(blockPos), -1), new PacketDistributor.TargetPoint((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), 16.0, this.citizen.field_70170_p.func_234923_W_()));
            }
            CompatibilityUtils.getWorldFromCitizen(this.citizen).func_184133_a(null, blockPos, block.getSoundType(blockState, (IWorldReader)CompatibilityUtils.getWorldFromCitizen(this.citizen), blockPos, (Entity)this.citizen).func_185845_c(), SoundCategory.BLOCKS, block.getSoundType(blockState, (IWorldReader)CompatibilityUtils.getWorldFromCitizen(this.citizen), blockPos, (Entity)this.citizen).func_185843_a(), block.getSoundType(blockState, (IWorldReader)CompatibilityUtils.getWorldFromCitizen(this.citizen), blockPos, (Entity)this.citizen).func_185847_b());
            WorldUtil.removeBlock((IWorld)CompatibilityUtils.getWorldFromCitizen(this.citizen), blockPos, false);
            this.damageItemInHand(this.citizen.func_184600_cs(), 1);
        } else {
            if (!CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)this.citizen).field_72995_K) {
                BlockPos vector = blockPos.func_177973_b((Vector3i)this.citizen.func_233580_cy_());
                Direction facing = Direction.func_176737_a((float)vector.func_177958_n(), (float)vector.func_177956_o(), (float)vector.func_177952_p()).func_176734_d();
                Network.getNetwork().sendToPosition(new BlockParticleEffectMessage(blockPos, CompatibilityUtils.getWorldFromCitizen(this.citizen).func_180495_p(blockPos), facing.ordinal()), new PacketDistributor.TargetPoint((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), 16.0, this.citizen.field_70170_p.func_234923_W_()));
            }
            CompatibilityUtils.getWorldFromCitizen(this.citizen).func_184133_a(null, blockPos, block.getSoundType(blockState, (IWorldReader)CompatibilityUtils.getWorldFromCitizen(this.citizen), blockPos, (Entity)this.citizen).func_185845_c(), SoundCategory.BLOCKS, block.getSoundType(blockState, (IWorldReader)CompatibilityUtils.getWorldFromCitizen(this.citizen), blockPos, (Entity)this.citizen).func_185843_a(), block.getSoundType(blockState, (IWorldReader)CompatibilityUtils.getWorldFromCitizen(this.citizen), blockPos, (Entity)this.citizen).func_185847_b());
        }
    }

    @Override
    public void damageItemInHand(Hand hand, int damage) {
        ItemStack heldItem = this.citizen.getCitizenData().getInventory().getHeldItem(hand);
        if (heldItem == null || heldItem.func_190926_b()) {
            return;
        }
        if (this.citizen.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.TOOL_DURABILITY) > 0.0 && this.citizen.func_70681_au().nextDouble() > 1.0 / (1.0 + this.citizen.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.TOOL_DURABILITY))) {
            return;
        }
        if (this.citizen.getCitizenData().getInventory().damageInventoryItem(this.citizen.getCitizenData().getInventory().getHeldItemSlot(hand), damage, this.citizen, item -> item.func_213334_d(hand))) {
            if (hand == Hand.MAIN_HAND) {
                this.citizen.func_184201_a(EquipmentSlotType.MAINHAND, ItemStackUtils.EMPTY);
            } else {
                this.citizen.func_184201_a(EquipmentSlotType.OFFHAND, ItemStackUtils.EMPTY);
            }
        }
    }

    @Override
    public void pickupItems() {
        for (ItemEntity item : CompatibilityUtils.getWorldFromCitizen(this.citizen).func_225317_b(ItemEntity.class, new AxisAlignedBB(this.citizen.func_233580_cy_()).func_72321_a(2.0, 1.0, 2.0).func_72321_a(-2.0, -1.0, -2.0))) {
            if (item == null || !item.func_70089_S()) continue;
            this.tryPickupItemEntity(item);
        }
    }

    @Override
    public void breakBlockWithToolInHand(@Nullable BlockPos blockPos) {
        if (blockPos == null) {
            return;
        }
        this.hitBlockWithToolInHand(blockPos, true);
    }

    @Override
    public ItemEntity entityDropItem(@NotNull ItemStack itemstack) {
        return this.citizen.func_70099_a(itemstack, 0.0f);
    }

    @Override
    public void updateArmorDamage(double damage) {
        for (ItemStack stack : this.citizen.func_184193_aE()) {
            if (ItemStackUtils.isEmpty(stack).booleanValue() || !(stack.func_77973_b() instanceof ArmorItem)) continue;
            if (this.citizen.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.ARMOR_DURABILITY) > 0.0 && this.citizen.func_70681_au().nextDouble() > 1.0 / (1.0 + this.citizen.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.ARMOR_DURABILITY))) {
                return;
            }
            int armorDmg = Math.max(1, (int)(damage / 4.0));
            int slot = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith((IItemHandler)this.citizen.getInventoryCitizen(), invStack -> invStack != stack && ItemStackUtils.compareItemStacksIgnoreStackSize(invStack, stack, false, true));
            if (slot != -1 && this.citizen.getInventoryCitizen().damageInventoryItem(slot, armorDmg, this.citizen, entityCitizen -> entityCitizen.func_213334_d(Hand.MAIN_HAND))) {
                stack.func_190920_e(0);
                return;
            }
            stack.func_222118_a(armorDmg, (LivingEntity)this.citizen, i -> i.func_213334_d(Hand.MAIN_HAND));
        }
    }

    @Override
    public double applyMending(double xp) {
        double localXp = xp;
        int toolSlot = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith((IItemHandler)this.citizen.getInventoryCitizen(), stack -> stack.func_77948_v() && EnchantmentHelper.func_82781_a((ItemStack)stack).containsKey(Enchantments.field_185296_A));
        if (toolSlot == -1) {
            return localXp;
        }
        ItemStack tool = this.citizen.getInventoryCitizen().getStackInSlot(toolSlot);
        if (!ItemStackUtils.isEmpty(tool).booleanValue() && tool.func_77951_h()) {
            double dmgHealed = Math.min(localXp / 2.0, (double)tool.func_77952_i());
            localXp -= dmgHealed * 2.0;
            tool.func_196085_b(tool.func_77952_i() - (int)Math.ceil(dmgHealed));
        }
        return localXp;
    }
}

