/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.mobs.aitasks;

import com.minecolonies.api.entity.ICustomAttackSound;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesMob;
import com.minecolonies.api.entity.mobs.RaiderMobUtils;
import com.minecolonies.api.entity.pathfinding.PathResult;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.entity.CustomArrowEntity;
import com.minecolonies.coremod.entity.ai.combat.AttackMoveAI;
import com.minecolonies.coremod.entity.ai.combat.CombatUtils;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;

public class RaiderRangedAI<T extends AbstractEntityMinecoloniesMob>
extends AttackMoveAI<T> {
    private static final int MAX_ATTACK_DELAY = 60;
    private static final int MIN_ATTACK_DELAY = 20;
    private static final double ARROW_PIERCE_DIFFICULTY = 3.0;
    private static final double COMBAT_MOVEMENT_SPEED = 1.1;
    private static final double MAX_ATTACK_DISTANCE = 20.0;
    private static final double PITCH_MULTIPLIER = 0.4;
    private static final double BASE_PITCH = 0.8;
    private static final double PITCH_DIVIDER = 1.0;
    private int flightCounter = 0;

    public RaiderRangedAI(T owner, ITickRateStateMachine<IState> stateMachine) {
        super(owner, stateMachine);
    }

    @Override
    protected boolean isInDistanceForAttack(LivingEntity target) {
        this.flightCounter = EntityUtils.isFlying(target) ? ++this.flightCounter : 0;
        if (this.flightCounter > 5) {
            return true;
        }
        return super.isInAttackDistance(target);
    }

    @Override
    protected void doAttack(LivingEntity target) {
        ((AbstractEntityMinecoloniesMob)this.user).getNavigation().func_75499_g();
        AbstractArrowEntity arrowEntity = CombatUtils.createArrowForShooter(this.user);
        arrowEntity.func_70239_b(((AbstractEntityMinecoloniesMob)this.user).func_110148_a(RaiderMobUtils.MOB_ATTACK_DAMAGE).func_111126_e());
        if (this.flightCounter > 5 && arrowEntity instanceof CustomArrowEntity) {
            ((CustomArrowEntity)arrowEntity).setPlayerArmorPierce();
            arrowEntity.func_70015_d(200);
            arrowEntity.func_70239_b(10.0);
        }
        if (((AbstractEntityMinecoloniesMob)this.user).getDifficulty() > 3.0) {
            arrowEntity.func_213872_b((byte)2);
        }
        CombatUtils.shootArrow(arrowEntity, target, 10.0f);
        ((AbstractEntityMinecoloniesMob)this.user).func_184609_a(Hand.MAIN_HAND);
        SoundEvent attackSound = SoundEvents.field_187866_fi;
        if (arrowEntity instanceof ICustomAttackSound) {
            attackSound = ((ICustomAttackSound)arrowEntity).getAttackSound();
        }
        ((AbstractEntityMinecoloniesMob)this.user).func_184185_a(attackSound, 1.0f, (float)this.getRandomPitch());
    }

    private double getRandomPitch() {
        return 1.0 / (((AbstractEntityMinecoloniesMob)this.user).func_70681_au().nextDouble() * 0.4 + 0.8);
    }

    @Override
    protected double getAttackDistance() {
        return 20.0 * Math.max(((AbstractEntityMinecoloniesMob)this.user).getDifficulty(), 2.0);
    }

    @Override
    protected int getAttackDelay() {
        if (this.flightCounter > 5) {
            return 10;
        }
        return (int)Math.max(20.0, 60.0 - (double)((Integer)MineColonies.getConfig().getServer().barbarianHordeDifficulty.get() * 4) * ((AbstractEntityMinecoloniesMob)this.user).getDifficulty());
    }

    @Override
    protected PathResult moveInAttackPosition(LivingEntity target) {
        return ((AbstractEntityMinecoloniesMob)this.user).getNavigation().moveToXYZ(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), 1.1);
    }

    @Override
    protected boolean isAttackableTarget(LivingEntity target) {
        return target instanceof EntityCitizen || target instanceof PlayerEntity && !((PlayerEntity)target).func_184812_l_() && !target.func_175149_v();
    }

    @Override
    protected boolean isWithinPersecutionDistance(LivingEntity target) {
        return true;
    }
}

