/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client.colony;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.coremod.colony.Colony;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyViewRemoveBuildingMessage
implements IMessage {
    private int colonyId;
    private BlockPos buildingId;

    public ColonyViewRemoveBuildingMessage() {
    }

    public ColonyViewRemoveBuildingMessage(@NotNull Colony colony, BlockPos building) {
        this.colonyId = colony.getID();
        this.buildingId = building;
    }

    @Override
    public void fromBytes(@NotNull PacketBuffer buf) {
        this.colonyId = buf.readInt();
        this.buildingId = buf.func_179259_c();
    }

    @Override
    public void toBytes(@NotNull PacketBuffer buf) {
        buf.writeInt(this.colonyId);
        buf.func_179255_a(this.buildingId);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        if (Minecraft.func_71410_x().field_71441_e != null) {
            IColonyManager.getInstance().handleColonyViewRemoveBuildingMessage(this.colonyId, this.buildingId, (RegistryKey<World>)Minecraft.func_71410_x().field_71441_e.func_234923_W_());
        }
    }
}

