/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server;

import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structurize.util.BlockInfo;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.colony.workorders.WorkOrderType;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.util.LoadOnlyStructureHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.blocks.BlockDecorationController;
import com.minecolonies.coremod.colony.workorders.WorkOrderDecoration;
import com.minecolonies.coremod.tileentities.TileEntityDecorationController;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DecorationBuildRequestMessage
implements IMessage {
    private BlockPos pos;
    private String displayName;
    private String name;
    private int level;
    private RegistryKey<World> dimension;

    public DecorationBuildRequestMessage() {
    }

    public DecorationBuildRequestMessage(@NotNull BlockPos pos, String displayName, String name, int level, RegistryKey<World> dimension) {
        this.pos = pos;
        this.displayName = displayName;
        this.name = name;
        this.level = level;
        this.dimension = dimension;
    }

    @Override
    public void fromBytes(@NotNull PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.displayName = buf.func_150789_c(Short.MAX_VALUE);
        this.name = buf.func_150789_c(Short.MAX_VALUE);
        this.level = buf.readInt();
        this.dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(buf.func_150789_c(Short.MAX_VALUE)));
    }

    @Override
    public void toBytes(@NotNull PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.func_180714_a(this.displayName);
        buf.func_180714_a(this.name);
        buf.writeInt(this.level);
        buf.func_180714_a(this.dimension.func_240901_a_().toString());
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        IColony colony = IColonyManager.getInstance().getColonyByPosFromDim(this.dimension, this.pos);
        if (colony == null) {
            return;
        }
        ServerPlayerEntity player = ctxIn.getSender();
        if (!colony.getPermissions().hasPermission((PlayerEntity)player, Action.MANAGE_HUTS)) {
            return;
        }
        TileEntity entity = player.func_130014_f_().func_175625_s(this.pos);
        if (entity instanceof TileEntityDecorationController) {
            BlockState structureState;
            Optional<Map.Entry> wo = colony.getWorkManager().getWorkOrders().entrySet().stream().filter(entry -> entry.getValue() instanceof WorkOrderDecoration).filter(entry -> ((IWorkOrder)entry.getValue()).getLocation().equals((Object)this.pos)).findFirst();
            if (wo.isPresent()) {
                colony.getWorkManager().removeWorkOrder((Integer)wo.get().getKey());
                return;
            }
            int difference = 0;
            LoadOnlyStructureHandler structure = new LoadOnlyStructureHandler(colony.getWorld(), this.pos, this.name + this.level, new PlacementSettings(), true);
            Blueprint blueprint = structure.getBluePrint();
            if (blueprint != null && (structureState = ((BlockInfo)structure.getBluePrint().getBlockInfoAsMap().get(structure.getBluePrint().getPrimaryBlockOffset())).getState()) != null) {
                int worldRotation;
                if (!(structureState.func_177230_c() instanceof BlockDecorationController)) {
                    Log.getLogger().error(String.format("Schematic %s doesn't have a correct Primary Offset", this.name + this.level));
                    return;
                }
                int structureRotation = ((Direction)structureState.func_177229_b((Property)BlockDecorationController.field_185512_D)).func_176736_b();
                difference = structureRotation <= (worldRotation = ((Direction)colony.getWorld().func_180495_p(this.pos).func_177229_b((Property)BlockDecorationController.field_185512_D)).func_176736_b()) ? worldRotation - structureRotation : 4 + worldRotation - structureRotation;
            }
            BlockState state = player.func_130014_f_().func_180495_p(this.pos);
            int currentLevel = ((TileEntityDecorationController)entity).getTier();
            WorkOrderDecoration order = this.level > currentLevel ? WorkOrderDecoration.create(WorkOrderType.UPGRADE, this.name + this.level, WordUtils.capitalizeFully((String)this.displayName), this.pos, difference, (Boolean)state.func_177229_b((Property)BlockDecorationController.MIRROR), currentLevel) : (this.level == currentLevel ? WorkOrderDecoration.create(WorkOrderType.REPAIR, this.name + this.level, WordUtils.capitalizeFully((String)this.displayName), this.pos, difference, (Boolean)state.func_177229_b((Property)BlockDecorationController.MIRROR), currentLevel) : WorkOrderDecoration.create(WorkOrderType.BUILD, this.name + this.level, WordUtils.capitalizeFully((String)this.displayName), this.pos, difference, (Boolean)state.func_177229_b((Property)BlockDecorationController.MIRROR), currentLevel));
            colony.getWorkManager().addWorkOrder(order, false);
        }
    }
}

