/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.content.core;

import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.content.items.IAgriJournalItem;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGeneCarrierItem;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenePair;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenome;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.config.Config;
import com.infinityraider.agricraft.content.core.BlockSeedAnalyzer;
import com.infinityraider.agricraft.proxy.IProxy;
import com.infinityraider.agricraft.render.blocks.TileEntitySeedAnalyzerSeedRenderer;
import com.infinityraider.infinitylib.block.tile.InfinityTileEntityType;
import com.infinityraider.infinitylib.block.tile.TileEntityBase;
import com.infinityraider.infinitylib.modules.dynamiccamera.IDynamicCameraController;
import com.infinityraider.infinitylib.utility.debug.IDebuggable;
import com.infinityraider.infinitylib.utility.inventory.IInventoryItemHandler;
import com.infinityraider.infinitylib.utility.inventory.ISidedInventoryWrapped;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TileEntitySeedAnalyzer
extends TileEntityBase
implements ISidedInventoryWrapped,
IInventoryItemHandler,
IDynamicCameraController,
IDebuggable {
    public static final int SLOT_SEED = 0;
    public static final int SLOT_JOURNAL = 1;
    private static final int[] SLOTS = new int[]{0, 1};
    private final TileEntityBase.AutoSyncedField<ItemStack> seed = this.getAutoSyncedFieldBuilder(ItemStack.field_190927_a).withCallBack(seed -> TileEntitySeedAnalyzer.addSeedToJournal(seed, this.getJournal()).ifPresent(this::setJournal)).build();
    private final TileEntityBase.AutoSyncedField<ItemStack> journal = this.getAutoSyncedFieldBuilder(ItemStack.field_190927_a).withCallBack(journal -> {
        if (this.func_145831_w() != null) {
            this.func_145831_w().func_175656_a(this.func_174877_v(), BlockSeedAnalyzer.JOURNAL.apply(this.func_195044_w(), (Comparable)Boolean.valueOf(!journal.func_190926_b())));
        }
    }).withRenderUpdate().build();
    private final LazyOptional<TileEntitySeedAnalyzer> capability = LazyOptional.of(() -> this);
    private PlayerEntity observer;
    private Vector3d observerStart;
    private Vector3d observerPosition;
    private Vector2f observerOrientation;
    private List<IAgriGenePair<?>> genesToRender;

    public TileEntitySeedAnalyzer() {
        super(AgriCraft.instance.getModTileRegistry().seed_analyzer);
    }

    public Direction getOrientation() {
        return (Direction)BlockSeedAnalyzer.ORIENTATION.fetch(this.func_195044_w());
    }

    public float getHorizontalAngle() {
        Direction dir = this.getOrientation();
        return dir.func_176740_k() == Direction.Axis.Z ? dir.func_176734_d().func_185119_l() : dir.func_185119_l();
    }

    public boolean isObserved() {
        return this.observer != null;
    }

    public boolean canProvideGenesForObserver() {
        return this.getGenesToRender() != null;
    }

    @Nullable
    public List<IAgriGenePair<?>> getGenesToRender() {
        return this.genesToRender;
    }

    public int getTransitionDuration() {
        return ((Config)AgriCraft.instance.getConfig()).seedAnalyzerAnimationDuration();
    }

    public boolean setObserving(boolean value) {
        if (this.func_145831_w() != null && this.func_145831_w().func_201670_d()) {
            return ((IProxy)AgriCraft.instance.proxy()).toggleDynamicCamera(this, value);
        }
        return false;
    }

    public void onCameraActivated() {
        this.observer = AgriCraft.instance.getClientPlayer();
        this.observerStart = this.observer == null ? null : this.observer.func_213303_ch();
        ((IProxy)AgriCraft.instance.proxy()).toggleSeedAnalyzerActive(true);
    }

    public void onObservationStart() {
        this.genesToRender = this.getSeed().func_77973_b() instanceof IAgriGeneCarrierItem ? ((IAgriGeneCarrierItem)this.getSeed().func_77973_b()).getGenome(this.getSeed()).map(IAgriGenome::getGeneList).orElse(Collections.emptyList()) : Collections.emptyList();
        ((IProxy)AgriCraft.instance.proxy()).toggleSeedAnalyzerObserving(true);
    }

    public void onObservationEnd() {
        this.genesToRender = null;
        ((IProxy)AgriCraft.instance.proxy()).toggleSeedAnalyzerObserving(false);
    }

    public void onCameraDeactivated() {
        this.observerStart = null;
        this.observer = null;
        ((IProxy)AgriCraft.instance.proxy()).toggleSeedAnalyzerActive(false);
    }

    public boolean shouldContinueObserving() {
        return this.observer != null && this.observerStart != null && this.observerStart.equals((Object)this.observer.func_213303_ch());
    }

    public Vector3d getObserverPosition() {
        if (this.observerPosition == null) {
            this.observerPosition = this.calculateObserverPosition(((IProxy)AgriCraft.instance.proxy()).getFieldOfView());
        }
        return this.observerPosition;
    }

    protected Vector3d calculateObserverPosition(double fov) {
        double d = 0.75 * (0.5 / Math.tan(Math.PI * fov / 360.0));
        double dy = d * (double)MathHelper.func_76126_a((float)1.1780972f);
        double dx = d * (double)MathHelper.func_76134_b((float)1.1780972f);
        BlockState state = this.func_195044_w();
        Direction dir = (Direction)BlockSeedAnalyzer.ORIENTATION.fetch(state);
        this.observerPosition = new Vector3d((double)this.func_174877_v().func_177958_n() + 0.5 + (dx + 0.3125) * (double)dir.func_82601_c(), (double)this.func_174877_v().func_177956_o() + 0.6875 + dy, (double)this.func_174877_v().func_177952_p() + 0.5 + (dx + 0.3125) * (double)dir.func_82599_e());
        return this.observerPosition;
    }

    public Vector2f getObserverOrientation() {
        if (this.observerOrientation == null) {
            BlockState state = this.func_195044_w();
            Direction dir = (Direction)BlockSeedAnalyzer.ORIENTATION.fetch(state);
            this.observerOrientation = new Vector2f(67.5f, dir.func_176734_d().func_185119_l());
        }
        return this.observerOrientation;
    }

    public void onFieldOfViewChanged(float fov) {
        this.observerPosition = this.calculateObserverPosition(fov);
    }

    public boolean hasSeed() {
        return !this.getSeed().func_190926_b();
    }

    @Nonnull
    public ItemStack getSeed() {
        return (ItemStack)this.seed.get();
    }

    protected void setSeed(ItemStack seed) {
        this.seed.set((Object)seed);
    }

    public boolean canInsertSeed(ItemStack seed) {
        return this.func_94041_b(0, seed);
    }

    @Nonnull
    public ItemStack insertSeed(ItemStack seed) {
        return this.insertItem(0, seed, false);
    }

    @Nonnull
    public ItemStack extractSeed() {
        return this.func_70304_b(0);
    }

    public boolean hasJournal() {
        return !this.getJournal().func_190926_b();
    }

    protected void setJournal(ItemStack journal) {
        this.journal.set((Object)TileEntitySeedAnalyzer.addSeedToJournal(this.getSeed(), journal).orElse(journal));
    }

    @Nonnull
    public ItemStack getJournal() {
        return (ItemStack)this.journal.get();
    }

    public boolean canInsertJournal(ItemStack journal) {
        return this.func_94041_b(1, journal);
    }

    @Nonnull
    public ItemStack insertJournal(ItemStack journal) {
        return this.insertItem(1, journal, false);
    }

    @Nonnull
    public ItemStack extractJournal() {
        return this.func_70304_b(1);
    }

    protected void writeTileNBT(@Nonnull CompoundNBT tag) {
    }

    protected void readTileNBT(@Nonnull BlockState state, @Nonnull CompoundNBT tag) {
    }

    public int[] func_180463_a(Direction side) {
        return SLOTS;
    }

    public boolean func_180462_a(int index, ItemStack stack, @Nullable Direction direction) {
        if (stack.func_190926_b()) {
            return true;
        }
        switch (index) {
            case 0: {
                if (this.getSeed().func_190926_b()) {
                    return stack.func_77973_b() instanceof IAgriGeneCarrierItem;
                }
                if (ItemStack.func_179545_c((ItemStack)stack, (ItemStack)this.getSeed()) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)this.getSeed())) {
                    return this.getSeed().func_190916_E() + stack.func_190916_E() <= stack.func_77976_d();
                }
                return false;
            }
            case 1: {
                if (this.getJournal().func_190926_b()) {
                    return stack.func_77973_b() instanceof IAgriJournalItem;
                }
                return false;
            }
        }
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        if (stack.func_190926_b()) {
            return false;
        }
        switch (index) {
            case 0: {
                if (this.getSeed().func_190926_b() || this.getSeed().func_190916_E() < stack.func_190916_E()) {
                    return false;
                }
                return ItemStack.func_179545_c((ItemStack)stack, (ItemStack)this.getSeed()) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)this.getSeed());
            }
        }
        return false;
    }

    public int func_70302_i_() {
        return SLOTS.length;
    }

    public boolean func_191420_l() {
        return this.getSeed().func_190926_b() && this.getJournal().func_190926_b();
    }

    public ItemStack func_70301_a(int index) {
        return this.getStackInInvSlot(index);
    }

    public ItemStack getStackInInvSlot(int index) {
        switch (index) {
            case 0: {
                return this.getSeed();
            }
            case 1: {
                return this.getJournal();
            }
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = ItemStack.field_190927_a;
        if (count <= 0) {
            return stack;
        }
        switch (index) {
            case 0: {
                stack = this.getSeed().func_77946_l();
                if (stack.func_190916_E() > count) {
                    stack.func_190920_e(count);
                    ItemStack seed = this.getSeed();
                    seed.func_190920_e(seed.func_190916_E() - count);
                    this.setSeed(seed);
                } else {
                    this.setSeed(ItemStack.field_190927_a);
                }
                return stack;
            }
            case 1: {
                stack = this.getJournal().func_77946_l();
                this.setJournal(ItemStack.field_190927_a);
                return stack;
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = ItemStack.field_190927_a;
        switch (index) {
            case 0: {
                stack = this.getSeed().func_77946_l();
                this.setSeed(ItemStack.field_190927_a);
                return stack;
            }
            case 1: {
                stack = this.getJournal().func_77946_l();
                this.setJournal(ItemStack.field_190927_a);
                return stack;
            }
        }
        return stack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (this.func_94041_b(index, stack)) {
            switch (index) {
                case 0: {
                    this.setSeed(stack);
                    break;
                }
                case 1: {
                    this.setJournal(stack);
                }
            }
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.func_180462_a(index, stack, null);
    }

    public void func_174888_l() {
        this.setSeed(ItemStack.field_190927_a);
        this.setJournal(ItemStack.field_190927_a);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.capability.cast();
        }
        return super.getCapability(capability, facing);
    }

    public static Optional<ItemStack> addSeedToJournal(ItemStack seed, ItemStack journal) {
        IAgriPlant plant;
        IAgriJournalItem journalItem;
        if (!seed.func_190926_b() && !journal.func_190926_b() && seed.func_77973_b() instanceof IAgriGeneCarrierItem && journal.func_77973_b() instanceof IAgriJournalItem && !(journalItem = (IAgriJournalItem)journal.func_77973_b()).isPlantDiscovered(journal, plant = ((IAgriGeneCarrierItem)seed.func_77973_b()).getPlant(seed))) {
            ItemStack newJournal = journal.func_77946_l();
            journalItem.addEntry(newJournal, plant);
            return Optional.of(newJournal);
        }
        return Optional.empty();
    }

    public static RenderFactory createRenderFactory() {
        return new RenderFactory();
    }

    public void addServerDebugInfo(Consumer<String> consumer) {
        this.addDebugInfo(consumer);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addClientDebugInfo(Consumer<String> consumer) {
        this.addDebugInfo(consumer);
    }

    protected void addDebugInfo(Consumer<String> consumer) {
        ItemStack journalStack = this.getJournal();
        if (journalStack.func_190926_b() || !(journalStack.func_77973_b() instanceof IAgriJournalItem)) {
            consumer.accept("No journal present");
        } else {
            IAgriJournalItem journalItem = (IAgriJournalItem)journalStack.func_77973_b();
            consumer.accept("Journal (" + journalItem.getDiscoveredSeeds(journalStack).size() + " plants):");
            for (IAgriPlant plant : journalItem.getDiscoveredSeeds(journalStack)) {
                consumer.accept(" - " + plant.getId());
            }
        }
    }

    private static class RenderFactory
    implements InfinityTileEntityType.IRenderFactory<TileEntitySeedAnalyzer> {
        private RenderFactory() {
        }

        @Nullable
        @OnlyIn(value=Dist.CLIENT)
        public TileEntitySeedAnalyzerSeedRenderer createRenderer() {
            return new TileEntitySeedAnalyzerSeedRenderer();
        }
    }
}

