/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.handler;

import com.google.common.collect.Sets;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.client.IMagnifyingGlassInspector;
import com.infinityraider.agricraft.content.tools.ItemMagnifyingGlass;
import com.infinityraider.agricraft.network.MessageMagnifyingGlassObserving;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class MagnifyingGlassViewHandler {
    private static final MagnifyingGlassViewHandler INSTANCE = new MagnifyingGlassViewHandler();
    private static final int ANIMATION_DURATION = 20;
    private static final double DX = 0.475;
    private static final double DY = -0.3125;
    private static final double DZ = 0.45;
    private static final double GENOME_OFFSET = 0.1;
    private static final float ANGLE = 45.0f;
    private static final Quaternion ROTATION_LEFT;
    private static final Quaternion ROTATION_RIGHT;
    private final Set<IMagnifyingGlassInspector> inspectors = Sets.newIdentityHashSet();
    private IMagnifyingGlassInspector inspector;
    private Target lastTarget;
    private boolean active = false;
    private Hand hand = null;
    private int animationCounter = 0;
    private int animationCounterPrev = 0;

    public static MagnifyingGlassViewHandler getInstance() {
        return INSTANCE;
    }

    private MagnifyingGlassViewHandler() {
    }

    public void registerMagnifyingGlassInspector(IMagnifyingGlassInspector inspector) {
        this.inspectors.add(inspector);
    }

    protected void endInspection() {
        if (this.inspector != null && this.lastTarget != null) {
            this.lastTarget.onInspectionEnd(AgriCraft.instance.getClientWorld(), this.inspector, AgriCraft.instance.getClientPlayer());
        }
        this.inspector = null;
        this.lastTarget = null;
        MessageMagnifyingGlassObserving.sendToServer(this.getPlayer(), false);
    }

    public void toggle(Hand hand) {
        if (this.isHandActive(hand)) {
            this.active = false;
            this.endInspection();
        } else {
            this.hand = hand;
            this.active = true;
        }
    }

    @Nullable
    public Hand getActiveHand() {
        return this.hand;
    }

    public boolean isHandActive(@Nonnull Hand hand) {
        return this.getActiveHand() == hand;
    }

    public boolean isActive() {
        return this.active;
    }

    protected PlayerEntity getPlayer() {
        return AgriCraft.instance.getClientPlayer();
    }

    public boolean isAnimationComplete() {
        return this.isAnimationComplete(0.0f);
    }

    protected boolean isAnimationComplete(float partialTicks) {
        return this.isActive() ? (double)this.getAnimationProgress(partialTicks) == 1.0 : this.getAnimationProgress(partialTicks) == 0.0f;
    }

    protected float getAnimationProgress(float partialTick) {
        return MathHelper.func_219799_g((float)partialTick, (float)this.animationCounterPrev, (float)this.animationCounter) / 20.0f;
    }

    protected void manipulateMatrixStackLeft(MatrixStack stack, float partialTick) {
        if (this.isAnimationComplete(partialTick)) {
            stack.func_227861_a_(0.475, -0.3125, 0.45);
            stack.func_227863_a_(ROTATION_LEFT);
        } else {
            float f = this.getAnimationProgress(partialTick);
            stack.func_227861_a_((double)f * 0.475, (double)f * -0.3125, (double)f * 0.45);
            stack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-f * 45.0f));
        }
    }

    protected void manipulateMatrixStackRight(MatrixStack stack, float partialTick) {
        if (this.isAnimationComplete(partialTick)) {
            stack.func_227861_a_(-0.475, -0.3125, 0.45);
            stack.func_227863_a_(ROTATION_RIGHT);
        } else {
            float f = this.getAnimationProgress(partialTick);
            stack.func_227861_a_((double)(-f) * 0.475, (double)f * -0.3125, (double)f * 0.45);
            stack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f * 45.0f));
        }
    }

    protected void checkInspectedPosition() {
        RayTraceResult hit = Minecraft.func_71410_x().field_71476_x;
        Target target = Target.getTarget(hit);
        if (target == null) {
            this.endInspection();
            return;
        }
        if (target.isNewTarget(this.lastTarget)) {
            this.endInspection();
            MessageMagnifyingGlassObserving.sendToServer(this.getPlayer(), true);
            World world = AgriCraft.instance.getClientWorld();
            PlayerEntity player = AgriCraft.instance.getClientPlayer();
            this.inspectors.stream().filter(inspector -> target.canInspect(world, (IMagnifyingGlassInspector)inspector, player)).findAny().ifPresent(inspector -> {
                this.lastTarget = target;
                this.inspector = inspector;
                this.lastTarget.onInspectionStart(world, (IMagnifyingGlassInspector)inspector, player);
            });
        }
    }

    @SubscribeEvent
    public void onRenderHand(RenderHandEvent event) {
        if (!(this.getPlayer().func_184586_b(event.getHand()).func_77973_b() instanceof ItemMagnifyingGlass)) {
            return;
        }
        if (this.isHandActive(event.getHand())) {
            HandSide main = Minecraft.func_71410_x().field_71474_y.field_186715_A;
            if (event.getHand() == Hand.MAIN_HAND) {
                if (main == HandSide.RIGHT) {
                    this.manipulateMatrixStackRight(event.getMatrixStack(), event.getPartialTicks());
                } else {
                    this.manipulateMatrixStackLeft(event.getMatrixStack(), event.getPartialTicks());
                }
            } else if (main == HandSide.LEFT) {
                this.manipulateMatrixStackRight(event.getMatrixStack(), event.getPartialTicks());
            } else {
                this.manipulateMatrixStackLeft(event.getMatrixStack(), event.getPartialTicks());
            }
        }
    }

    @SubscribeEvent
    public void inspectionRender(RenderWorldLastEvent event) {
        if (!Minecraft.func_71410_x().field_71474_y.func_243230_g().func_243192_a()) {
            return;
        }
        IMagnifyingGlassInspector inspector = this.inspector;
        if (inspector == null) {
            return;
        }
        Target target = this.lastTarget;
        if (target == null) {
            return;
        }
        MatrixStack transforms = event.getMatrixStack();
        transforms.func_227860_a_();
        Vector3d projectedView = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        transforms.func_227861_a_(-projectedView.field_72450_a, -projectedView.field_72448_b, -projectedView.field_72449_c);
        Vector3d eyes = this.getPlayer().func_174824_e(event.getPartialTicks());
        transforms.func_227861_a_(eyes.func_82615_a(), eyes.func_82617_b(), eyes.func_82616_c());
        Vector3d hit = target.getTargetVector(event.getPartialTicks());
        Vector3d view = hit.func_178788_d(eyes).func_72432_b();
        transforms.func_227861_a_(0.1 * view.func_82615_a(), 0.1 * view.func_82617_b(), 0.1 * view.func_82616_c());
        float yaw = (float)(Math.PI * (double)this.getPlayer().func_195046_g(event.getPartialTicks())) / 180.0f;
        float pitch = (float)(Math.PI * (double)this.getPlayer().func_195050_f(event.getPartialTicks())) / 180.0f;
        transforms.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(-yaw));
        transforms.func_227860_a_();
        inspector.doInspectionRender(transforms, event.getPartialTicks(), target.getTargetEntity());
        transforms.func_227865_b_();
        transforms.func_227865_b_();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerRender(RenderPlayerEvent.Pre event) {
        if (this.isActive()) {
            PlayerRenderer renderer = event.getRenderer();
            PlayerModel model = (PlayerModel)renderer.func_217764_d();
            Hand hand = this.getActiveHand();
            HandSide side = Minecraft.func_71410_x().field_71474_y.field_186715_A;
            if (hand == Hand.MAIN_HAND && side == HandSide.RIGHT || hand == Hand.OFF_HAND && side == HandSide.LEFT) {
                model.field_187076_m = BipedModel.ArmPose.BLOCK;
                model.field_187075_l = BipedModel.ArmPose.EMPTY;
            } else if (hand == Hand.MAIN_HAND && side == HandSide.LEFT || hand == Hand.OFF_HAND && side == HandSide.RIGHT) {
                model.field_187075_l = BipedModel.ArmPose.BLOCK;
                model.field_187076_m = BipedModel.ArmPose.EMPTY;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        this.animationCounterPrev = this.animationCounter;
        if (this.isActive()) {
            if (this.getActiveHand() == null || !(this.getPlayer().func_184586_b(this.getActiveHand()).func_77973_b() instanceof ItemMagnifyingGlass)) {
                this.active = false;
                this.endInspection();
                return;
            }
            this.animationCounter = this.animationCounter < 20 ? ++this.animationCounter : 20;
            if (this.isAnimationComplete()) {
                PlayerEntity player;
                World world;
                this.checkInspectedPosition();
                if (this.inspector != null && this.lastTarget != null && !this.lastTarget.onInspectionTick(world = AgriCraft.instance.getClientWorld(), this.inspector, player = AgriCraft.instance.getClientPlayer())) {
                    this.endInspection();
                }
            }
        } else if (this.animationCounter > 0) {
            --this.animationCounter;
        } else {
            this.animationCounter = 0;
            this.hand = null;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onMouseScroll(InputEvent.MouseScrollEvent event) {
        if (this.isActive() && this.isAnimationComplete()) {
            if (this.inspector != null) {
                this.inspector.onMouseScroll((int)event.getScrollDelta());
            }
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onMouseClick(InputEvent.ClickInputEvent event) {
        if (this.isActive() && event.getKeyBinding() == Minecraft.func_71410_x().field_71474_y.field_74312_F) {
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onMovementInput(InputUpdateEvent event) {
        if (this.isActive()) {
            event.getMovementInput().field_78902_a = 0.0f;
            event.getMovementInput().field_192832_b = 0.0f;
            event.getMovementInput().field_187255_c = false;
            event.getMovementInput().field_187256_d = false;
            event.getMovementInput().field_187257_e = false;
            event.getMovementInput().field_187258_f = false;
            event.getMovementInput().field_78901_c = false;
            event.getMovementInput().field_228350_h_ = true;
        }
    }

    static {
        ROTATION_RIGHT = Vector3f.field_229183_f_.func_229187_a_(45.0f);
        ROTATION_LEFT = Vector3f.field_229183_f_.func_229187_a_(-45.0f);
    }

    private static abstract class Target {
        private Target() {
        }

        @Nullable
        public static Target getTarget(RayTraceResult hit) {
            if (hit == null) {
                return null;
            }
            if (hit.func_216346_c() == RayTraceResult.Type.MISS) {
                return null;
            }
            if (hit instanceof EntityRayTraceResult) {
                return new EntityTarget(((EntityRayTraceResult)hit).func_216348_a());
            }
            if (hit instanceof BlockRayTraceResult) {
                return new BlockTarget(((BlockRayTraceResult)hit).func_216350_a());
            }
            return null;
        }

        public abstract boolean isNewTarget(@Nullable Target var1);

        public abstract boolean canInspect(World var1, IMagnifyingGlassInspector var2, PlayerEntity var3);

        public abstract void onInspectionStart(World var1, IMagnifyingGlassInspector var2, PlayerEntity var3);

        public abstract boolean onInspectionTick(World var1, IMagnifyingGlassInspector var2, PlayerEntity var3);

        public abstract void onInspectionEnd(World var1, IMagnifyingGlassInspector var2, PlayerEntity var3);

        public abstract Vector3d getTargetVector(float var1);

        @Nullable
        public abstract Entity getTargetEntity();

        private static class BlockTarget
        extends Target {
            private final BlockPos target;

            private BlockTarget(BlockPos pos) {
                this.target = pos;
            }

            @Override
            public boolean isNewTarget(@Nullable Target other) {
                if (other == this) {
                    return false;
                }
                if (other instanceof BlockTarget) {
                    return !this.target.equals((Object)((BlockTarget)other).target);
                }
                return true;
            }

            @Override
            public boolean canInspect(World world, IMagnifyingGlassInspector inspector, PlayerEntity player) {
                return inspector.canInspect(world, this.target, player);
            }

            @Override
            public void onInspectionStart(World world, IMagnifyingGlassInspector inspector, PlayerEntity player) {
                inspector.onInspectionStart(world, this.target, player);
            }

            @Override
            public boolean onInspectionTick(World world, IMagnifyingGlassInspector inspector, PlayerEntity player) {
                return inspector.onInspectionTick(world, this.target, player);
            }

            @Override
            public void onInspectionEnd(World world, IMagnifyingGlassInspector inspector, PlayerEntity player) {
                inspector.onInspectionEnd(world, this.target, player);
            }

            @Override
            public Vector3d getTargetVector(float partialTicks) {
                return new Vector3d((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5);
            }

            @Override
            @Nullable
            public Entity getTargetEntity() {
                return null;
            }
        }

        private static class EntityTarget
        extends Target {
            private final Entity target;

            private EntityTarget(Entity entity) {
                this.target = entity;
            }

            @Override
            public boolean isNewTarget(@Nullable Target other) {
                if (other == this) {
                    return false;
                }
                if (other instanceof EntityTarget) {
                    return this.target != ((EntityTarget)other).target;
                }
                return true;
            }

            @Override
            public boolean canInspect(World world, IMagnifyingGlassInspector inspector, PlayerEntity player) {
                return this.target != null && inspector.canInspect(world, this.target, player);
            }

            @Override
            public void onInspectionStart(World world, IMagnifyingGlassInspector inspector, PlayerEntity player) {
                inspector.onInspectionStart(world, this.target, player);
            }

            @Override
            public boolean onInspectionTick(World world, IMagnifyingGlassInspector inspector, PlayerEntity player) {
                return this.target != null && inspector.onInspectionTick(world, this.target, player);
            }

            @Override
            public void onInspectionEnd(World world, IMagnifyingGlassInspector inspector, PlayerEntity player) {
                inspector.onInspectionEnd(world, this.target, player);
            }

            @Override
            public Vector3d getTargetVector(float partialTicks) {
                double dw = this.target.func_213311_cf() / 2.0f;
                double dh = this.target.func_213302_cg() / 2.0f;
                return new Vector3d(MathHelper.func_219803_d((double)partialTicks, (double)this.target.field_70169_q, (double)this.target.func_226277_ct_()) + dw, MathHelper.func_219803_d((double)partialTicks, (double)this.target.field_70167_r, (double)this.target.func_226278_cu_()) + dh, MathHelper.func_219803_d((double)partialTicks, (double)this.target.field_70166_s, (double)this.target.func_226281_cx_()) + dw);
            }

            @Override
            @Nullable
            public Entity getTargetEntity() {
                return this.target;
            }
        }
    }
}

