/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.plugins.minecraft;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.event.AgriCropEvent;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGene;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenePair;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenome;
import com.infinityraider.agricraft.api.v1.genetics.IAllele;
import com.infinityraider.agricraft.api.v1.genetics.IMutator;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.capability.CapabilityEatCropGoal;
import com.infinityraider.agricraft.impl.v1.genetics.AgriGenePair;
import com.infinityraider.agricraft.proxy.IProxy;
import com.infinityraider.infinitylib.utility.EntityHelper;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class GeneAnimalAttractant
implements IAgriGene<Boolean> {
    private static final int RANGE = 5;
    private static final int COOLDOWN = 1200;
    private static final double SPEED = 1.0;
    private static final int PRIORITY = 4;
    private final String id;
    private final Class<? extends MobEntity> clazz;
    private final List<String> defaultPlantIds;
    private final IAllele<Boolean> alleleTrue;
    private final IAllele<Boolean> alleleFalse;
    private final Set<IAllele<Boolean>> alleles;
    private final TranslationTextComponent geneDescription;
    private final TranslationTextComponent genePairDescription;
    private final Vector3f colorDom;
    private final Vector3f colorRec;

    public GeneAnimalAttractant(String id, Class<? extends MobEntity> clazz, List<String> defaultPlantIds, Vector3f colorDom, Vector3f colorRec) {
        this.id = id;
        this.clazz = clazz;
        this.defaultPlantIds = defaultPlantIds;
        this.alleleTrue = new Allele(this, true);
        this.alleleFalse = new Allele(this, false);
        this.alleles = ImmutableSet.of(this.alleleTrue, this.alleleFalse);
        this.geneDescription = new TranslationTextComponent(AgriCraft.instance.getModId() + ".gene.animal_attractant." + this.getId());
        this.genePairDescription = new TranslationTextComponent(AgriCraft.instance.getModId() + ".tooltip.gene.animal_attractant." + this.getId());
        this.colorDom = colorDom;
        this.colorRec = colorRec;
        ((IProxy)AgriCraft.instance.proxy()).registerEventHandler(this);
    }

    @Override
    @Nonnull
    public String getId() {
        return this.id;
    }

    public boolean isDefaultPlant(IAgriPlant plant) {
        return this.defaultPlantIds.contains(plant.getId());
    }

    @Override
    @Nonnull
    public IAllele<Boolean> defaultAllele(IAgriPlant plant) {
        return this.getAllele(false);
    }

    @Override
    @Nonnull
    public IAllele<Boolean> getAllele(Boolean value) {
        return value != false ? this.alleleTrue : this.alleleFalse;
    }

    @Override
    @Nonnull
    public IAllele<Boolean> readAlleleFromNBT(@Nonnull CompoundNBT tag) {
        return this.getAllele(tag.func_74764_b("agri_key") && tag.func_74767_n("agri_key"));
    }

    @Override
    @Nonnull
    public Set<IAllele<Boolean>> allAlleles() {
        return this.alleles;
    }

    @Override
    @Nonnull
    public IMutator<Boolean> mutator() {
        return Mutator.INSTANCE;
    }

    @Override
    @Nonnull
    public IAgriGenePair<Boolean> generateGenePair(IAllele<Boolean> first, IAllele<Boolean> second) {
        return new GenePair(this, first, second);
    }

    @Override
    @Nonnull
    public IFormattableTextComponent getGeneDescription() {
        return this.geneDescription;
    }

    @Nonnull
    public IFormattableTextComponent getGenePairDescription() {
        return this.genePairDescription;
    }

    @Override
    @Nonnull
    public Vector3f getDominantColor() {
        return this.colorDom;
    }

    @Override
    @Nonnull
    public Vector3f getRecessiveColor() {
        return this.colorRec;
    }

    @Override
    public int getComparatorWeight() {
        return 1;
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @SubscribeEvent
    public void onEntitySpawned(EntityJoinWorldEvent event) {
        EatCropGoal goal;
        MobEntity entity;
        if (!event.getWorld().func_201670_d() && this.clazz.isInstance(event.getEntity()) && EntityHelper.injectGoal((MobEntity)(entity = this.clazz.cast(event.getEntity())), (Goal)(goal = new EatCropGoal(this, entity, 1.0, 1200, this.defaultPlantIds)), (int)4)) {
            CapabilityEatCropGoal.getInstance().setCropEatGoal(entity, goal);
        }
    }

    @SubscribeEvent
    public void onCropGrowthTick(AgriCropEvent.Grow.General.Post event) {
        if (event.getCrop().world() != null && event.getCrop().hasPlant() && event.getCrop().isMature()) {
            BlockPos min = event.getCrop().getPosition().func_177982_a(-5, -5, -5);
            BlockPos max = event.getCrop().getPosition().func_177982_a(5, 5, 5);
            AxisAlignedBB range = new AxisAlignedBB(min, max);
            event.getCrop().world().func_175647_a(this.clazz, range, entity -> true).stream().map(entity -> CapabilityEatCropGoal.getInstance().getCropEatGoal((MobEntity)entity)).filter(Objects::nonNull).filter(goal -> goal.isSuitableTarget(event.getCrop())).forEach(goal -> goal.addPotentialTarget(event.getCrop()));
        }
    }

    public static class EatCropGoal
    extends Goal {
        private static final double DIST_SQ = 1.5625;
        private final GeneAnimalAttractant gene;
        private final MobEntity entity;
        private final double speed;
        private final int cooldown;
        private final List<String> plantIds;
        private final Set<IAgriCrop> potentialTargets;
        private IAgriCrop target;
        private double targetX;
        private double targetY;
        private double targetZ;
        private int cooldownCounter;

        private EatCropGoal(GeneAnimalAttractant gene, MobEntity entity, double speed, int cooldown, List<String> plantIds) {
            this.gene = gene;
            this.entity = entity;
            this.speed = speed;
            this.cooldown = cooldown;
            this.plantIds = plantIds;
            this.potentialTargets = Sets.newIdentityHashSet();
        }

        protected GeneAnimalAttractant getGene() {
            return this.gene;
        }

        protected MobEntity getEntity() {
            return this.entity;
        }

        @Nullable
        protected IAgriCrop getTarget() {
            return this.target;
        }

        public boolean func_75250_a() {
            if (this.cooldownCounter > 0) {
                --this.cooldownCounter;
                return false;
            }
            this.target = this.findSuitableTarget();
            if (this.getTarget() == null) {
                return false;
            }
            this.potentialTargets.remove(this.target);
            return true;
        }

        public boolean func_75253_b() {
            return this.isSuitableTarget(this.getTarget());
        }

        public void func_75249_e() {
            if (this.getTarget() != null) {
                this.targetX = (double)this.getTarget().getPosition().func_177958_n() + 0.5;
                this.targetY = (double)this.getTarget().getPosition().func_177956_o() + 0.5;
                this.targetZ = (double)this.getTarget().getPosition().func_177952_p() + 0.5;
            }
        }

        public void func_75251_c() {
            this.target = null;
            this.getEntity().func_70661_as().func_75499_g();
            this.setCooldown();
        }

        public void func_75246_d() {
            if (this.getTarget() == null) {
                this.func_75251_c();
                return;
            }
            this.getEntity().func_70671_ap().func_75650_a(this.targetX, this.targetY, this.targetZ, (float)(this.getEntity().func_184649_cE() + 20), (float)this.getEntity().func_70646_bf());
            double distSq = this.getEntity().func_70092_e(this.targetX, this.targetY, this.targetZ);
            double criterion = Math.max(1.5625, (double)(this.getEntity().func_213311_cf() * this.getEntity().func_213311_cf()));
            if (distSq <= criterion) {
                this.getEntity().func_70661_as().func_75499_g();
                this.target.setGrowthStage(this.getTarget().getPlant().getInitialGrowthStage());
                if (this.getEntity() instanceof AnimalEntity) {
                    ((AnimalEntity)this.getEntity()).func_204700_e(100);
                }
                this.func_75251_c();
            } else {
                this.getEntity().func_70661_as().func_75492_a(this.targetX, this.targetY, this.targetZ, this.speed);
            }
        }

        protected void setCooldown() {
            this.cooldownCounter = this.cooldown;
        }

        @Nullable
        protected IAgriCrop findSuitableTarget() {
            this.potentialTargets.removeIf(crop -> !this.isSuitableTarget((IAgriCrop)crop));
            return this.potentialTargets.stream().min((a, b) -> {
                double dA = 100.0 * this.getEntity().func_70092_e((double)a.getPosition().func_177958_n() + 0.5, (double)a.getPosition().func_177956_o() + 0.5, (double)a.getPosition().func_177952_p() + 0.5);
                double dB = 100.0 * this.getEntity().func_70092_e((double)b.getPosition().func_177958_n() + 0.5, (double)b.getPosition().func_177956_o() + 0.5, (double)b.getPosition().func_177952_p() + 0.5);
                return (int)(dA - dB);
            }).orElse(null);
        }

        protected boolean isSuitableTarget(IAgriCrop crop) {
            return crop != null && crop.isValid() && crop.hasPlant() && crop.isMature() && this.isSuitablePlant(crop.getPlant()) && crop.getGenome().map(this::hasSuitableGene).orElse(false) != false;
        }

        protected boolean isSuitablePlant(IAgriPlant plant) {
            return plant.isPlant() && this.plantIds.contains(plant.getId());
        }

        protected boolean hasSuitableGene(IAgriGenome genome) {
            return genome.getGenePair(this.getGene()).getTrait();
        }

        public void addPotentialTarget(IAgriCrop crop) {
            this.potentialTargets.add(crop);
        }
    }

    private static class Mutator
    implements IMutator<Boolean> {
        private static final Mutator INSTANCE = new Mutator();
        private static final double BASE_PROBABILITY = 0.5;

        private Mutator() {
        }

        @Override
        public IAgriGenePair<Boolean> pickOrMutate(IAgriGene<Boolean> gene, IAllele<Boolean> first, IAllele<Boolean> second, Tuple<IAgriGenome, IAgriGenome> parents, Random random) {
            return gene.generateGenePair(this.mutateAllele(gene, first, (IAgriGenome)parents.func_76341_a(), random), this.mutateAllele(gene, second, (IAgriGenome)parents.func_76340_b(), random));
        }

        protected IAllele<Boolean> mutateAllele(IAgriGene<Boolean> gene, IAllele<Boolean> allele, IAgriGenome genome, Random random) {
            if (gene instanceof GeneAnimalAttractant && ((GeneAnimalAttractant)gene).isDefaultPlant(genome.getPlant())) {
                if (allele.trait().booleanValue()) {
                    return allele;
                }
                double probability = 0.5 + this.mutationChance(genome);
                double roll = random.nextDouble();
                if (roll < probability) {
                    return gene.getAllele(true);
                }
                return allele;
            }
            if (allele.trait().booleanValue()) {
                double probability = this.mutationChance(genome);
                double roll = random.nextDouble();
                if (roll < probability) {
                    return allele;
                }
                return gene.getAllele(false);
            }
            return allele;
        }

        protected double mutationChance(IAgriGenome genome) {
            int mutativity = genome.getStats().getMutativity();
            int max = AgriApi.getStatRegistry().mutativityStat().getMax();
            return 0.5 * ((double)mutativity + 0.0) / ((double)max + 0.0);
        }
    }

    private static class GenePair
    extends AgriGenePair<Boolean> {
        public GenePair(GeneAnimalAttractant gene, IAllele<Boolean> first, IAllele<Boolean> second) {
            super(gene, first, second);
        }

        public final GeneAnimalAttractant getGene() {
            return (GeneAnimalAttractant)super.getGene();
        }

        @Override
        public void addTooltipDescription(Consumer<ITextComponent> consumer) {
            if (((Boolean)this.getTrait()).booleanValue()) {
                consumer.accept((ITextComponent)this.getGene().getGenePairDescription());
            }
        }
    }

    private static class Allele
    implements IAllele<Boolean> {
        private final IAgriGene<Boolean> gene;
        private final boolean trait;

        public Allele(IAgriGene<Boolean> gene, boolean trait) {
            this.gene = gene;
            this.trait = trait;
        }

        @Override
        public IAgriGene<Boolean> gene() {
            return this.gene;
        }

        @Override
        public Boolean trait() {
            return this.trait;
        }

        @Override
        public boolean isDominant(IAllele<Boolean> other) {
            return this.trait() == false;
        }

        @Override
        public IFormattableTextComponent getTooltip() {
            return null;
        }

        @Override
        public int comparatorValue() {
            return this.trait() != false ? 1 : 0;
        }

        @Override
        @Nonnull
        public CompoundNBT writeToNBT() {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74757_a("agri_key", this.trait().booleanValue());
            return tag;
        }
    }
}

