/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.plugins.minecraft;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.plant.IJsonPlantCallback;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class JsonPlantCallBackExperience
implements IJsonPlantCallback {
    public static final int XP = 4;
    public static final String ID = AgriCraft.instance.getModId() + ":experience";
    private static final IJsonPlantCallback INSTANCE = new JsonPlantCallBackExperience();
    private static final IJsonPlantCallback.Factory FACTORY = new IJsonPlantCallback.Factory(){

        @Override
        public String getId() {
            return ID;
        }

        @Override
        public IJsonPlantCallback makeCallBack(JsonElement json) throws JsonParseException {
            return INSTANCE;
        }
    };

    public static IJsonPlantCallback.Factory getFactory() {
        return FACTORY;
    }

    private JsonPlantCallBackExperience() {
    }

    @Override
    public void onHarvest(@Nonnull IAgriCrop crop, @Nullable LivingEntity entity) {
        World world = crop.world();
        if (world != null && !world.func_201670_d()) {
            for (int i = 0; i < crop.getStats().getGain(); ++i) {
                if (i != 0 && !(world.func_201674_k().nextDouble() < 0.5)) continue;
                this.spawnExperience(world, crop.getPosition());
            }
        }
    }

    protected void spawnExperience(World world, BlockPos pos) {
        world.func_217376_c((Entity)new ExperienceOrbEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 4));
    }
}

