/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.plugins.minecraft;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.plant.IJsonPlantCallback;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SaplingBlock;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;

public class JsonPlantCallBackTree
implements IJsonPlantCallback {
    public static final String ID = AgriCraft.instance.getModId() + ":tree";
    private static final String SAPLING = "sapling";
    private static final IJsonPlantCallback.Factory FACTORY = new IJsonPlantCallback.Factory(){

        @Override
        public String getId() {
            return ID;
        }

        @Override
        public IJsonPlantCallback makeCallBack(JsonElement json) throws JsonParseException {
            if (json instanceof JsonObject) {
                JsonObject obj = json.getAsJsonObject();
                if (obj.has(JsonPlantCallBackTree.SAPLING)) {
                    Block sapling = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(obj.get(JsonPlantCallBackTree.SAPLING).getAsString()));
                    if (sapling instanceof IGrowable) {
                        return new JsonPlantCallBackTree((IGrowable)sapling);
                    }
                    throw new JsonParseException("Invalid sapling id.");
                }
                throw new JsonParseException("Json object does not contain a \"sapling\" field.");
            }
            throw new JsonParseException("Not a json object.");
        }
    };
    private final IGrowable growable;

    public static IJsonPlantCallback.Factory getFactory() {
        return FACTORY;
    }

    private JsonPlantCallBackTree(IGrowable growable) {
        this.growable = growable;
    }

    @Override
    public Optional<ActionResultType> onRightClickPre(@Nonnull IAgriCrop crop, @Nonnull ItemStack stack, @Nullable Entity entity) {
        World world = crop.world();
        if (stack.func_190926_b()) {
            return Optional.empty();
        }
        if (stack.func_77973_b() != Items.field_196106_bc) {
            return Optional.empty();
        }
        if (world == null) {
            return Optional.empty();
        }
        if (!crop.isMature()) {
            return Optional.empty();
        }
        if (!this.growable.func_176473_a((IBlockReader)world, crop.getPosition(), crop.getBlockState(), world.func_201670_d())) {
            return Optional.empty();
        }
        if (!this.growable.func_180670_a(world, world.func_201674_k(), crop.getPosition(), crop.getBlockState())) {
            return Optional.empty();
        }
        if (world instanceof ServerWorld) {
            BlockState state = ((Block)this.growable).func_176223_P();
            if (state.func_235901_b_((Property)SaplingBlock.field_176479_b)) {
                state = (BlockState)state.func_206870_a((Property)SaplingBlock.field_176479_b, (Comparable)Integer.valueOf(1));
            }
            CompoundNBT before = crop.asTile().serializeNBT();
            this.growable.func_225535_a_((ServerWorld)world, world.func_201674_k(), crop.getPosition(), state);
            if (world.func_180495_p(crop.getPosition()).func_177230_c().equals(this.growable)) {
                world.func_175656_a(crop.getPosition(), crop.getBlockState());
                world.func_175625_s(crop.getPosition()).deserializeNBT(before);
                return Optional.of(ActionResultType.FAIL);
            }
            world.func_217379_c(2005, crop.getPosition(), 0);
        }
        return Optional.of(ActionResultType.SUCCESS);
    }
}

