/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.render.items.journal;

import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.client.IJournalDataDrawer;
import com.infinityraider.agricraft.api.v1.content.items.IAgriJournalItem;
import com.infinityraider.agricraft.impl.v1.journal.IntroductionPage;
import com.infinityraider.agricraft.render.items.journal.JournalDataDrawerBase;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class JournalDataDrawerIntroduction
extends JournalDataDrawerBase<IntroductionPage> {
    private final ITextComponent INTRODUCTION = new TranslationTextComponent("agricraft.journal.introduction");
    private final ITextComponent PARAGRAPH_1 = new TranslationTextComponent("agricraft.journal.introduction.paragraph_1");
    private final ITextComponent PARAGRAPH_2 = new TranslationTextComponent("agricraft.journal.introduction.paragraph_2");
    private final ITextComponent PARAGRAPH_3 = new TranslationTextComponent("agricraft.journal.introduction.paragraph_3");
    private final ITextComponent DISCOVERED = new TranslationTextComponent("agricraft.journal.introduction.discovered");

    @Override
    public ResourceLocation getId() {
        return IntroductionPage.INSTANCE.getDataDrawerId();
    }

    @Override
    public void drawLeftSheet(IntroductionPage page, IJournalDataDrawer.IPageRenderContext context, MatrixStack transforms, ItemStack stack, IAgriJournalItem journal) {
    }

    @Override
    public void drawRightSheet(IntroductionPage page, IJournalDataDrawer.IPageRenderContext context, MatrixStack transforms, ItemStack stack, IAgriJournalItem journal) {
        float dy = 10.0f;
        float dx = 6.0f;
        float spacing = 4.0f;
        dy += context.drawText(transforms, this.INTRODUCTION, dx, dy);
        dy += spacing;
        dy += context.drawText(transforms, this.PARAGRAPH_1, dx, dy, 0.7f);
        dy += spacing;
        dy += context.drawText(transforms, this.PARAGRAPH_2, dx, dy, 0.7f);
        dy += spacing;
        dy += context.drawText(transforms, this.PARAGRAPH_3, dx, dy, 0.7f);
        dy += spacing;
        IFormattableTextComponent discovered = new StringTextComponent("").func_230529_a_(this.DISCOVERED).func_240702_b_(": " + journal.getDiscoveredSeeds(stack).size() + " / " + AgriApi.getPlantRegistry().count());
        context.drawText(transforms, (ITextComponent)discovered, dx, dy += spacing, 0.7f);
    }
}

