/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.render.items.magnfiyingglass;

import com.google.common.collect.ImmutableList;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.client.IMagnifyingGlassInspector;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGeneCarrierItem;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenePair;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenome;
import com.infinityraider.agricraft.render.plant.AgriGenomeRenderer;
import com.infinityraider.agricraft.util.AnimatedScrollPosition;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MagnifyingGlassGenomeInspector
implements IMagnifyingGlassInspector {
    private static final float GENOME_SCALE = 0.075f;
    private static final double TEXT_OFFSET = -0.025;
    private static final float TEXT_SCALE = 0.75f;
    private static final Quaternion TEXT_FLIPPER = Vector3f.field_229183_f_.func_229187_a_(180.0f);
    private static final int SCROLL_DURATION = 10;
    private final AnimatedScrollPosition scrollPosition = new AnimatedScrollPosition(() -> 10, () -> this.genomeCache == null ? 0 : this.genomeCache.size());
    private List<IAgriGenePair<?>> genomeCache;

    public static void init() {
        IMagnifyingGlassInspector.registerInspector(new MagnifyingGlassGenomeInspector());
    }

    protected MagnifyingGlassGenomeInspector() {
    }

    public int getScrollIndex() {
        return this.scrollPosition.getIndex();
    }

    public float getScrollProgress(float partialTick) {
        return this.scrollPosition.getProgress(partialTick);
    }

    @Override
    public boolean canInspect(World world, BlockPos pos, PlayerEntity player) {
        return AgriApi.getCrop((IBlockReader)world, pos).isPresent();
    }

    @Override
    public boolean canInspect(World world, Entity entity, PlayerEntity player) {
        if (entity.func_70089_S() && entity instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            return item.func_92059_d().func_77973_b() instanceof IAgriGeneCarrierItem;
        }
        return false;
    }

    @Override
    public void onInspectionStart(World world, BlockPos pos, PlayerEntity player) {
        this.genomeCache = AgriApi.getCrop((IBlockReader)world, pos).map(crop -> crop.getGenome().map(IAgriGenome::getGeneList).orElse((List)ImmutableList.of())).orElse((List)ImmutableList.of());
    }

    @Override
    public void onInspectionStart(World world, Entity entity, PlayerEntity player) {
        ItemEntity item = (ItemEntity)entity;
        IAgriGeneCarrierItem seed = (IAgriGeneCarrierItem)item.func_92059_d().func_77973_b();
        this.genomeCache = seed.getGenome(item.func_92059_d()).map(IAgriGenome::getGeneList).orElse((List)ImmutableList.of());
    }

    @Override
    public boolean onInspectionTick(World world, BlockPos pos, PlayerEntity player) {
        this.scrollPosition.tick();
        return this.genomeCache != null && !this.genomeCache.isEmpty() && this.canInspect(world, pos, player);
    }

    @Override
    public boolean onInspectionTick(World world, Entity entity, PlayerEntity player) {
        this.scrollPosition.tick();
        return this.genomeCache != null && !this.genomeCache.isEmpty() && this.canInspect(world, entity, player);
    }

    @Override
    public void onInspectionEnd(World world, BlockPos pos, PlayerEntity player) {
        this.scrollPosition.reset();
        this.genomeCache = null;
    }

    @Override
    public void onInspectionEnd(World world, @Nullable Entity entity, PlayerEntity player) {
        this.scrollPosition.reset();
        this.genomeCache = null;
    }

    @Override
    public void onMouseScroll(int delta) {
        this.scrollPosition.scroll(delta);
    }

    @Override
    public void doInspectionRender(MatrixStack transforms, float partialTick, @Nullable Entity entity) {
        List<IAgriGenePair<?>> genome = this.genomeCache;
        if (genome == null || genome.size() <= 0) {
            return;
        }
        this.renderDoubleHelix(genome, transforms, partialTick);
        this.renderTextOverlay(genome, transforms);
    }

    protected void renderDoubleHelix(List<IAgriGenePair<?>> genome, MatrixStack transforms, float partialTicks) {
        transforms.func_227860_a_();
        float h = 0.5f;
        float r = h / 10.0f;
        transforms.func_227862_a_(0.075f, 0.075f, 0.075f);
        transforms.func_227861_a_(0.0, (double)(-h / 2.0f), 0.0);
        AgriGenomeRenderer.getInstance().renderDoubleHelix(genome, transforms, this.getScrollIndex(), this.getScrollProgress(partialTicks), r, h, 1.0f, false);
        transforms.func_227865_b_();
    }

    protected void renderTextOverlay(List<IAgriGenePair<?>> genome, MatrixStack transforms) {
        transforms.func_227860_a_();
        transforms.func_227861_a_(0.0, -0.025, 0.0);
        transforms.func_227863_a_(TEXT_FLIPPER);
        float width = AgriGenomeRenderer.getInstance().getScaledWindowWidth();
        float height = AgriGenomeRenderer.getInstance().getScaledWindowHeight();
        float scale = 0.75f / Math.max(width, height);
        transforms.func_227862_a_(scale, scale, scale);
        int index = Math.max(0, Math.min(genome.size() - 1, this.getScrollIndex()));
        AgriGenomeRenderer.getInstance().renderTextOverlay(transforms, genome.get(index));
        transforms.func_227865_b_();
    }
}

