/*
 * Decompiled with CFR 0.152.
 */
package com.github.elrol.industrialagriculture.config;

import com.blakebr0.mysticalagradditions.lib.ModCorePlugin;
import com.blakebr0.mysticalagriculture.api.crop.CropTier;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;

public class MainConfig {
    public static Logger logger = Logger.getLogger(MainConfig.class.getName());
    public static final File file = new File(FMLPaths.CONFIGDIR.get().toFile(), "/IndustrialAgriculture");
    Map<String, Integer> soulQty = new HashMap<String, Integer>();
    Map<String, String> tierMap = new HashMap<String, String>();
    Map<String, String> cruxMap = new HashMap<String, String>();

    public void init() {
        logger.info("Initializing Init Config");
        this.reg("bat", 10, "TWO", "");
        this.reg("cat", 10, "TWO", "");
        this.reg("dolphin", 10, "THREE", "");
        this.reg("horse", 10, "THREE", "");
        this.reg("drowned", 10, "THREE", "");
        this.reg("guardian", 10, "THREE", "");
        this.reg("endermite", 10, "FOUR", "");
        this.reg("evoker", 10, "FIVE", "");
        this.reg("fox", 10, "TWO", "");
        this.reg("husk", 10, "THREE", "");
        this.reg("llama", 10, "THREE", "");
        this.reg("magma_cube", 10, "FOUR", "");
        this.reg("mooshroom", 10, "FOUR", "");
        this.reg("panda", 10, "TWO", "");
        this.reg("parrot", 10, "TWO", "");
        this.reg("phantom", 10, "FOUR", "");
        this.reg("piglin", 10, "FOUR", "");
        this.reg("piglin_brute", 10, "FIVE", "");
        this.reg("pillager", 10, "FOUR", "");
        this.reg("polar_bear", 10, "THREE", "");
        this.reg("ravager", 10, "FOUR", "");
        this.reg("shulker", 10, "FOUR", "");
        this.reg("silverfish", 10, "THREE", "");
        this.reg("stray", 10, "THREE", "");
        this.reg("vex", 10, "THREE", "");
        this.reg("villager", 10, "FOUR", "");
        this.reg("vindicator", 10, "FOUR", "");
        this.reg("witch", 10, "THREE", "");
        this.reg("wolf", 10, "TWO", "");
        this.reg("zombified_piglin", 10, "THREE", "");
        this.save();
    }

    private void reg(String name, int qty, String tier, String crux) {
        this.soulQty.putIfAbsent(name, qty);
        this.tierMap.putIfAbsent(name, tier);
        this.cruxMap.putIfAbsent(name, crux);
    }

    public Integer getSoulQty(String name) {
        if (this.soulQty.containsKey(name)) {
            Integer i = this.soulQty.get(name);
            if (i == null) {
                logger.info("The Soul Quantity for '" + name + "' was null. This should not happen. Report it to Elrol_Arrowsend.");
                return 0;
            }
            return i;
        }
        return 0;
    }

    public CropTier getTier(String name) {
        if (this.tierMap.containsKey(name)) {
            return MainConfig.getCropTier(this.tierMap.get(name));
        }
        return CropTier.ONE;
    }

    public Map<String, String> getCruxMap() {
        return this.cruxMap;
    }

    public static CropTier getCropTier(String tier) {
        if (tier == null) {
            return CropTier.ONE;
        }
        switch (tier) {
            case "TWO": {
                return CropTier.TWO;
            }
            case "THREE": {
                return CropTier.THREE;
            }
            case "FOUR": {
                return CropTier.FOUR;
            }
            case "FIVE": {
                return CropTier.FIVE;
            }
            case "SIX": {
                if (ModList.get().isLoaded("mysticalagradditions")) {
                    return ModCorePlugin.CROP_TIER_6;
                }
                return CropTier.FIVE;
            }
            case "ELEMENTAL": {
                return CropTier.ELEMENTAL;
            }
        }
        return CropTier.ONE;
    }

    public void save() {
        logger.info("Saving Init Config");
        if (!file.exists()) {
            file.mkdirs();
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            String jsonString = gson.toJson((Object)this);
            FileWriter writer = new FileWriter(new File(file, "Vanilla.json"));
            writer.write(jsonString);
            writer.close();
        }
        catch (IOException e) {
            System.out.println("exception " + e.getMessage());
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MainConfig load() {
        logger.info("Loading Init Config");
        File f = new File(file, "Vanilla.json");
        Gson gson = new GsonBuilder().create();
        BufferedReader bufferedReader = null;
        MainConfig config = new MainConfig();
        if (f.exists()) {
            if (!f.canWrite()) {
                f.setWritable(true);
            }
            try {
                bufferedReader = new BufferedReader(new FileReader(f));
                config = (MainConfig)gson.fromJson((Reader)bufferedReader, new TypeToken<MainConfig>(){}.getType());
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (config == null) {
            config = new MainConfig();
        }
        config.init();
        return config;
    }

    public void addCrux(String name, String crux) {
        this.cruxMap.putIfAbsent(name, crux);
        this.save();
    }
}

