/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.endergenic.data;

import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Logging;
import mcjty.rftoolspower.modules.endergenic.blocks.EndergenicTileEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EndergenicPearl {
    private int ticksLeft;
    private final BlockPos destination;
    private final int age;

    public EndergenicPearl(int ticksLeft, BlockPos destination, int age) {
        this.ticksLeft = ticksLeft;
        this.destination = destination;
        this.age = age;
    }

    public EndergenicPearl(CompoundNBT tagCompound) {
        this.ticksLeft = tagCompound.func_74762_e("t");
        this.destination = BlockPosTools.read((CompoundNBT)tagCompound, (String)"dest");
        this.age = tagCompound.func_74762_e("age");
    }

    public int getTicksLeft() {
        return this.ticksLeft;
    }

    public int getAge() {
        return this.age;
    }

    public BlockPos getDestination() {
        return this.destination;
    }

    public boolean handleTick(World world) {
        --this.ticksLeft;
        if (this.ticksLeft <= 0) {
            TileEntity te = world.func_175625_s(this.destination);
            if (te instanceof EndergenicTileEntity) {
                EndergenicTileEntity endergenicTileEntity = (EndergenicTileEntity)te;
                endergenicTileEntity.receivePearl(this.age);
            } else {
                Logging.log((String)"Pearl: where did the destination go?");
            }
            return true;
        }
        return false;
    }

    public CompoundNBT getTagCompound() {
        CompoundNBT tagCompound = new CompoundNBT();
        tagCompound.func_74768_a("t", this.ticksLeft);
        BlockPosTools.write((CompoundNBT)tagCompound, (String)"dest", (BlockPos)this.destination);
        tagCompound.func_74768_a("age", this.age);
        return tagCompound;
    }
}

