/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wirelesschargers;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.gui.WidgetScreen;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.registry.ClientRegistrationHandler;
import com.supermartijn642.core.render.BlockEntityCustomItemRenderer;
import com.supermartijn642.core.render.CustomRendererBakedModelWrapper;
import com.supermartijn642.wirelesschargers.ChargerModelType;
import com.supermartijn642.wirelesschargers.ChargerRenderer;
import com.supermartijn642.wirelesschargers.ChargerType;
import com.supermartijn642.wirelesschargers.screen.ChargerScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class WirelessChargersClient {
    public static void register() {
        ClientRegistrationHandler handler = ClientRegistrationHandler.get((String)"wirelesschargers");
        for (ChargerType chargerType : ChargerType.values()) {
            handler.registerCustomBlockEntityRenderer(chargerType::getBlockEntityType, ChargerRenderer::new);
            ModelResourceLocation location = new ModelResourceLocation("wirelesschargers:" + chargerType.getRegistryName(), "inventory");
            handler.registerModelOverwrite((ResourceLocation)location, CustomRendererBakedModelWrapper::wrap);
            handler.registerCustomItemRenderer(chargerType::getItem, () -> new BlockEntityCustomItemRenderer(true, type::createBlockEntity, (stack, entity) -> entity.readData(stack.func_77942_o() ? stack.func_77978_p().func_74775_l("tileData") : new CompoundNBT())));
        }
        for (ChargerModelType chargerModelType : ChargerModelType.values()) {
            handler.registerModel(chargerModelType.ringModel);
        }
    }

    public static void openChargerScreen(ITextComponent title, World level, BlockPos pos) {
        ClientUtils.displayScreen((Screen)WidgetScreen.of((Widget)new ChargerScreen(title, level, pos)));
    }
}

