/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.core;

import com.mojang.authlib.GameProfile;
import forestry.api.genetics.IBreedingTracker;
import genetics.api.alleles.IAlleleSpecies;
import genetics.api.mutation.IMutation;
import genetics.api.root.IRootDefinition;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.eventbus.api.Event;

public abstract class ForestryEvent
extends Event {

    public static class SyncedBreedingTracker
    extends ForestryEvent {
        public final IBreedingTracker tracker;
        public final PlayerEntity player;

        public SyncedBreedingTracker(IBreedingTracker tracker, PlayerEntity player) {
            this.tracker = tracker;
            this.player = player;
        }
    }

    public static class MutationDiscovered
    extends BreedingEvent {
        public final IMutation allele;

        public MutationDiscovered(IRootDefinition root, GameProfile username, IMutation allele, IBreedingTracker tracker) {
            super(root, username, tracker);
            this.allele = allele;
        }
    }

    public static class SpeciesDiscovered
    extends BreedingEvent {
        public final IAlleleSpecies species;

        public SpeciesDiscovered(IRootDefinition root, GameProfile username, IAlleleSpecies species, IBreedingTracker tracker) {
            super(root, username, tracker);
            this.species = species;
        }
    }

    private static abstract class BreedingEvent
    extends ForestryEvent {
        public final IRootDefinition root;
        public final IBreedingTracker tracker;
        public final GameProfile username;

        private BreedingEvent(IRootDefinition root, GameProfile username, IBreedingTracker tracker) {
            this.root = root;
            this.username = username;
            this.tracker = tracker;
        }
    }
}

