/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.genetics.alyzer.IAlleleDisplayHelper;
import forestry.api.genetics.alyzer.IAlyzerDisplayProvider;
import forestry.apiculture.genetics.IGeneticTooltipProvider;
import genetics.api.individual.IIndividual;
import genetics.api.organism.IOrganismType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class DisplayHelper
implements IAlleleDisplayHelper {
    private final Map<String, PriorityQueue<OrderedPair<IGeneticTooltipProvider<?>>>> tooltips = new HashMap();
    private final Map<String, PriorityQueue<OrderedPair<IAlyzerDisplayProvider<?>>>> alyzers = new HashMap();
    @Nullable
    private static DisplayHelper instance;

    public static DisplayHelper getInstance() {
        if (instance == null) {
            instance = new DisplayHelper();
        }
        return instance;
    }

    public void addTooltip(IGeneticTooltipProvider<?> provider, String rootUID, int orderingInfo) {
        this.tooltips.computeIfAbsent(rootUID, root -> new PriorityQueue()).add(new OrderedPair(provider, orderingInfo, null));
    }

    public void addTooltip(IGeneticTooltipProvider<?> provider, String rootUID, int orderingInfo, Predicate<IOrganismType> typeFilter) {
        this.tooltips.computeIfAbsent(rootUID, root -> new PriorityQueue()).add(new OrderedPair(provider, orderingInfo, typeFilter));
    }

    public void addAlyzer(IAlyzerDisplayProvider<?> provider, String rootUID, int orderingInfo) {
        this.alyzers.computeIfAbsent(rootUID, root -> new PriorityQueue()).add(new OrderedPair(provider, orderingInfo, null));
    }

    public void addAlyzer(IAlyzerDisplayProvider<?> provider, String rootUID, int orderingInfo, Predicate<IOrganismType> typeFilter) {
        this.alyzers.computeIfAbsent(rootUID, root -> new PriorityQueue()).add(new OrderedPair(provider, orderingInfo, typeFilter));
    }

    public <I extends IIndividual> Collection<IGeneticTooltipProvider<I>> getTooltips(String rootUID, IOrganismType type) {
        if (!this.tooltips.containsKey(rootUID)) {
            return Collections.emptyList();
        }
        return this.tooltips.get(rootUID).stream().filter(value -> value.hasValue(type)).map(value -> (IGeneticTooltipProvider)((OrderedPair)value).value).collect(Collectors.toList());
    }

    public <I extends IIndividual> Collection<IAlyzerDisplayProvider<I>> getAlyzers(String rootUID, IOrganismType type) {
        if (!this.alyzers.containsKey(rootUID)) {
            return Collections.emptyList();
        }
        return this.alyzers.get(rootUID).stream().filter(value -> value.hasValue(type)).map(value -> (IAlyzerDisplayProvider)((OrderedPair)value).value).collect(Collectors.toList());
    }

    private static class OrderedPair<T>
    implements Comparable<OrderedPair<T>> {
        private final T value;
        private final int info;
        @Nullable
        private final Predicate<IOrganismType> filter;

        private OrderedPair(T value, int info, @Nullable Predicate<IOrganismType> filter) {
            this.value = value;
            this.info = info;
            this.filter = filter;
        }

        public boolean hasValue(IOrganismType type) {
            return this.filter == null || this.filter.test(type);
        }

        @Override
        public int compareTo(OrderedPair<T> o) {
            return this.info - o.info;
        }
    }
}

