/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.hives.IHiveRegistry;
import forestry.core.config.LocalizedConfiguration;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;

public class HiveConfig {
    private static final Map<IHiveRegistry.HiveType, HiveConfig> configs = new EnumMap<IHiveRegistry.HiveType, HiveConfig>(IHiveRegistry.HiveType.class);
    private static final String CATEGORY = "world.generate.beehives.blacklist";
    private final Set<Biome.Category> blacklistedTypes = new HashSet<Biome.Category>();
    private final Set<Biome> blacklistedBiomes = new HashSet<Biome>();
    private static final Set<ResourceLocation> blacklistedDims = new HashSet<ResourceLocation>();
    private static final Set<ResourceLocation> whitelistedDims = new HashSet<ResourceLocation>();
    @Nullable
    private static HiveConfig GLOBAL;

    public static void parse(LocalizedConfiguration config) {
        config.addCategoryCommentLocalized(CATEGORY);
        for (String dimId : config.get("world.generate.beehives", "dimBlacklist", new String[0]).getStringList()) {
            blacklistedDims.add(new ResourceLocation(dimId));
        }
        for (String dimId : config.get("world.generate.beehives", "dimWhitelist", new String[0]).getStringList()) {
            whitelistedDims.add(new ResourceLocation(dimId));
        }
        for (IHiveRegistry.HiveType type : IHiveRegistry.HiveType.values()) {
            String[] entries = config.get(CATEGORY, type.func_176610_l(), new String[0]).getStringList();
            configs.put(type, new HiveConfig(entries));
        }
        String[] globalEntries = config.get(CATEGORY, "global", new String[0]).getStringList();
        GLOBAL = new HiveConfig(globalEntries);
    }

    public HiveConfig(String[] entries) {
        for (String entry : entries) {
            Biome.Category category = Biome.Category.valueOf((String)entry);
            Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(entry));
            if (category != null) {
                this.blacklistedTypes.add(category);
                continue;
            }
            if (biome == null) continue;
            this.blacklistedBiomes.add(biome);
        }
    }

    public static boolean isBlacklisted(IHiveRegistry.HiveType type, Biome biome) {
        if (GLOBAL != null && GLOBAL.isBlacklisted(biome)) {
            return true;
        }
        HiveConfig config = configs.get(type);
        if (config == null) {
            return false;
        }
        return config.isBlacklisted(biome);
    }

    private boolean isBlacklisted(Biome biome) {
        if (GLOBAL != null && this != GLOBAL && GLOBAL.isBlacklisted(biome)) {
            return true;
        }
        if (this.blacklistedBiomes.contains(biome)) {
            return true;
        }
        return Arrays.stream(Biome.Category.values()).anyMatch(this.blacklistedTypes::contains);
    }

    public static boolean isDimAllowed(ResourceLocation dimId) {
        if (blacklistedDims.isEmpty() || !blacklistedDims.contains(dimId)) {
            return whitelistedDims.isEmpty() || whitelistedDims.contains(dimId);
        }
        return false;
    }

    public static void addBlacklistedDim(ResourceLocation dimId) {
        blacklistedDims.add(dimId);
    }

    public static void addWhitelistedDim(ResourceLocation dimId) {
        whitelistedDims.add(dimId);
    }
}

