/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import com.google.common.base.Preconditions;
import forestry.Forestry;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.FlowerManager;
import forestry.api.apiculture.IArmorApiarist;
import forestry.api.apiculture.IBeekeepingMode;
import forestry.api.apiculture.hives.HiveManager;
import forestry.api.apiculture.hives.IHiveRegistry;
import forestry.api.genetics.flowers.IFlowerAcceptableRule;
import forestry.api.modules.ForestryModule;
import forestry.apiculture.ApicultureFilterRule;
import forestry.apiculture.ApicultureFilterRuleType;
import forestry.apiculture.ArmorApiaristHelper;
import forestry.apiculture.SaveEventHandlerApiculture;
import forestry.apiculture.capabilities.ArmorApiarist;
import forestry.apiculture.commands.CommandBee;
import forestry.apiculture.features.ApicultureContainers;
import forestry.apiculture.features.ApicultureFeatures;
import forestry.apiculture.features.ApicultureItems;
import forestry.apiculture.flowers.FlowerRegistry;
import forestry.apiculture.genetics.BeeDefinition;
import forestry.apiculture.genetics.BeeFactory;
import forestry.apiculture.genetics.BeeMutationFactory;
import forestry.apiculture.genetics.HiveDrop;
import forestry.apiculture.genetics.JubilanceFactory;
import forestry.apiculture.gui.GuiAlveary;
import forestry.apiculture.gui.GuiAlvearyHygroregulator;
import forestry.apiculture.gui.GuiAlvearySieve;
import forestry.apiculture.gui.GuiAlvearySwarmer;
import forestry.apiculture.gui.GuiBeeHousing;
import forestry.apiculture.gui.GuiHabitatLocator;
import forestry.apiculture.gui.GuiImprinter;
import forestry.apiculture.items.EnumHoneyComb;
import forestry.apiculture.items.EnumPollenCluster;
import forestry.apiculture.items.HabitatLocatorLogic;
import forestry.apiculture.network.PacketRegistryApiculture;
import forestry.apiculture.particles.ApicultureParticles;
import forestry.apiculture.proxy.ProxyApiculture;
import forestry.apiculture.proxy.ProxyApicultureClient;
import forestry.apiculture.villagers.RegisterVillager;
import forestry.apiculture.worldgen.HiveDescription;
import forestry.apiculture.worldgen.HiveGenHelper;
import forestry.apiculture.worldgen.HiveRegistry;
import forestry.core.ISaveEventHandler;
import forestry.core.ModuleCore;
import forestry.core.capabilities.NullStorage;
import forestry.core.config.Config;
import forestry.core.config.Constants;
import forestry.core.config.LocalizedConfiguration;
import forestry.core.network.IPacketRegistry;
import forestry.core.utils.ForgeUtils;
import forestry.core.utils.IMCUtil;
import forestry.core.utils.Log;
import forestry.modules.BlankForestryModule;
import forestry.modules.ISidedModuleHandler;
import forestry.modules.ModuleHelper;
import genetics.api.GeneticsAPI;
import genetics.api.individual.IGenome;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@ForestryModule(containerID="forestry", moduleID="apiculture", name="Apiculture", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.apiculture.description", lootTable="apiculture")
public class ModuleApiculture
extends BlankForestryModule {
    private static final String CONFIG_CATEGORY = "apiculture";
    private static float secondPrincessChance = 0.0f;
    @Nullable
    private static HiveRegistry hiveRegistry;
    public static String beekeepingMode;
    public static int ticksPerBeeWorkCycle;
    public static boolean hivesDamageOnPeaceful;
    public static boolean hivesDamageUnderwater;
    public static boolean hivesDamageOnlyPlayers;
    public static boolean hiveDamageOnAttack;
    public static boolean doSelfPollination;
    public static int maxFlowersSpawnedPerHive;
    public static ProxyApiculture proxy;

    public static HiveRegistry getHiveRegistry() {
        Preconditions.checkNotNull((Object)hiveRegistry);
        return hiveRegistry;
    }

    public ModuleApiculture() {
        proxy = (ProxyApiculture)DistExecutor.safeRunForDist(() -> ProxyApicultureClient::new, () -> ProxyApiculture::new);
        ForgeUtils.registerSubscriber(this);
        MinecraftForge.EVENT_BUS.register(HabitatLocatorLogic.class);
        ApicultureParticles.PARTICLE_TYPES.register(FMLJavaModLoadingContext.get().getModEventBus());
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        if (Config.enableVillagers) {
            RegisterVillager.Registers.POINTS_OF_INTEREST.register(modEventBus);
            RegisterVillager.Registers.PROFESSIONS.register(modEventBus);
            MinecraftForge.EVENT_BUS.register((Object)new RegisterVillager.Events());
        }
        if (Config.getBeehivesAmount() > 0.0) {
            modEventBus.addGenericListener(Feature.class, ApicultureFeatures::registerFeatures);
            MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, ApicultureFeatures::onBiomeLoad);
        }
    }

    @Override
    public void setupAPI() {
        hiveRegistry = new HiveRegistry();
        HiveManager.hiveRegistry = hiveRegistry;
        HiveManager.genHelper = new HiveGenHelper();
        FlowerManager.flowerRegistry = new FlowerRegistry();
        BeeManager.commonVillageBees = new ArrayList<IGenome>();
        BeeManager.uncommonVillageBees = new ArrayList<IGenome>();
        BeeManager.beeFactory = new BeeFactory();
        BeeManager.beeMutationFactory = new BeeMutationFactory();
        BeeManager.jubilanceFactory = new JubilanceFactory();
        BeeManager.armorApiaristHelper = new ArmorApiaristHelper();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerGuiFactories() {
        ScreenManager.func_216911_a(ApicultureContainers.ALVEARY.containerType(), GuiAlveary::new);
        ScreenManager.func_216911_a(ApicultureContainers.ALVEARY_HYGROREGULATOR.containerType(), GuiAlvearyHygroregulator::new);
        ScreenManager.func_216911_a(ApicultureContainers.ALVEARY_SIEVE.containerType(), GuiAlvearySieve::new);
        ScreenManager.func_216911_a(ApicultureContainers.ALVEARY_SWARMER.containerType(), GuiAlvearySwarmer::new);
        ScreenManager.func_216911_a(ApicultureContainers.BEE_HOUSING.containerType(), GuiBeeHousing::new);
        ScreenManager.func_216911_a(ApicultureContainers.HABITAT_LOCATOR.containerType(), GuiHabitatLocator::new);
        ScreenManager.func_216911_a(ApicultureContainers.IMPRINTER.containerType(), GuiImprinter::new);
        ScreenManager.func_216911_a(ApicultureContainers.BEEHOUSE_MINECART.containerType(), GuiBeeHousing::new);
    }

    @Override
    public void preInit() {
        CapabilityManager.INSTANCE.register(IArmorApiarist.class, new NullStorage(), () -> ArmorApiarist.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModuleCore.rootCommand.then(CommandBee.register());
        if (ModuleHelper.isEnabled("sorting")) {
            ApicultureFilterRuleType.init();
            ApicultureFilterRule.init();
        }
    }

    @Override
    public void doInit() {
        boolean deleted;
        File configFile = new File(Forestry.instance.getConfigFolder(), "apiculture.cfg");
        LocalizedConfiguration config = new LocalizedConfiguration(configFile, "3.0.0");
        if (!Objects.equals(config.getLoadedConfigVersion(), config.getDefinedConfigVersion()) && (deleted = configFile.delete())) {
            config = new LocalizedConfiguration(configFile, "3.0.0");
        }
        this.initFlowerRegistry();
        List<IBeekeepingMode> beekeepingModes = BeeManager.beeRoot.getBeekeepingModes();
        String[] validBeekeepingModeNames = new String[beekeepingModes.size()];
        for (int i = 0; i < beekeepingModes.size(); ++i) {
            validBeekeepingModeNames[i] = beekeepingModes.get(i).getName();
        }
        beekeepingMode = config.getStringLocalized("beekeeping", "mode", "NORMAL", validBeekeepingModeNames);
        Log.debug("Beekeeping mode read from config: " + beekeepingMode, new Object[0]);
        secondPrincessChance = config.getFloatLocalized("beekeeping", "second.princess", secondPrincessChance, 0.0f, 100.0f);
        maxFlowersSpawnedPerHive = config.getIntLocalized("beekeeping", "flowers.spawn", 20, 0, 1000);
        String[] blacklist = config.getStringListLocalized("species", "blacklist", Constants.EMPTY_STRINGS);
        ModuleApiculture.parseBeeBlacklist(blacklist);
        ticksPerBeeWorkCycle = config.getIntLocalized("beekeeping", "ticks.work", 550, 250, 850);
        hivesDamageOnPeaceful = config.getBooleanLocalized("beekeeping.hivedamage", "peaceful", hivesDamageOnPeaceful);
        hivesDamageUnderwater = config.getBooleanLocalized("beekeeping.hivedamage", "underwater", hivesDamageUnderwater);
        hivesDamageOnlyPlayers = config.getBooleanLocalized("beekeeping.hivedamage", "onlyPlayers", hivesDamageOnlyPlayers);
        hiveDamageOnAttack = config.getBooleanLocalized("beekeeping.hivedamage", "onlyAfterAttack", hiveDamageOnAttack);
        doSelfPollination = config.getBooleanLocalized("beekeeping", "self.pollination", false);
        config.save();
        BeeDefinition.initBees();
        ModuleApiculture.createHives();
        ModuleApiculture.registerBeehiveDrops();
        BeeManager.inducers.put(ApicultureItems.ROYAL_JELLY.stack(), 10);
        BeeManager.commonVillageBees.add(BeeDefinition.FOREST.getGenome());
        BeeManager.commonVillageBees.add(BeeDefinition.MEADOWS.getGenome());
        BeeManager.commonVillageBees.add(BeeDefinition.MODEST.getGenome());
        BeeManager.commonVillageBees.add(BeeDefinition.MARSHY.getGenome());
        BeeManager.commonVillageBees.add(BeeDefinition.WINTRY.getGenome());
        BeeManager.commonVillageBees.add(BeeDefinition.TROPICAL.getGenome());
        BeeManager.uncommonVillageBees.add(BeeDefinition.FOREST.getRainResist().getGenome());
        BeeManager.uncommonVillageBees.add(BeeDefinition.COMMON.getGenome());
        BeeManager.uncommonVillageBees.add(BeeDefinition.VALIANT.getGenome());
    }

    @Override
    public void postInit() {
    }

    private void initFlowerRegistry() {
        FlowerRegistry flowerRegistry = (FlowerRegistry)FlowerManager.flowerRegistry;
        flowerRegistry.registerAcceptableFlowerRule(new EndFlowerAcceptableRule(), "flowersEnd");
        flowerRegistry.registerAcceptableFlower(Blocks.field_150380_bt, "flowersEnd");
        flowerRegistry.registerAcceptableFlower(Blocks.field_185765_cR, "flowersEnd");
        flowerRegistry.registerAcceptableFlower(Blocks.field_185766_cS, "flowersEnd");
        flowerRegistry.registerAcceptableFlower(Blocks.field_150395_bd, "flowersJungle");
        flowerRegistry.registerAcceptableFlower(Blocks.field_196554_aH, "flowersJungle");
        flowerRegistry.registerAcceptableFlower(Blocks.field_150464_aj, "flowersWheat");
        flowerRegistry.registerAcceptableFlower(Blocks.field_150393_bb, "flowersGourd");
        flowerRegistry.registerAcceptableFlower(Blocks.field_150394_bc, "flowersGourd");
        flowerRegistry.registerAcceptableFlower(Blocks.field_150388_bm, "flowersNether");
        flowerRegistry.registerAcceptableFlower(Blocks.field_150434_aF, "flowersCacti");
        Block[] standardFlowers = new Block[]{Blocks.field_196605_bc, Blocks.field_196606_bd, Blocks.field_196607_be, Blocks.field_196609_bf, Blocks.field_196610_bg, Blocks.field_196612_bh, Blocks.field_196613_bi, Blocks.field_196614_bj, Blocks.field_196615_bk, Blocks.field_196616_bl, Blocks.field_222387_by, Blocks.field_222388_bz, Blocks.field_222383_bA};
        Block[] pottedStandardFlowers = new Block[]{Blocks.field_196726_ei, Blocks.field_196728_ej, Blocks.field_196730_ek, Blocks.field_196732_el, Blocks.field_196734_em, Blocks.field_196736_en, Blocks.field_196738_eo, Blocks.field_196740_ep, Blocks.field_196742_eq, Blocks.field_222398_eF, Blocks.field_222399_eG, Blocks.field_222400_eH};
        String[] standardTypes = new String[]{"flowersVanilla", "flowersSnow"};
        for (Block standardFlower : standardFlowers) {
            flowerRegistry.registerPlantableFlower(standardFlower.func_176223_P(), 1.0, standardTypes);
        }
        flowerRegistry.registerPlantableFlower(Blocks.field_150338_P.func_176223_P(), 1.0, "flowersMushrooms");
        flowerRegistry.registerPlantableFlower(Blocks.field_150337_Q.func_176223_P(), 1.0, "flowersMushrooms");
        flowerRegistry.registerPlantableFlower(Blocks.field_150434_aF.func_176223_P(), 1.0, "flowersCacti");
        for (Block standardFlower : pottedStandardFlowers) {
            flowerRegistry.registerAcceptableFlower(standardFlower, standardTypes);
        }
        flowerRegistry.registerAcceptableFlower(Blocks.field_196756_ey, "flowersMushrooms");
        flowerRegistry.registerAcceptableFlower(Blocks.field_196757_ez, "flowersMushrooms");
        flowerRegistry.registerAcceptableFlower(Blocks.field_196685_eC, "flowersCacti");
    }

    @Override
    public IPacketRegistry getPacketRegistry() {
        return new PacketRegistryApiculture();
    }

    @Override
    public void registerRecipes() {
        BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185233_e)}), (Ingredient)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ApicultureItems.POLLEN_CLUSTER.stack(EnumPollenCluster.NORMAL, 1)}), (ItemStack)PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185250_v));
        BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185233_e)}), (Ingredient)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ApicultureItems.POLLEN_CLUSTER.stack(EnumPollenCluster.CRYSTALLINE, 1)}), (ItemStack)PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185220_C));
    }

    private static void registerBeehiveDrops() {
        ItemStack honeyComb = ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.HONEY, 1);
        HiveRegistry hiveRegistry = ModuleApiculture.getHiveRegistry();
        hiveRegistry.addDrops(IHiveRegistry.HiveType.FOREST.getHiveUid(), new HiveDrop(0.8, BeeDefinition.FOREST, honeyComb).setIgnobleShare(0.7), new HiveDrop(0.08, BeeDefinition.FOREST.getRainResist(), honeyComb), new HiveDrop(0.03, BeeDefinition.VALIANT, honeyComb));
        hiveRegistry.addDrops(IHiveRegistry.HiveType.MEADOWS.getHiveUid(), new HiveDrop(0.8, BeeDefinition.MEADOWS, honeyComb).setIgnobleShare(0.7), new HiveDrop(0.03, BeeDefinition.VALIANT, honeyComb));
        ItemStack parchedComb = ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.PARCHED, 1);
        hiveRegistry.addDrops(IHiveRegistry.HiveType.DESERT.getHiveUid(), new HiveDrop(0.8, BeeDefinition.MODEST, parchedComb).setIgnobleShare(0.7), new HiveDrop(0.03, BeeDefinition.VALIANT, parchedComb));
        ItemStack silkyComb = ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.SILKY, 1);
        hiveRegistry.addDrops(IHiveRegistry.HiveType.JUNGLE.getHiveUid(), new HiveDrop(0.8, BeeDefinition.TROPICAL, silkyComb).setIgnobleShare(0.7), new HiveDrop(0.03, BeeDefinition.VALIANT, silkyComb));
        ItemStack mysteriousComb = ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.MYSTERIOUS, 1);
        hiveRegistry.addDrops(IHiveRegistry.HiveType.END.getHiveUid(), new HiveDrop(0.9, BeeDefinition.ENDED, mysteriousComb));
        ItemStack frozenComb = ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.FROZEN, 1);
        hiveRegistry.addDrops(IHiveRegistry.HiveType.SNOW.getHiveUid(), new HiveDrop(0.8, BeeDefinition.WINTRY, frozenComb).setIgnobleShare(0.5), new HiveDrop(0.03, BeeDefinition.VALIANT, frozenComb));
        ItemStack mossyComb = ApicultureItems.BEE_COMBS.stack(EnumHoneyComb.MOSSY, 1);
        hiveRegistry.addDrops(IHiveRegistry.HiveType.SWAMP.getHiveUid(), new HiveDrop(0.8, BeeDefinition.MARSHY, mossyComb).setIgnobleShare(0.4), new HiveDrop(0.03, BeeDefinition.VALIANT, mossyComb));
    }

    private static void createHives() {
        HiveRegistry hiveRegistry = ModuleApiculture.getHiveRegistry();
        hiveRegistry.registerHive(IHiveRegistry.HiveType.FOREST.getHiveUid(), HiveDescription.FOREST);
        hiveRegistry.registerHive(IHiveRegistry.HiveType.MEADOWS.getHiveUid(), HiveDescription.MEADOWS);
        hiveRegistry.registerHive(IHiveRegistry.HiveType.DESERT.getHiveUid(), HiveDescription.DESERT);
        hiveRegistry.registerHive(IHiveRegistry.HiveType.JUNGLE.getHiveUid(), HiveDescription.JUNGLE);
        hiveRegistry.registerHive(IHiveRegistry.HiveType.END.getHiveUid(), HiveDescription.END);
        hiveRegistry.registerHive(IHiveRegistry.HiveType.SNOW.getHiveUid(), HiveDescription.SNOW);
        hiveRegistry.registerHive(IHiveRegistry.HiveType.SWAMP.getHiveUid(), HiveDescription.SWAMP);
    }

    public static double getSecondPrincessChance() {
        return secondPrincessChance;
    }

    private static void parseBeeBlacklist(String[] items) {
        for (String item : items) {
            if (item.isEmpty()) continue;
            Log.debug("Blacklisting bee species identified by " + item, new Object[0]);
            GeneticsAPI.apiInstance.getAlleleRegistry().blacklistAllele(new ResourceLocation(item));
        }
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return new SaveEventHandlerApiculture();
    }

    @Override
    public boolean processIMCMessage(InterModComms.IMCMessage message) {
        return false;
    }

    private boolean addPlantableFlower(InterModComms.IMCMessage message) {
        try {
            return true;
        }
        catch (Exception e) {
            IMCUtil.logInvalidIMCMessage(message);
            return false;
        }
    }

    private boolean addAcceptableFlower(InterModComms.IMCMessage message) {
        try {
            return true;
        }
        catch (Exception e) {
            IMCUtil.logInvalidIMCMessage(message);
            return false;
        }
    }

    @Override
    public ISidedModuleHandler getModuleHandler() {
        return proxy;
    }

    static {
        beekeepingMode = "NORMAL";
        ticksPerBeeWorkCycle = 550;
        hivesDamageOnPeaceful = false;
        hivesDamageUnderwater = true;
        hivesDamageOnlyPlayers = false;
        hiveDamageOnAttack = true;
        doSelfPollination = true;
        maxFlowersSpawnedPerHive = 20;
    }

    private static class EndFlowerAcceptableRule
    implements IFlowerAcceptableRule {
        private EndFlowerAcceptableRule() {
        }

        @Override
        public boolean isAcceptableFlower(BlockState blockState, World world, BlockPos pos, String flowerType) {
            Biome biomeGenForCoords = world.func_226691_t_(pos);
            return Biome.Category.THEEND == biomeGenForCoords.func_201856_r();
        }
    }
}

