/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.blocks;

import forestry.apiculture.MaterialBeehive;
import forestry.apiculture.blocks.BlockAlvearyType;
import forestry.apiculture.multiblock.IAlvearyControllerInternal;
import forestry.apiculture.multiblock.MultiblockLogicAlveary;
import forestry.apiculture.multiblock.TileAlveary;
import forestry.apiculture.multiblock.TileAlvearyFan;
import forestry.apiculture.multiblock.TileAlvearyHeater;
import forestry.apiculture.multiblock.TileAlvearyHygroregulator;
import forestry.apiculture.multiblock.TileAlvearyPlain;
import forestry.apiculture.multiblock.TileAlvearySieve;
import forestry.apiculture.multiblock.TileAlvearyStabiliser;
import forestry.apiculture.multiblock.TileAlvearySwarmer;
import forestry.apiculture.network.packets.PacketAlvearyChange;
import forestry.core.blocks.BlockStructure;
import forestry.core.tiles.IActivatable;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.ItemTooltipUtil;
import forestry.core.utils.NetworkUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class BlockAlveary
extends BlockStructure {
    private static final EnumProperty<State> STATE = EnumProperty.func_177709_a((String)"state", State.class);
    private static final EnumProperty<AlvearyPlainType> PLAIN_TYPE = EnumProperty.func_177709_a((String)"type", AlvearyPlainType.class);
    private final BlockAlvearyType type;

    public BlockAlveary(BlockAlvearyType type) {
        super(AbstractBlock.Properties.func_200945_a((Material)MaterialBeehive.BEEHIVE_ALVEARY).func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a).harvestTool(ToolType.AXE).harvestLevel(0));
        this.type = type;
        BlockState defaultState = (BlockState)this.func_176194_O().func_177621_b();
        if (type == BlockAlvearyType.PLAIN) {
            defaultState = (BlockState)defaultState.func_206870_a(PLAIN_TYPE, (Comparable)((Object)AlvearyPlainType.NORMAL));
        } else if (type.activatable) {
            defaultState = (BlockState)defaultState.func_206870_a(STATE, (Comparable)((Object)State.OFF));
        }
        this.func_180632_j(defaultState);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{PLAIN_TYPE, STATE});
    }

    public BlockAlvearyType getType() {
        return this.type;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        switch (this.type) {
            case SWARMER: {
                return new TileAlvearySwarmer();
            }
            case FAN: {
                return new TileAlvearyFan();
            }
            case HEATER: {
                return new TileAlvearyHeater();
            }
            case HYGRO: {
                return new TileAlvearyHygroregulator();
            }
            case STABILISER: {
                return new TileAlvearyStabiliser();
            }
            case SIEVE: {
                return new TileAlvearySieve();
            }
        }
        return new TileAlvearyPlain();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public BlockState getNewState(TileAlveary tile) {
        BlockState state = this.func_176223_P();
        World world = tile.func_145831_w();
        BlockPos pos = tile.func_174877_v();
        if (tile instanceof IActivatable) {
            state = ((IActivatable)((Object)tile)).isActive() ? (BlockState)state.func_206870_a(STATE, (Comparable)((Object)State.ON)) : (BlockState)state.func_206870_a(STATE, (Comparable)((Object)State.OFF));
        } else if (this.getType() == BlockAlvearyType.PLAIN) {
            if (!((MultiblockLogicAlveary)tile.getMultiblockLogic()).getController().isAssembled()) {
                state = (BlockState)state.func_206870_a(PLAIN_TYPE, (Comparable)((Object)AlvearyPlainType.NORMAL));
            } else {
                BlockState blockStateAbove = world.func_180495_p(pos.func_177984_a());
                Block blockAbove = blockStateAbove.func_177230_c();
                if (blockAbove.func_203417_a((ITag)BlockTags.field_202895_i)) {
                    List<Direction> blocksTouching = BlockAlveary.getBlocksTouching((IBlockReader)world, pos);
                    switch (blocksTouching.size()) {
                        case 3: {
                            state = (BlockState)state.func_206870_a(PLAIN_TYPE, (Comparable)((Object)AlvearyPlainType.ENTRANCE));
                            break;
                        }
                        case 2: {
                            if (blocksTouching.contains(Direction.SOUTH) && blocksTouching.contains(Direction.EAST) || blocksTouching.contains(Direction.NORTH) && blocksTouching.contains(Direction.WEST)) {
                                state = (BlockState)state.func_206870_a(PLAIN_TYPE, (Comparable)((Object)AlvearyPlainType.ENTRANCE_LEFT));
                                break;
                            }
                            state = (BlockState)state.func_206870_a(PLAIN_TYPE, (Comparable)((Object)AlvearyPlainType.ENTRANCE_RIGHT));
                            break;
                        }
                        default: {
                            state = (BlockState)state.func_206870_a(PLAIN_TYPE, (Comparable)((Object)AlvearyPlainType.NORMAL));
                            break;
                        }
                    }
                } else {
                    state = (BlockState)state.func_206870_a(PLAIN_TYPE, (Comparable)((Object)AlvearyPlainType.NORMAL));
                }
            }
        }
        return state;
    }

    private static List<Direction> getBlocksTouching(IBlockReader world, BlockPos blockPos) {
        ArrayList<Direction> touching = new ArrayList<Direction>();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState blockState = world.func_180495_p(blockPos.func_177972_a(direction));
            if (!(blockState.func_177230_c() instanceof BlockAlveary)) continue;
            touching.add(direction);
        }
        return touching;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean p_220069_6_) {
        TileUtil.actOnTile((IWorldReader)worldIn, pos, TileAlveary.class, tileAlveary -> {
            IAlvearyControllerInternal alveary = ((MultiblockLogicAlveary)tileAlveary.getMultiblockLogic()).getController();
            alveary.reassemble();
            BlockPos referenceCoord = alveary.getReferenceCoord();
            NetworkUtil.sendNetworkPacket(new PacketAlvearyChange(referenceCoord), referenceCoord, worldIn);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("block.forestry.alveary_tooltip"));
        } else {
            ItemTooltipUtil.addShiftInformation(stack, world, tooltip, flag);
        }
    }

    private static enum AlvearyPlainType implements IStringSerializable
    {
        NORMAL,
        ENTRANCE,
        ENTRANCE_LEFT,
        ENTRANCE_RIGHT;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }

    private static enum State implements IStringSerializable
    {
        ON,
        OFF;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

