/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.blocks;

import com.google.common.collect.ImmutableMap;
import forestry.apiculture.tiles.TileCandle;
import forestry.core.blocks.IColoredBlock;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.RenderUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.TorchBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockCandle
extends TorchBlock
implements IColoredBlock,
ITileEntityProvider {
    private static final ImmutableMap<DyeColor, Integer> colours;
    public static final Set<Item> lightingItems;
    public static final String COLOUR_TAG_NAME = "colour";
    public static final EnumProperty<State> STATE;

    public BlockCandle() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200943_b(0.0f).func_200947_a(SoundType.field_185848_a).func_200942_a().func_200946_b(), (IParticleData)ParticleTypes.field_197631_x);
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(STATE, (Comparable)((Object)State.OFF)));
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileCandle();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{STATE});
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState blockState, IWorld world, BlockPos pos, BlockPos blockPos) {
        TileCandle tileCandle = TileUtil.getTile((IBlockReader)world, pos, TileCandle.class);
        return (BlockState)state.func_206870_a(STATE, (Comparable)((Object)(tileCandle != null && tileCandle.isLit() ? State.ON : State.OFF)));
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        TileCandle candle = TileUtil.getTile(world, pos, TileCandle.class);
        if (candle != null && candle.isLit()) {
            return 14;
        }
        return 0;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult rayTraceResult) {
        TileCandle tileCandle = TileUtil.getTile((IBlockReader)worldIn, pos, TileCandle.class);
        if (tileCandle == null) {
            return ActionResultType.FAIL;
        }
        boolean isLit = tileCandle.isLit();
        ActionResultType flag = ActionResultType.PASS;
        boolean toggleLitState = true;
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (!isLit) {
            if (heldItem.func_190926_b() || !lightingItems.contains(heldItem.func_77973_b())) {
                toggleLitState = false;
            } else if (ItemStackUtil.equals((Block)this, heldItem) && BlockCandle.isLit(heldItem)) {
                toggleLitState = true;
            }
        }
        if (!heldItem.func_190926_b()) {
            if (ItemStackUtil.equals((Block)this, heldItem)) {
                if (!BlockCandle.isLit(heldItem)) {
                    if (heldItem.func_77978_p() != null && heldItem.func_77978_p().func_74764_b(COLOUR_TAG_NAME)) {
                        tileCandle.setColour(heldItem.func_77978_p().func_74762_e(COLOUR_TAG_NAME));
                    } else {
                        tileCandle.setColour(0xFFFFFF);
                    }
                    RenderUtil.markForUpdate(pos);
                } else {
                    toggleLitState = true;
                }
                flag = ActionResultType.SUCCESS;
            } else {
                boolean dyed = BlockCandle.tryDye(heldItem, isLit, tileCandle);
                if (dyed) {
                    RenderUtil.markForUpdate(pos);
                    toggleLitState = false;
                    flag = ActionResultType.SUCCESS;
                }
            }
        }
        if (toggleLitState) {
            tileCandle.setLit(!isLit);
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a(STATE, (Comparable)((Object)(tileCandle.isLit() ? State.ON : State.OFF))), 1);
            RenderUtil.markForUpdate(pos);
            worldIn.func_217381_Z().func_76320_a("checkLight");
            worldIn.func_72863_F().func_212863_j_().func_215568_a(pos);
            worldIn.func_217381_Z().func_76319_b();
            flag = ActionResultType.SUCCESS;
            worldIn.func_184133_a(playerIn, pos, !isLit ? (heldItem.func_77973_b() == Items.field_151033_d ? SoundEvents.field_187649_bu : SoundEvents.field_187643_bs) : SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.75f, worldIn.field_73012_v.nextFloat() * 0.4f + 0.8f);
        }
        return flag;
    }

    private static boolean tryDye(ItemStack held, boolean isLit, TileCandle tileCandle) {
        for (Map.Entry colour : colours.entrySet()) {
            for (Item item : ((DyeColor)colour.getKey()).getTag().func_230236_b_()) {
                if (held.func_77973_b() != item) continue;
                if (isLit) {
                    tileCandle.setColour((Integer)colour.getValue());
                } else {
                    tileCandle.addColour((Integer)colour.getValue());
                }
                return true;
            }
        }
        return false;
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(this.getCandleDrop((TileEntity)builder.func_216024_a(LootParameters.field_216288_h)));
        return drops;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return this.getCandleDrop(world, pos);
    }

    private ItemStack getCandleDrop(IBlockReader world, BlockPos pos) {
        return this.getCandleDrop(world.func_175625_s(pos));
    }

    private ItemStack getCandleDrop(@Nullable TileEntity tileEntity) {
        if (!(tileEntity instanceof TileCandle)) {
            return new ItemStack((IItemProvider)this);
        }
        TileCandle tileCandle = (TileCandle)tileEntity;
        int colour = tileCandle.getColour();
        ItemStack itemStack = new ItemStack((IItemProvider)this);
        if (colour != 0xFFFFFF) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74768_a(COLOUR_TAG_NAME, colour);
            itemStack.func_77982_d(tag);
        }
        return itemStack;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileCandle tileCandle = TileUtil.getTile((IBlockReader)world, pos, TileCandle.class);
        if (tileCandle != null) {
            int colour = BlockCandle.getColourValueFromItemStack(stack);
            boolean isLit = BlockCandle.isLit(stack);
            tileCandle.setColour(colour);
            tileCandle.setLit(isLit);
            if (tileCandle.isLit()) {
                world.func_217381_Z().func_76320_a("checkLight");
                world.func_72863_F().func_212863_j_().func_215568_a(pos);
                world.func_217381_Z().func_76319_b();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileCandle tileCandle = TileUtil.getTile((IBlockReader)worldIn, pos, TileCandle.class);
        if (tileCandle != null && tileCandle.isLit()) {
            super.func_180655_c(stateIn, worldIn, pos, rand);
        }
    }

    private static int getColourValueFromItemStack(ItemStack itemStack) {
        CompoundNBT tag;
        int value = 0xFFFFFF;
        if (itemStack.func_77978_p() != null && (tag = itemStack.func_77978_p()).func_74764_b(COLOUR_TAG_NAME)) {
            value = tag.func_74762_e(COLOUR_TAG_NAME);
        }
        return value;
    }

    public static boolean isLit(ItemStack itemStack) {
        return false;
    }

    public static void addItemToLightingList(Item item) {
        lightingItems.add(item);
    }

    public ItemStack getUnlitCandle(int amount) {
        return new ItemStack((IItemProvider)this, amount);
    }

    public ItemStack getLitCandle(int amount) {
        return new ItemStack((IItemProvider)this, amount);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int colorMultiplier(BlockState state, @Nullable IBlockReader worldIn, @Nullable BlockPos pos, int tintIndex) {
        TileCandle tileCandle;
        if (worldIn != null && pos != null && (tileCandle = TileUtil.getTile(worldIn, pos, TileCandle.class)) != null) {
            return tileCandle.getColour();
        }
        return 0xFFFFFF;
    }

    static {
        STATE = EnumProperty.func_177709_a((String)"state", State.class);
        colours = ImmutableMap.builder().put((Object)DyeColor.WHITE, (Object)new Color(255, 255, 255).getRGB()).put((Object)DyeColor.ORANGE, (Object)new Color(219, 125, 62).getRGB()).put((Object)DyeColor.MAGENTA, (Object)new Color(255, 20, 255).getRGB()).put((Object)DyeColor.LIGHT_BLUE, (Object)new Color(107, 138, 201).getRGB()).put((Object)DyeColor.YELLOW, (Object)new Color(255, 255, 20).getRGB()).put((Object)DyeColor.LIME, (Object)new Color(20, 255, 20).getRGB()).put((Object)DyeColor.PINK, (Object)new Color(208, 132, 153).getRGB()).put((Object)DyeColor.GRAY, (Object)new Color(74, 74, 74).getRGB()).put((Object)DyeColor.LIGHT_GRAY, (Object)new Color(154, 161, 161).getRGB()).put((Object)DyeColor.CYAN, (Object)new Color(20, 255, 255).getRGB()).put((Object)DyeColor.PURPLE, (Object)new Color(126, 61, 181).getRGB()).put((Object)DyeColor.BLUE, (Object)new Color(20, 20, 255).getRGB()).put((Object)DyeColor.BROWN, (Object)new Color(79, 50, 31).getRGB()).put((Object)DyeColor.GREEN, (Object)new Color(53, 70, 27).getRGB()).put((Object)DyeColor.RED, (Object)new Color(150, 52, 48).getRGB()).put((Object)DyeColor.BLACK, (Object)new Color(20, 20, 20).getRGB()).build();
        lightingItems = new HashSet<Item>(Arrays.asList(Items.field_151033_d, Items.field_151145_ak, Item.func_150898_a((Block)Blocks.field_150478_aa)));
    }

    static enum State implements IStringSerializable
    {
        ON("on"),
        OFF("off");

        private final String name;

        private State(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

