/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.entities;

import forestry.api.apiculture.DefaultBeeListener;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.apiculture.BeehouseBeeModifier;
import forestry.apiculture.InventoryBeeHousing;
import forestry.apiculture.blocks.BlockTypeApiculture;
import forestry.apiculture.entities.MinecartEntityBeeHousingBase;
import forestry.apiculture.features.ApicultureBlocks;
import forestry.apiculture.features.ApicultureEntities;
import forestry.apiculture.features.ApicultureItems;
import forestry.apiculture.gui.ContainerMinecartBeehouse;
import forestry.apiculture.gui.GuiBeeHousing;
import forestry.apiculture.items.ItemMinecartBeehousing;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.network.PacketBufferForestry;
import forestry.modules.features.FeatureBlock;
import forestry.modules.features.FeatureItem;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class MinecartEntityBeehouse
extends MinecartEntityBeeHousingBase {
    private static final IBeeModifier beeModifier = new BeehouseBeeModifier();
    private static final IBeeListener beeListener = new DefaultBeeListener();
    private final InventoryBeeHousing beeInventory = new InventoryBeeHousing(9);

    public MinecartEntityBeehouse(EntityType<? extends MinecartEntityBeehouse> type, World world) {
        super((EntityType<? extends MinecartEntityBeeHousingBase>)type, world);
        this.beeInventory.disableAutomation();
    }

    public MinecartEntityBeehouse(World world, double posX, double posY, double posZ) {
        super(ApicultureEntities.BEE_HOUSE_MINECART.entityType(), world, posX, posY, posZ);
        this.beeInventory.disableAutomation();
    }

    @Override
    public String getHintKey() {
        return "bee.house";
    }

    @Override
    public BlockState func_174897_t() {
        return ((FeatureBlock)ApicultureBlocks.BASE.get(BlockTypeApiculture.BEE_HOUSE)).defaultState();
    }

    @Override
    public ItemStack getCartItem() {
        return ((FeatureItem)ApicultureItems.MINECART_BEEHOUSING.get(ItemMinecartBeehousing.Type.BEE_HOUSE)).stack();
    }

    @Override
    public Iterable<IBeeModifier> getBeeModifiers() {
        return Collections.singleton(beeModifier);
    }

    @Override
    public Iterable<IBeeListener> getBeeListeners() {
        return Collections.singleton(beeListener);
    }

    @Override
    public IBeeHousingInventory getBeeInventory() {
        return this.beeInventory;
    }

    @Override
    protected IInventoryAdapter getInternalInventory() {
        return this.beeInventory;
    }

    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new ContainerMinecartBeehouse(windowId, player.field_71071_by, this, false, GuiBeeHousing.Icon.BEE_HOUSE);
    }

    @Override
    protected void openGui(ServerPlayerEntity player) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)this, p -> {
            PacketBufferForestry fP = new PacketBufferForestry((ByteBuf)p);
            fP.writeEntityById(this.getEntity());
            fP.writeBoolean(false);
            fP.writeEnum(GuiBeeHousing.Icon.BEE_HOUSE, GuiBeeHousing.Icon.values());
        });
    }
}

