/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.flowers;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.genetics.BeeChromosomes;
import forestry.api.apiculture.genetics.IBee;
import forestry.api.core.IBlockPosPredicate;
import forestry.api.genetics.flowers.IFlowerAcceptableRule;
import forestry.api.genetics.flowers.IFlowerGrowthHelper;
import forestry.api.genetics.flowers.IFlowerGrowthRule;
import forestry.api.genetics.flowers.IFlowerRegistry;
import forestry.apiculture.flowers.Flower;
import forestry.apiculture.flowers.GrowthRuleDirtGrass;
import forestry.apiculture.flowers.GrowthRuleFertilize;
import forestry.apiculture.flowers.GrowthRuleMycelium;
import forestry.apiculture.flowers.GrowthRuleNone;
import forestry.apiculture.flowers.GrowthRuleSnow;
import forestry.core.utils.VectUtil;
import forestry.core.utils.datastructures.BlockStateSet;
import forestry.core.utils.datastructures.WeightedCollection;
import genetics.api.individual.IGenome;
import genetics.api.individual.IIndividual;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public final class FlowerRegistry
implements IFlowerRegistry,
IFlowerGrowthHelper {
    private final HashMultimap<String, IFlowerAcceptableRule> registeredRules = HashMultimap.create();
    private final HashMultimap<String, Block> acceptableBlocks = HashMultimap.create();
    private final Map<String, BlockStateSet> acceptableBlockStates = new HashMap<String, BlockStateSet>();
    private final HashMultimap<String, ITag<Block>> acceptableBlockTags = HashMultimap.create();
    private final HashMultimap<String, Flower> plantableFlowers = HashMultimap.create();
    private final ArrayListMultimap<String, IFlowerGrowthRule> growthRules = ArrayListMultimap.create();
    private final Map<String, WeightedCollection<Flower>> chances = new HashMap<String, WeightedCollection<Flower>>();

    public FlowerRegistry() {
        this.registerVanillaGrowthRules();
    }

    @Override
    public void registerAcceptableFlower(Block block, String ... flowerTypes) {
        for (String flowerType : flowerTypes) {
            if (flowerType == null) {
                throw new NullPointerException("Tried to register flower with null type. " + block);
            }
            this.acceptableBlocks.get((Object)flowerType).add(block);
        }
    }

    @Override
    public void registerAcceptableFlower(ITag<Block> block, String ... flowerTypes) {
        for (String flowerType : flowerTypes) {
            if (flowerType == null) {
                throw new NullPointerException("Tried to register flower with null type. " + block);
            }
            this.acceptableBlockTags.get((Object)flowerType).add(block);
        }
    }

    @Override
    public void registerAcceptableFlower(BlockState blockState, String ... flowerTypes) {
        for (String flowerType : flowerTypes) {
            if (flowerType == null) {
                throw new NullPointerException("Tried to register flower with null type. " + blockState);
            }
            this.getAcceptedBlockStates(flowerType).add(blockState);
        }
    }

    @Override
    public void registerAcceptableFlowerRule(IFlowerAcceptableRule acceptableFlower, String ... flowerTypes) {
        for (String flowerType : flowerTypes) {
            if (flowerType == null) {
                throw new NullPointerException("Tried to register flower with null type. " + acceptableFlower);
            }
            this.registeredRules.put((Object)flowerType, (Object)acceptableFlower);
        }
    }

    @Override
    public void registerPlantableFlower(BlockState blockState, double weight, String ... flowerTypes) {
        Preconditions.checkNotNull((Object)blockState);
        Preconditions.checkArgument((blockState.func_177230_c() != Blocks.field_150350_a ? 1 : 0) != 0, (Object)"Tried to register AIR as a flower. Bad idea.");
        if (weight <= 0.0) {
            weight = 0.0;
        }
        if (weight >= 1.0) {
            weight = 1.0;
        }
        Flower newFlower = new Flower(blockState, weight);
        for (String flowerType : flowerTypes) {
            Preconditions.checkNotNull((Object)flowerType, (Object)("Tried to register flower with null type. " + blockState));
            Set flowers = this.plantableFlowers.get((Object)flowerType);
            flowers.add(newFlower);
            Set<BlockState> blocks = this.getAcceptedBlockStates(flowerType);
            blocks.add(blockState);
            this.chances.remove(flowerType);
        }
    }

    private static Vector3i getArea(IGenome genome, IBeeModifier beeModifier) {
        Vector3i genomeTerritory = genome.getActiveValue(BeeChromosomes.TERRITORY);
        float housingModifier = beeModifier.getTerritoryModifier(genome, 1.0f);
        return VectUtil.scale(genomeTerritory, housingModifier * 3.0f);
    }

    @Override
    public Iterator<BlockPos.Mutable> getAreaIterator(IBeeHousing beeHousing, IBee bee) {
        IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(beeHousing);
        Vector3i area = FlowerRegistry.getArea(bee.getGenome(), beeModifier);
        BlockPos minPos = beeHousing.getCoordinates().func_177982_a(-area.func_177958_n() / 2, -area.func_177956_o() / 2, -area.func_177952_p() / 2);
        BlockPos maxPos = minPos.func_177971_a(area);
        World world = beeHousing.getWorldObj();
        return VectUtil.getAllInBoxFromCenterMutable(world, minPos, beeHousing.getCoordinates(), maxPos);
    }

    private Set<BlockState> getAcceptedBlockStates(String flowerType) {
        return this.acceptableBlockStates.computeIfAbsent(flowerType, k -> new BlockStateSet());
    }

    @Override
    public IBlockPosPredicate createAcceptedFlowerPredicate(String flowerType) {
        Set acceptableRules = this.registeredRules.get((Object)flowerType);
        Set<BlockState> acceptedBlockStates = this.getAcceptedBlockStates(flowerType);
        Set acceptedBlocks = this.acceptableBlocks.get((Object)flowerType);
        Set acceptedBlockTags = this.acceptableBlockTags.get((Object)flowerType);
        return new AcceptedFlowerPredicate(flowerType, acceptableRules, acceptedBlocks, acceptedBlockStates, acceptedBlockTags);
    }

    private static boolean isAcceptedFlower(BlockState blockState, Set<Block> acceptedBlocks, Set<BlockState> acceptedBlockStates, Set<ITag<Block>> acceptedBlockTags) {
        Block block = blockState.func_177230_c();
        return acceptedBlocks.contains(block) || acceptedBlockStates.contains(blockState) || acceptedBlockTags.stream().anyMatch(blockTag -> blockTag.func_230235_a_((Object)block));
    }

    @Override
    public boolean growFlower(String flowerType, World world, IIndividual individual, BlockPos pos, Collection<BlockState> potentialFlowers) {
        if (!this.growthRules.containsKey((Object)flowerType)) {
            return false;
        }
        List growthRules = this.growthRules.get((Object)flowerType);
        Collections.shuffle(growthRules);
        for (IFlowerGrowthRule rule : growthRules) {
            if (!rule.growFlower(this, flowerType, (ServerWorld)world, pos, potentialFlowers)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void registerGrowthRule(IFlowerGrowthRule rule, String ... flowerTypes) {
        Preconditions.checkNotNull((Object)rule);
        for (String flowerType : flowerTypes) {
            this.growthRules.get((Object)flowerType).add(rule);
        }
    }

    @Nullable
    public Flower getRandomPlantableFlower(String flowerType, Random rand) {
        WeightedCollection<Flower> chancesMap = this.getFlowerChances(flowerType);
        return chancesMap.getRandom(rand);
    }

    private WeightedCollection<Flower> getFlowerChances(String flowerType) {
        if (!this.chances.containsKey(flowerType)) {
            WeightedCollection<Flower> flowerChances = new WeightedCollection<Flower>();
            for (Flower flower : this.plantableFlowers.get((Object)flowerType)) {
                if (!flower.isPlantable()) continue;
                flowerChances.put(flower.getWeight(), flower);
            }
            this.chances.put(flowerType, flowerChances);
        }
        return this.chances.get(flowerType);
    }

    private void registerVanillaGrowthRules() {
        this.registerGrowthRule(new GrowthRuleDirtGrass(), "flowersVanilla", "flowersSnow");
        this.registerGrowthRule(new GrowthRuleSnow(), "flowersSnow");
        this.registerGrowthRule(new GrowthRuleMycelium(), "flowersMushrooms");
        this.registerGrowthRule(new GrowthRuleNone(), "flowersEnd");
        this.registerGrowthRule(new GrowthRuleFertilize(Blocks.field_150394_bc, Blocks.field_150393_bb), "flowersGourd");
        this.registerGrowthRule(new GrowthRuleFertilize(Blocks.field_150464_aj), "flowersWheat");
    }

    @Override
    public boolean plantRandomFlower(String flowerType, World world, BlockPos pos, Collection<BlockState> potentialFlowers) {
        WeightedCollection<Flower> chances = this.getFlowerChances(flowerType);
        WeightedCollection<BlockState> potentialChances = new WeightedCollection<BlockState>();
        for (Map.Entry<Double, Flower> entry : chances.entrySet()) {
            Flower flower = entry.getValue();
            BlockState blockState = flower.getBlockState();
            if (!potentialFlowers.contains(blockState)) continue;
            potentialChances.put(entry.getKey(), blockState);
        }
        BlockState blockState = (BlockState)potentialChances.getRandom(world.field_73012_v);
        return blockState != null && world.func_175656_a(pos, blockState);
    }

    private static class AcceptedFlowerPredicate
    implements IBlockPosPredicate {
        private final String flowerType;
        private final Set<IFlowerAcceptableRule> acceptableRules;
        private final Set<Block> acceptedBlocks;
        private final Set<BlockState> acceptedBlockStates;
        private final Set<ITag<Block>> acceptedBlockTags;

        public AcceptedFlowerPredicate(String flowerType, Set<IFlowerAcceptableRule> acceptableRules, Set<Block> acceptedBlocks, Set<BlockState> acceptedBlockStates, Set<ITag<Block>> acceptedBlockTags) {
            this.flowerType = flowerType;
            this.acceptableRules = acceptableRules;
            this.acceptedBlocks = acceptedBlocks;
            this.acceptedBlockStates = acceptedBlockStates;
            this.acceptedBlockTags = acceptedBlockTags;
        }

        @Override
        public boolean test(World world, BlockPos blockPos) {
            BlockState blockState;
            if (world.func_175667_e(blockPos) && !(blockState = world.func_180495_p(blockPos)).func_177230_c().isAir(blockState, (IBlockReader)world, blockPos)) {
                for (IFlowerAcceptableRule acceptableRule : this.acceptableRules) {
                    if (!acceptableRule.isAcceptableFlower(blockState, world, blockPos, this.flowerType)) continue;
                    return true;
                }
                return FlowerRegistry.isAcceptedFlower(blockState, this.acceptedBlocks, this.acceptedBlockStates, this.acceptedBlockTags);
            }
            return false;
        }
    }
}

